/************************************************************************
 ========================================================================
 CORAL 
 (c)  Copyright R. Ramakrishnan and The CORAL Group, 
 University of Wisconsin at Madison.
 (1992) All Rights Reserved.
 Version 0.1
 ========================================================================



 ------------------------------------------------------------------------
 CORAL Version 0.1
 RESEARCH SOFTWARE DISCLAIMER -------------------------------------------
 ------------------------------------------------------------------------

    As unestablished, research software, this program is provided free of 
    charge on an "as is" basis without warranty of any kind, either 
    express or implied.  Acceptance and use of this program constitutes 
    the user's understanding that (s)he will have no recourse for any 
    actual or consequential damages, including, but not limited to, 
    lost profits or savings, arising out of the use of or inability to 
    use this program.  

 ------------------------------------------------------------------------
 USER AGREEMENT ---------------------------------------------------------
 ------------------------------------------------------------------------

     BY ACCEPTANCE AND USE OF THIS EXPERIMENTAL PROGRAM
     THE USER AGREES TO THE FOLLOWING:

     a.  This program is provided free of charge for the user's personal, 
	 non-commercial, experimental use.

     b.  All title, ownership and rights to this program and any copies 
         remain with the copyright holder, irrespective of the ownership 
	 of the media on which the program resides.

     c.  The user is permitted to create derivative works to this program.  
         However, all copies of the program and its derivative works must
         contain the CORAL copyright notice, the UNESTABLISHED SOFTWARE 
         DISCLAIMER and this USER AGREEMENT.

     d.  The user understands and agrees that this program and any 
         derivative works are to be used solely for experimental purposes 
	 and are not to be sold or commercially exploited in any manner 
	 WITHOUT EXPRESS WRITTEN PERMISSION.

     e.  We request that the user supply us with a copy of any changes, 
         enhancements, or derivative works which the user may create,
	 with the user's permission to redistribute it.
	 Copies of such material should be sent to:  CORAL@CS.WISC.EDU

-------------------------------------------------------------------------
*************************************************************************/

#include "magic.h"

/** create_sips() : Creates sips for each rule (including the query) of the
	program,, for each possible adornment.  The sip for the query is 
	generated only for the specific bindings of the query predicate.  
**/


static void get_adorn(Clause *query, BitVector& adorn);
void setup_vars(Clause *rule, ClauseInfo *rule_info);
void gen_sip_rule(ClauseInfo *rule_info, BitVector& adorn);
void cleanup_vars(ClauseInfo *rule_info);
static int sip_exists(Clause *rule, BitVector& adorn, int pred);
static void setup_head_vars(ClauseInfo *rule_info);

extern struct collection pre_ad_rules[1] ;

void create_sips()
{
    BitVector adornment;
    int num_args;
    long j;
    ClauseInfo rule_info[1];

//    get_adorn(query, adornment);
//    setup_vars(query, rule_info);
//    gen_sip_rule(rule_info, adornment);
//    cleanup_vars(rule_info);

    FOR_EACH_RULE(rule, pre_ad_rules) {
	num_args = rule->head->args.count();
	if (num_args > COR_MAX_ARGLIST_SIZE) {
	    fprintf(stderr,
		    "Rule (line %d) has too many args (%d) - ignored\n",
		    rule->line_number, num_args);
	    fflush(stderr);
	    continue;
	}
	setup_vars(rule, rule_info);
	// WARNING:: This code will only work if there are less than
	//		32 arguments!!  
	//		REWRITE IT
	for (j = 0; j < (1 << num_args); j++) {
	    BitVector adorn(num_args, j);
	    gen_sip_rule(rule_info, adornment);
	}
	cleanup_vars(rule_info);
    } END_EACH_RULE
}

/** get_adorn(query, arg):   Gets the adornment corresponding to the query 
	predicate.  Any argument that is a constant is considered bound,
	and all others are free. 
**/

static void get_adorn(Clause *query, BitVector& adorn)
{
    adorn.setlen(query->head->args.count());

    int i=0;
    FOR_EACH_ARG(arg, query->head->args) {
	if (arg->isConstant()) {
	    adorn.set(i);
	i++;
	}
    } END_EACH_ARG
}

// Helper function called (by setup_vars) on each variable to
// set var_defining_pred to the first predicate where the variable occurs.

int setup_arg(VarArg *arg, void *data)
{
    ClauseInfo *rule_info = (ClauseInfo*)data;
    if (rule_info->var_defining_pred[arg->var] == -1)
	rule_info->var_defining_pred[arg->var] = rule_info->i;
    return 0;
}

/** setup_vars(rule, rule_info) :
	Sets up data structures (in rule_info) to deal with variables :
	var_head_arg_pos - set up by calling setup_head_vars(rule).
	var_defining_pred - set up by going through each argument of each 
		body predicate and using scan_vars to call
		setup_arg on each variable.
**/

void setup_vars(Clause *rule, ClauseInfo *rule_info)
{
    int i;
    int num_args;
    register BitVector *cur_var_bits;
    rule_info->rule = rule;
    rule_info->var_defining_pred = new int[rule->num_var_names];
    rule_info->var_head_arg_pos = cur_var_bits =
	new BitVector[rule->num_var_names];

    num_args = rule->head->args.count();
    for (i = 0; i < rule->num_var_names; i++, cur_var_bits++) {
	rule_info->var_defining_pred[i] = -1;
	cur_var_bits->setlen(num_args);
    }
    setup_head_vars(rule_info);
    for (i = 0; i < rule->num_preds; i++) {
	FOR_EACH_ARG(arg, rule->preds[i]->args) {
	    // Goes though an argument ( of the i'th body 
	    // predicate, and for all variables that occur in it, it sets the
	    // var_defining_pred to i, if it has not already been set.
	    // Thus  var_defining_pred is set to the first predicate where the
	    // variable occurs.
	    rule_info->i = i;
	    arg->scan_vars(rule_info, setup_arg);
	} END_EACH_ARG
    }
}

// Sets the corresoponding bit of the variable
// position in var_head_arg_pos to indicate that the variable occurs
// in that position.

static int setup_head_arg(VarArg *arg, void *data)
{
    ClauseInfo *rule_info = (ClauseInfo*)data;
    rule_info->var_head_arg_pos[arg->var].set(rule_info->i);
    return 0;
}

/** setup_head_vars(rule_info) : Goes through the head of a rule, and for each
	variable, sets the bits in var_head_arg_pos to indicate which 
	argument positions in the head the variable occurs in.  This is used
	later to check if the variable is bound. 
**/

static void setup_head_vars(ClauseInfo *rule_info)
{
    int i = 0;

    FOR_EACH_ARG(arg, rule_info->rule->head->args) {
	rule_info->i = i++;
	arg->scan_vars(rule_info, setup_head_arg);
    } END_EACH_ARG
}

void cleanup_vars(ClauseInfo *rule_info)
{
    delete  rule_info->var_defining_pred;
    //delete  rule_info->var_head_arg_pos;
    // WHY WAS THIS CAUSING A MEMORY OVERWRITE ????- PRAVEEN
}


/** ??? The following function (and its calls) can be cleaned up to make 
	it more efficient in generating sips **/

static int gen_sip_var(VarArg *arg, void *data)
{
    register ClauseInfo *rule_info = (ClauseInfo*)data;
    if (rule_info->sip_generated[arg->var])
	return 0;
    if ((rule_info->var_head_arg_pos[arg->var]
	 & *rule_info->adorn)
	||
	((rule_info->var_defining_pred[arg->var] < rule_info->i) &&
	 (rule_info->var_defining_pred[arg->var] != -1))) {

	// We have checked that the variable was defined in the head and
	// that it occurs in a bound position of the adornment  OR the
	// defining predicate of this variable occurs earlier in the
	// body. In either case the variable is bound and has a sip arc
	// entering the predicate occurrence with this variable as a label.

	struct sip *sip = new struct sip;
	sip->tail = *rule_info->tail;
	sip->head = rule_info->i + 1;	/* 0 indicates head of rule */
	sip->bound_vars.set(arg->var);
	/* linking it up to the rule */
	sip->next = rule_info->cur_sips->sip_list;
	rule_info->cur_sips->sip_list = sip;
	/* Have generated sip arc for this variable. */
	rule_info->sip_generated[arg->var] = 1;
    }
    return 0;
}

/** gen_sip_rule( rule_info, adorn):
	This function fills in sips for the specified rule and adornment,
	for each body literal for which the user has not specified sips.
	It generates sips according to the left-right ordering.
**/

void gen_sip_rule(ClauseInfo *rule_info, BitVector& adorn)
{
    struct sips *sips;
    char *sip_generated;
    int i, j;
    Clause *rule = rule_info->rule;

    /* Check if there is sips node for this adorn */
    for(sips=rule->sips;sips;sips=sips->next)
	if (sips->adorn==adorn)
	    break;
    if (!sips) {  
    	sips = new struct sips;	/* Create a new sips node and link it up to
				 * the rule node.  */
    	sips->next = rule->sips;
    	rule->sips = sips;
    	sips->adorn = adorn;
    	sips->sip_list = NULL;
    }

    /* Has a sip been generated for this var. in this predicate occurrence */
    sip_generated = new char [rule->num_var_names];

    BitVector tail(rule->num_preds + 1);

    for (i = 0; i < rule->num_preds; i++) {
	/*
	 * this is a total sip in that every predicate occurrence to the left
	 * of a predicate occurrence (including the head) is part of the tail
	 * of every sip arc entering this predicate occurrence. bit 0
	 * corresponds to the head and bit i corresponds to the i'th body
	 * predicate (with index i-1 in preds[]) 
	 */
	tail.set(i);

        if (sip_exists(rule, adorn,i))
	    continue;

	for (j = 0; j < rule->num_var_names; j++)
	    sip_generated[j] = 0;	/* in case of multiple occurrences of
					 * the same variable in a predicate
					 * occurrence, we desire to generate
					 * only one sip-arc */
	FOR_EACH_ARG(arg, rule->preds[i]->args) {
	    rule_info->sip_generated = sip_generated;
	    rule_info->i = i;
	    rule_info->adorn = &adorn;
	    rule_info->tail = &tail;
	    rule_info->cur_sips=sips;
	    arg->scan_vars(rule_info, gen_sip_var);
	    if ( ! rule_info->cur_sips->sip_list) {
			/* None of the variables was bound.  Create a sip anyway
			    with no variable bound.
			*/
		
		struct sip *sip = new struct sip;
		sip->tail = *rule_info->tail;
		sip->head = i + 1;	/* 0 indicates head of rule */
		/* linking it up to the rule */
		sip->next = rule_info->cur_sips->sip_list;
		rule_info->cur_sips->sip_list = sip;
	    }
	} END_EACH_ARG
    }
    delete sip_generated;
}

static int sip_exists(Clause *rule, BitVector& adorn, int pred_num)
{
    struct sips *sips;
    struct sip *sip;

    for (sips = rule->sips; sips != NULL; sips = sips->next) {
	if (adorn == sips->adorn) {
	   for(sip=sips->sip_list;sip;sip=sip->next)
		if (sip->head == pred_num+1)  return (1);		
			/* pred_num+1 is used since in the sip structure
			* an index of 0 means the head, rather than the 
			* 0'th body predicate.
			* Since a sip with the same adornment and head exists
			* we don't generate sip arcs corresponding
			* to this adornment */
	}
    }
    return (0);

}
