/************************************************************************
 ========================================================================
 CORAL 
 (c)  Copyright R. Ramakrishnan and The CORAL Group, 
 University of Wisconsin at Madison.
 (1992) All Rights Reserved.
 Version 0.1
 ========================================================================



 ------------------------------------------------------------------------
 CORAL Version 0.1
 RESEARCH SOFTWARE DISCLAIMER -------------------------------------------
 ------------------------------------------------------------------------

    As unestablished, research software, this program is provided free of 
    charge on an "as is" basis without warranty of any kind, either 
    express or implied.  Acceptance and use of this program constitutes 
    the user's understanding that (s)he will have no recourse for any 
    actual or consequential damages, including, but not limited to, 
    lost profits or savings, arising out of the use of or inability to 
    use this program.  

 ------------------------------------------------------------------------
 USER AGREEMENT ---------------------------------------------------------
 ------------------------------------------------------------------------

     BY ACCEPTANCE AND USE OF THIS EXPERIMENTAL PROGRAM
     THE USER AGREES TO THE FOLLOWING:

     a.  This program is provided free of charge for the user's personal, 
	 non-commercial, experimental use.

     b.  All title, ownership and rights to this program and any copies 
         remain with the copyright holder, irrespective of the ownership 
	 of the media on which the program resides.

     c.  The user is permitted to create derivative works to this program.  
         However, all copies of the program and its derivative works must
         contain the CORAL copyright notice, the UNESTABLISHED SOFTWARE 
         DISCLAIMER and this USER AGREEMENT.

     d.  The user understands and agrees that this program and any 
         derivative works are to be used solely for experimental purposes 
	 and are not to be sold or commercially exploited in any manner 
	 WITHOUT EXPRESS WRITTEN PERMISSION.

     e.  We request that the user supply us with a copy of any changes, 
         enhancements, or derivative works which the user may create,
	 with the user's permission to redistribute it.
	 Copies of such material should be sent to:  CORAL@CS.WISC.EDU

-------------------------------------------------------------------------
*************************************************************************/
/****************************************************************************/
/*	reduce.h
*/
/****************************************************************************/

#define COR_TRIVIAL 0		/* trivial unit rule (p[a] :- p[a].) */
#define COR_NONTRIVIAL 1		/* nontrivial unit rule */

struct unitR {
	struct rule *r;		/* pointer to the unit rule */
	int t;			/* trivial/nontrivial rule? */
};

/****************************************************************************/
/* struct projection:
   edge represents the edges between the variables of the head predicate of 
   rule h and the pInd(th) predicate of rule t.  edge[i] represents edges
   going out from the i th argument of the head predicate of rule h.
   a 1 in bit position j of edge[i] corresponds to the j th argument
   of the pInd(th) predicate of rule t.
*/
/****************************************************************************/
struct projection {	   /* argument projections, include composite ones */
	struct rule *h;	   /* rule of the first pred of the arg projection */
	struct rule *t;    /* rule of the second pred of the arg projection */
	struct rule *b;	   /* back pointer to the rule preceeding rule t */
	int ruleNum;	   /* DEBUG */		
	int headRuleNum;   /* DEBUG */
	unsigned int edge[COR_MAX_VARS];
	int pInd;	   /* pred index in the rule of the second predicate */
	int used;	   /* for unit rule projection: if the unit rule is */
			   /* useful or not */
};

/****************************************************************************/
