/*****************************************************************************/
/* main.C
*/
/*****************************************************************************/
#include	"globals.h"
#include 	"exist.h"
#include	"rules.h"
#include	"funct.h"
#include	"parser.h"

 FILE *outf;

int	optAdorn=0, optConnect=0, optReduce=0, optDefunct=0;

// This specifies the size of the TermList structure
int	orig_rule_count = 0 ;

extern void defunctify(struct rule *, TermList **);
extern void functify(struct rule *, TermList **) ;

extern void print_factor(struct collection *, FILE *, int);

extern "C" int yyparse() ;



static void printUsage()
{
	fprintf(stderr,"Usage: exist [-l] [-a] [-c] [-r] < infile > outfile\n");
	fprintf(stderr,"	-a	Print the program with initial adornments\n");
	fprintf(stderr,"	-c	Print the program with boolean predicates identified\n");
	fprintf(stderr,"	-r	Print the partially optimized program\n");
	fprintf(stderr,"	-d	Print the Extended Datalog program\n");
}
/***************************************************************************/
static void mark_basepreds(struct collection *rules)
{
    int		 p ;

    FOR_EACH_RULE(r, rules) {
	for (p=0; p < r->num_preds; ++p)
	    r->preds[p]->base_pred =
		HashNone(SymbolLookup(rules->tab, r->preds[p]->pred)->arg);
    } END_EACH_RULE
}

/***************************************************************************/

void do_exist_rewriting() 
{
	if (!parserStruct.CurModule.UseExistOpt) {
	    print_factor(parserStruct.rules,  outf, 0);
	    return ;
	}

	mark_basepreds(parserStruct.rules) ;

	orig_rule_count = parserStruct.rules->count ;
	TermList **terms = new TermList*[orig_rule_count] ;

	defunctify((struct rule *)(parserStruct.rules->chain), terms) ;
	if (optDefunct) {
		fprintf(stderr, "Defunctification performed !!\n");
		printAdorn((struct rule *)(parserStruct.rules->chain), 0);
		fprintf(stderr, "\n\n");
	}

	parserStruct.rules->chain = (Link *)
	  adorn((struct rule *)(parserStruct.rules->chain));
	if (!parserStruct.rules->chain) {
	  fprintf(stderr, "No rules defining exported query predicate!!\n");
	  return;;
	}
	
	if (optAdorn) {
		fprintf(stderr, "\nAdorned rules:\n");
		printAdorn((struct rule *)(parserStruct.rules->chain), 0);
		fprintf(stderr, "\n\n");
	}

	parserStruct.rules->chain = (Link *)
	  connect((struct rule *)(parserStruct.rules->chain));

	if (optConnect) {
		fprintf(stderr, "\nConnected components of the rule bodies computed:\n");
		printAdorn((struct rule *)(parserStruct.rules->chain), 0);
	}

	parserStruct.rules->chain = (Link *)
	  reduce((struct rule *)(parserStruct.rules->chain));
	if (optReduce) {
		fprintf(stderr, "\nSome rules were deleted\n");
		fprintf(stderr, "without changing the set of answers computed for the query:\n");
		printAdorn((struct rule *)(parserStruct.rules->chain), 0);
	}

	parserStruct.rules->chain = (Link *)
	  cleanup((struct rule *)(parserStruct.rules->chain));

	functify((struct rule *)(parserStruct.rules->chain), terms) ;

	parserStruct.CurModule.UseExistOpt = 0;
   	print_exist((struct rule *)(parserStruct.rules->chain),  outf);
}

/***************************************************************************/
main(int ac, char ** av)
{
    int i;

	for (i=1; i<ac && *av[i]=='-'; ++i) {
	    switch (av[i][1]) {
	   	case 'a':
			optAdorn = 1;
			break;
		case 'd':
			optDefunct = 1 ;
			break;
	   	case 'c':
			optConnect = 1;
			break;
	   	case 'r':
			optReduce = 1;
			break;
		default:
			printUsage();
			exit(1);
	    }
	}

	outf = stdout ;

	exEnv.C_exec_mode = COR_DOING_EXIST;
	parseEnv.set_prompt(0);
	init_coral(av[0]) ;

	for(;;) {
	    parserStruct.rule_list = NULL;
	    parseEnv.C_at_end_module = 0;
	    if (yyparse()) {
		printf("syntax error -- quitting\n");
		exit(1);
            }
	    if (parseEnv.C_at_end_module)
		do_exist_rewriting();
	    else if (parserStruct.rule_list) {
	        fprintf(stderr, "CORAL::exist: Warning - end_module missing\n");
	        do_exist_rewriting();
	    }
	    else break;
	}
	exit_coral();
	exit(0);
 }


/***************************************************************************/
