/************************************************************************
 ========================================================================
 CORAL 
 (c)  Copyright R. Ramakrishnan and The CORAL Group, 
 University of Wisconsin at Madison.
 (1992) All Rights Reserved.
 Version 0.1
 ========================================================================



 ------------------------------------------------------------------------
 CORAL Version 0.1
 RESEARCH SOFTWARE DISCLAIMER -------------------------------------------
 ------------------------------------------------------------------------

    As unestablished, research software, this program is provided free of 
    charge on an "as is" basis without warranty of any kind, either 
    express or implied.  Acceptance and use of this program constitutes 
    the user's understanding that (s)he will have no recourse for any 
    actual or consequential damages, including, but not limited to, 
    lost profits or savings, arising out of the use of or inability to 
    use this program.  

 ------------------------------------------------------------------------
 USER AGREEMENT ---------------------------------------------------------
 ------------------------------------------------------------------------

     BY ACCEPTANCE AND USE OF THIS EXPERIMENTAL PROGRAM
     THE USER AGREES TO THE FOLLOWING:

     a.  This program is provided free of charge for the user's personal, 
	 non-commercial, experimental use.

     b.  All title, ownership and rights to this program and any copies 
         remain with the copyright holder, irrespective of the ownership 
	 of the media on which the program resides.

     c.  The user is permitted to create derivative works to this program.  
         However, all copies of the program and its derivative works must
         contain the CORAL copyright notice, the UNESTABLISHED SOFTWARE 
         DISCLAIMER and this USER AGREEMENT.

     d.  The user understands and agrees that this program and any 
         derivative works are to be used solely for experimental purposes 
	 and are not to be sold or commercially exploited in any manner 
	 WITHOUT EXPRESS WRITTEN PERMISSION.

     e.  We request that the user supply us with a copy of any changes, 
         enhancements, or derivative works which the user may create,
	 with the user's permission to redistribute it.
	 Copies of such material should be sent to:  CORAL@CS.WISC.EDU

-------------------------------------------------------------------------
*************************************************************************/

/***************************************************************************/

/*****          Implements Magic, Supplementary Magic and
		Context Rule Rewriting (as in Kemp,
		Ramamohanrao & Somogyi(VLDB 90))                        *****/

/***************************************************************************/
/*

1) What do I do about opt_share_functors and debugmagic ??

2) Factoring and SupMagicIndexing do not co-exist. If both options are
   set, supplementary magic with supmagicindexing is done. Factoring is not.
*/


#include 	"factor.h"
#include	"funct.h"
#include "magic-externs.h"
#ifndef UNIX_HP
#include        <math.h>
#endif

 FILE *outf = stdout;

int	optAdorn=0, optFactor=0, optDefunct=0;

// Used as extern by funct/defunct code
int	orig_rule_count = 0 ;

// Extinct code used these as externs. Targeted for removal
int listing = 0 ;
int adorn_type = 0;

// Magic code needs these as externs
int opt_share_functors = 0 ;
int debugmagic = 0 ;

struct collection pre_ad_rules[1] ;
struct collection factor_rules[1] ;
struct collection magic_rules[1] ;

extern int show_prompt ;
extern Scc *SccList ;

extern void defunctify(struct rule *, TermList **);
extern void functify(struct rule *, TermList **) ;
extern "C" int yyparse() ;

extern void sprint_pred_name(char *buf, char *name, char *adorn);
extern int find_predicates_invoked_from(Predicate *pred);
extern void initialize_scc_structs();
extern int has_grouping_args(ArgList &args);
extern void COR_set_use_ordsearch(ModuleInfo&, int val);
extern void COR_set_use_factoring(ModuleInfo&, int val);
extern void mark_all_as_derived(struct collection *rules);

/***************************************************************************/
static void printUsage()
{
	fprintf(stderr,"Usage: factor [-l] [-a] [-c] [-r] < infile > outfile\n");
	fprintf(stderr,"	-a	Print the program with initial adornments\n");
	fprintf(stderr,"	-f	Print the program with factoring status of rules\n");
	fprintf(stderr,"	-d	Print the Extended Datalog program\n");
}


/***************************************************************************/
static void mark_scc(Scc *scc, LinearKind kind)
{
   for (Predicate *pred = scc->preds; pred != NULL; pred = pred->next) {
	Clause *clause = pred->clauses;
	for (; clause != *pred->clause_tail; clause = clause->pnext) {
	    if (!clause->seen) continue;
	    clause->factor_status = (int)kind ;
	}
   }
}

static void check_ord_search(ParserStruct &parserStruct)
{
  //
  // this is used to determine whether the module needs to be computed
  // using Ordered Search.
  // there are two cases:
  // (1) if there is aggregation in the head, and a derived literal in the
  //     body
  // (2) if there is genuine negation in the body of the rule,
  //
  // this should work for both magic and supmagic. i'm not sure about
  // supmagic -- Praveen
  //

  if (parserStruct.CurModule.UseOrdSearch) return;
  
  FOR_EACH_RULE(adrule, parserStruct.rules) {
    for (int i=0; i < adrule->num_preds; ++i)
      if (!adrule->preds[i]->base_pred) {
        // check if there is aggregation in the head
        if (has_grouping_args(adrule->head->args)) {
          COR_set_use_ordsearch(parserStruct.CurModule, 1);
          return ;
        }
        // check if there is genuine negation in the head of the rule
        if (adrule->preds[i]->negated) {
	  // negated and derived predicates
	  COR_set_use_ordsearch(parserStruct.CurModule, 1);
	  return ;
        }
      }
  } END_EACH_RULE
      
}


/**************************************************************************
Assigns linear status to the rules that define the predicates reachable
from the exported predicates. For each exported predicate, an SCC analysis 
is performed, and the rules in each scc are analysed independently.
Factoring can be performed at any level of such stratified rules.
For those sccs that cannot be factored, magic transformation is done.

**************************************************************************/
static void find_status()
{
// PRAVEEN What happens if there is more than one such exported pred ???
// Answer :: There is a fixed scc structure for the rules, irrespective
//	     of the exported predicates. So the same rule cannot be
//	     given one linear status for one exported predicate, and
//	     a different status for another.

    for (ExportInfo *export_info = parserStruct.CurModule.ExportedPreds;
	export_info != NULL; export_info = export_info->next) {

	Name query_symbol;
	Name exported_name = export_info->pred_name;
	int query_arity;

	if (export_info->adorn_symbol == 0) {
	    query_arity = 0;
	    query_symbol = exported_name;
	}
	else {
	    query_arity = (int) export_info->adorn_symbol->length();
	    query_symbol = EnterSymbol(exported_name->string());
	}

	export_info->predicate = LookupPredicate(parserStruct, 
						 query_symbol, query_arity);
	if (!export_info->predicate) {
	    fprintf(stderr,
		"Error: Exported predicate %s not defined in module\n",
		query_symbol->string() );
	    continue;
	}

	// Do Scc (Strongly Connected Components) analysis.
	FOR_ALL_RULES(clause) {
	    clause->seen = 0;

	    clause->recursive = 0;
	    for (int ipred = 0; ipred < clause->num_preds; ipred++) {
		clause->preds[ipred]->predicate->work = NULL;
		clause->preds[ipred]->predicate->mark = 0;
	    }
	} END_EACH_RULE
	initialize_scc_structs() ;

	find_predicates_invoked_from(export_info->predicate) ;

	for (Scc* scc = SccList; scc != NULL; scc = scc->next) {
	  Predicate *pred; Clause *clause; int ipred;

// Use the scc->recursive field to specify whether the scc contains
// more than one recursive predicate.

// If the module is not to be factored, do magic instead

	if ((!parserStruct.CurModule.UseFactoring) || (parserStruct.CurModule.SupMagicIndexing)) {
	  mark_scc(scc, COR_NON_LINEAR) ;
	  continue ;
	}

	  scc->recursive = 0 ;

	  for (pred = scc->preds; pred != NULL; pred = pred->next) {
	    clause = pred->clauses;
	    for (; clause != *pred->clause_tail; clause = clause->pnext) {
	      if (!clause->seen) continue;
	      for (ipred = 1; ipred <= clause->num_preds; ipred++) {
		Predicate *child = clause->preds[ipred-1]->predicate;
		if (child->scc == scc) clause->recursive = 1 ;
		if ((child->scc == scc) && (child != pred)
		    && (!clause->preds[ipred-1]->base_pred)) {
		  // Mutually recursive scc !!
		    scc->recursive = 1 ;
		  break ;
		}
		if (scc->recursive) break ;
	      }
	      if (scc->recursive) break ;
	    }
	    if (scc->recursive) break ;
	  }

	  if (scc->recursive) {
	    mark_scc(scc, COR_NON_LINEAR) ;
	    continue ;
	  }

	  for (pred = scc->preds; pred != NULL; pred = pred->next) {
	    if (pred->scc == scc) break ;
          }
	  // At this stage, pred contains the only derived predicate
	  //	of the scc
	  if (pred == NULL) {
		fprintf(stderr, "SOMETHING WRONG HERE !\n");
		break ;
	  }

/*
	  if (non_factor_pred(pred) {
		mark_scc(scc, COR_NON_LINEAR) ;
		continue ;
	  }

*/

/*
	  int is_pseudo_lt_linear = 0;
*/
	  clause = pred->clauses ;
	  for (; clause != *pred->clause_tail; clause = clause->pnext) {
	    if (!clause->seen) continue;
	    if (!assign_linear_status(clause)) {
	      // Use recursive field to signify that this scc
	      // is not factorable
	      scc->recursive = 1 ;
	      break ;
	    }
	    // As pointed out by David Kemp, pseudo-lt-linear rules
	    // are not compatible with other kinds of linear rules.
	    // Also, in the case of pseudo-lt-linear rules and
	    // lt-linear rules, context rewriting is only as
	    // efficient as magic, so might as well do magic
	    // on it.
	    else if (clause->factor_status == PSEUDO_LT_LINEAR) {
	      scc->recursive = 1 ;
	      break ;
	    }
/*
	    else if (clause->factor_status == PSEUDO_LT_LINEAR) {
	      is_pseudo_lt_linear = 1;
	    }
	    else if (is_pseudo_lt_linear && 
		     ((clause->factor_status == COR_RT_LINEAR) ||
		      (clause->factor_status == COR_MULTI_LINEAR))) {
	      // Use recursive field to signify that this scc
	      // is not factorable
	      scc->recursive = 1 ;
	      break ;
	    }
*/
	  }
	  if (scc->recursive) mark_scc(scc, COR_NON_LINEAR) ;

        }

   }
}

/***************************************************************************/
//extern void nomagic(struct collection *rules);
extern void preprocess_for_grouping(struct collection *orig_rules, 
		struct collection *pre_ad_rules);

extern void add_make_index_annotation(PredAnnotations *&, Symbol *pred, 
				      Symbol *adorn_string,
				      ArgList *al1, ArgList *al2);

static void generate_index_annos(struct collection *rules,
				 PredAnnotations *& index_annos)
{
  char buf[COR_MAX_ARGLIST_SIZE+1];
  int i, p;
  ArgList *al1;
  Arg *tmp_arg;

  FOR_EACH_RULE(rule, rules) {
    for (p=0; p < rule->num_preds; ++p)
      if ((rule->preds[p]->base_pred) && (rule->preds[p]->adorn.length)) {
	for (i = 0; i < rule->preds[p]->adorn.length; ++i)
	  buf[i] = rule->preds[p]->adorn[i] ? 'b' : 'f';
	buf[i] = '\0';
	tmp_arg = EnterSymbol(buf);
	al1 = ArgList::New(1);
	(*al1)[0] = tmp_arg;
	add_make_index_annotation(index_annos, rule->preds[p]->name(), NULL,
				  al1, NULL);
      }
  } END_EACH_RULE;
  
}


static void clear_sips(struct collection *rules)
{
  FOR_EACH_RULE(rule, rules) {
    rule->sips = NULL;
  } END_EACH_RULE;
}

void do_factor_rewriting() 
{
    TermList **terms; // For factoring

    if (parserStruct.CurModule.UsePipelining) {
      // if the module uses pipelining, there is really no need to do any
      // rewriting. However, in order to correctly generate indices, there must
      // be an analysis of how bindings are propogated. One way to do this is to
      // first mark all preds as derived preds and perform the adornment phase.
      // This will cause the base preds to be adorned in all the possible ways.
      // The actual base preds can now be marked, and index annotations generated
      // for just these preds. Finally, these index annotations are dumped along
      // with the original module.

      parserStruct.CurModule.PreProcessing = 0 ;
      mark_all_as_derived(parserStruct.rules) ;
      init_collection(pre_ad_rules, 1);
      if (!adorn(parserStruct.rules, pre_ad_rules)) {
	fprintf(stderr, "Unable to proceed with magic/factor rewriting!\n");
	exit(1);
       }

      if (optAdorn) {
	fprintf(stderr, "Printing adorned rules\n");
	print_factor(pre_ad_rules, stderr, 0) ;
	fprintf(stderr, "\n\n");
      }
      
      mark_basepreds(pre_ad_rules);
      generate_index_annos(pre_ad_rules, parserStruct.make_index_annotations);
      clear_sips(parserStruct.rules);
      print_factor(parserStruct.rules, outf, 0) ;
      return ;
    }

    if (!parserStruct.CurModule.Rewriting || 
	(!parserStruct.CurModule.UseMagic && 
	 !parserStruct.CurModule.UseSupplementaryMagic)) {
      fprintf(stderr,
	      "Warning: Magic rewriting not performed for Module %s.\n",
	      parserStruct.CurModule.name->string());
      //parserStruct.CurModule.Rewriting = 0 ;
      parserStruct.CurModule.PreProcessing = 0 ;
      print_factor(parserStruct.rules, outf, 0);
      return;
    }

    mark_basepreds(parserStruct.rules) ;

    init_collection(pre_ad_rules, 1);

    // for monotonic programs, there is no need to do ordered search
    // also, if ordered search is already set, dont bother checking again
    if (!parserStruct.CurModule.UseOrdSearch  &&
	!parserStruct.CurModule.Monotonic)
      check_ord_search(parserStruct);

    if (parserStruct.CurModule.UseFactoring && 
	parserStruct.CurModule.UseOrdSearch) {
      fprintf(exEnv.error_file, "Ordered search is turned on !\n");
      fprintf(exEnv.error_file, "Have to turn factoring off : sorry!\n");
      COR_set_use_factoring(parserStruct.CurModule, 0);     
    }

    preprocess_for_grouping(parserStruct.rules, pre_ad_rules);

    if (optAdorn) {
	fprintf(stderr, "Printing pre-adorned rules\n");
	print_factor(pre_ad_rules, stderr, 0);
	fprintf(stderr, "\n\n");
    }


    init_collection(factor_rules, 1);
    if (!adorn(pre_ad_rules, factor_rules)) {
      fprintf(stderr, "Unable to proceed with magic/factor rewriting!\n");
      exit(1);
   }

    if (optAdorn) {
	fprintf(stderr, "Printing adorned rules\n");
	print_factor(factor_rules, stderr, 0) ;
	fprintf(stderr, "\n\n");
    }

    init_collection(magic_rules, 0) ;

    FOR_EACH_RULE(r, factor_rules) {
	r->head->predicate->clauses = NULL ;
	r->head->predicate->clause_tail = &(r->head->predicate->clauses);
    } END_EACH_RULE

    FOR_EACH_RULE(r, factor_rules) {
	AddClauseToPredicate(r->head->predicate, r);
    } END_EACH_RULE

    if (parserStruct.CurModule.UseFactoring) {
        // NOTE :: It is important that the TermList be created only at this
        //         point, where the size of the adorned rule collection
        //         is known. 
        orig_rule_count = factor_rules->count ;
        terms = new TermList*[orig_rule_count] ;

        defunctify((struct rule *)(factor_rules->chain), terms) ; 
        if (optDefunct) {
	    fprintf(stderr, "Printing rules in Extended Datalog form\n");
	    print_factor(factor_rules, stderr, 0) ;
	    fprintf(stderr, "\n\n");
        }

        // Do an SCC analysis, and assign linear status to each rule
        find_status() ;

        if (parserStruct.CurModule.UseFactoring) {
            functify((struct rule *)(factor_rules->chain), terms) ; 
        }

        if (optFactor) {
	    fprintf(stderr, "Printing rules after factoring\n");
	    print_factor(factor_rules, stderr, 1) ;
	    fprintf(stderr, "\n\n");
        }
        factor_rewrite(factor_rules, magic_rules) ;
    }
    else {
        siporder(factor_rules);

        if (parserStruct.CurModule.UseSupplementaryMagic) {
            supmagic(factor_rules, magic_rules);
    	    // supopt();
	}
        else if ( parserStruct.CurModule.UseMagic)
	    fullmagic(factor_rules, magic_rules) ;
    }
    // Set @no_preprocessing to show that factoring/magic has been performed
    //parserStruct.CurModule.Rewriting = 0 ;
    parserStruct.CurModule.PreProcessing = 0 ;
    print_factor(magic_rules, outf, 0);
}


/***************************************************************************/
main(int ac, char ** av)
{
    int i;


    for (i=1; i<ac && (*av[i]=='-'); ++i) {
      if (!strcmp(av[i]+1, "a")) optAdorn = 1;
      else if (!strcmp(av[i]+1, "d")) optDefunct = 1;
      else if (!strcmp(av[i]+1, "f")) optFactor = 1;
      else if (!strcmp(av[i]+1, "factor"))
	{ if (++i < ac) exEnv.C_use_factoring_default = atoi(av[i]) ;}
      else if (!strcmp(av[i]+1, "magic"))
	{ if (++i < ac) exEnv.C_use_magic_default = atoi(av[i]) ;}
      else if (!strcmp(av[i]+1, "supmagic"))
	{ if (++i < ac) exEnv.C_use_supplementary_magic_default = atoi(av[i]);}
      else if (!strcmp(av[i]+1, "pipelining"))  {
	if (++i < ac) exEnv.C_use_pipelining_default = atoi(av[i]) ;
      }
      else if (!strcmp(av[i]+1, "supmagic_indexing"))

	{ if (++i < ac) exEnv.C_sup_magic_indexing_default = atoi(av[i]) ;}
      else if (!strcmp(av[i]+1, "ordsearch"))
	{ if (++i < ac) exEnv.C_use_ordsearch_default = atoi(av[i]) ;}
      else if (!strcmp(av[i]+1, "eqo"))
	{ if (++i < ac) exEnv.C_use_exist_opt_default = atoi(av[i]) ;}
      else {
	printUsage();
	exit(1);
      }
      
    }

    exEnv.C_print_prompt_default = 0 ;
    exEnv.C_exec_mode = COR_DOING_FACTOR;
    parseEnv.handle_new_file(stdin, "stdin");
    parseEnv.reset_position();
    init_coral(av[0]) ;

    for(;;) {
      parserStruct.rule_list = NULL;
      //exEnv.C_at_end_module = 0;
      if (yyparse()) {
	printf("syntax error -- quitting\n");
	break;
       }
      if (parseEnv.C_at_end_module && parserStruct.rule_list)
	do_factor_rewriting();
      else if (parserStruct.rule_list) {
	fprintf(stderr, "CORAL::factor: Warning - end_module missing\n");
	do_factor_rewriting();
       }
      else break;
     }
    exit_coral();
    exit(0);
 }


/***************************************************************************/
