.TH MAGIC 1
.SH NAME
magic  \-  perform generalized supplementary magic sets transformation
.SH SYNOPSIS
.B magic
[
.BR \-l
] [ infile [ outfile ] ]
.SH DESCRIPTION
.I Magic
accepts a logic program adorned with a set of \fIsips\fP and performs
the generalized supplementary magic sets transformation.
If infile or outfile are not specified, \fIstdin\fP and \fIstdout\fP
are used.
The -l option gives a listing of the original set of rules and the
adorned system.
.PP
The expected syntax of the input file is described by the following grammar:
.nf

<prog> -->
        <query> <clause>*
<query> -->
        <clause>
<clause> -->
        <predicate> ":-" <predicate_list> "sips" <sips> "."
<predicate_list> -->
        <predicate> ("," <predicate>)*
    |   null
<predicate> -->
        <constant> "(" <arg_list> ")"
<arg_list> -->
        <arg> ("," <arg>)*
<arg> -->
        <arg_fact> "|" <arg_fact>
    |   <arg_fact>
<arg_fact> -->
        <constant>
    |   <variable>
    |   "_"
    |   <constant> "(" <arg_list> ")"
    |   "[" <arg_list> "]"
    |   "[]"
<sips> -->
        "[" <id>+ "]," <sip_list>+
    |   null
<sip_list> -->
        "[" <adornment> ":" <sip> "]"
<adornment> -->
        "[" <id>+ "]"
<sip> -->
        <arc> ("," <arc>)*
<arc> -->
        "[" <id>+ "] ==> [" <id> "] //" <id>
<id> -->
        <constant>
    |   <variable>
<constant> -->
        [a-z][a-z0-9_]*
<variable> -->
        [A-Z][A-Z0-9_]*
.fi
.SH EXAMPLE
.nf

q(X) :- anc(john, X) sips [],[].
anc(X,Y) :- par(X,Y) sips [a,p],
                            [ [b,f]: [a] ==> [p] // X ],
                            [ [f,b]: [a] ==> [p] // Y ],
                            [ [b,b]: [a] ==> [p] // X,
                                     [a] ==> [p] // Y ].

anc(X,Y) :- par(X,Z), anc(Z,Y) sips [a0,p,a1],
                                    [ [b,f]: [a0] ==> [p] // X,
                                             [a0,p] ==> [a1] // Z ],
                                    [ [f,b]: [a0] ==> [a1] // Y,
                                             [a0,a1] ==> [p] // Z ].
.fi
