/************************************************************************
 ========================================================================
 CORAL 
 (c)  Copyright R. Ramakrishnan and The CORAL Group, 
 University of Wisconsin at Madison.
 (1992) All Rights Reserved.
 Version 0.1
 ========================================================================



 ------------------------------------------------------------------------
 CORAL Version 0.1
 RESEARCH SOFTWARE DISCLAIMER -------------------------------------------
 ------------------------------------------------------------------------

    As unestablished, research software, this program is provided free of 
    charge on an "as is" basis without warranty of any kind, either 
    express or implied.  Acceptance and use of this program constitutes 
    the user's understanding that (s)he will have no recourse for any 
    actual or consequential damages, including, but not limited to, 
    lost profits or savings, arising out of the use of or inability to 
    use this program.  

 ------------------------------------------------------------------------
 USER AGREEMENT ---------------------------------------------------------
 ------------------------------------------------------------------------

     BY ACCEPTANCE AND USE OF THIS EXPERIMENTAL PROGRAM
     THE USER AGREES TO THE FOLLOWING:

     a.  This program is provided free of charge for the user's personal, 
	 non-commercial, experimental use.

     b.  All title, ownership and rights to this program and any copies 
         remain with the copyright holder, irrespective of the ownership 
	 of the media on which the program resides.

     c.  The user is permitted to create derivative works to this program.  
         However, all copies of the program and its derivative works must
         contain the CORAL copyright notice, the UNESTABLISHED SOFTWARE 
         DISCLAIMER and this USER AGREEMENT.

     d.  The user understands and agrees that this program and any 
         derivative works are to be used solely for experimental purposes 
	 and are not to be sold or commercially exploited in any manner 
	 WITHOUT EXPRESS WRITTEN PERMISSION.

     e.  We request that the user supply us with a copy of any changes, 
         enhancements, or derivative works which the user may create,
	 with the user's permission to redistribute it.
	 Copies of such material should be sent to:  CORAL@CS.WISC.EDU

-------------------------------------------------------------------------
*************************************************************************/

#ifndef FUNCT_H

#define FUNCT_H

#include "externs.h"

#define TRACE(x) if( 0 ) { fprintf x ; fflush( stderr ) ;};

// Structure used to keep track of function terms that have been replaced
// by dummy variables in order to generate rules in Extended Datalog form.

typedef struct TermList TermList ;

struct TermList {
  ArgList *arg_list ;             // ArgList that held the term
  int      arg_pos  ;             // Position of term within ArgList
  VarArg  *var_arg  ;             // Dummy VarArg used
  FuncArg *func_arg ;             // Original FuncArg replaced
  Literal *dummy_pred ;           // Dummy predicate introduced
  struct TermList *similar ;      // Pointer to an identical TermList struct
                                  // if such exists

  struct TermList *next ;

  TermList() { next = NULL ; dummy_pred = NULL ; similar = NULL ;};
  TermList( ArgList *alist, int apos ) {
    arg_list = alist ;
    arg_pos = apos ;
    next = NULL ;
    dummy_pred = NULL ;
    similar = NULL ;
  };

  void set_vararg( VarArg * varg ) { var_arg = varg;};
  void set_funcarg( FuncArg * farg ) { func_arg = farg;};
  void set_similar( TermList *t) { similar = t ;};

};

#endif



