/************************************************************************
 ========================================================================
 CORAL 
 (c)  Copyright R. Ramakrishnan and The CORAL Group, 
 University of Wisconsin at Madison.
 (1992) All Rights Reserved.
 Version 0.1
 ========================================================================



 ------------------------------------------------------------------------
 CORAL Version 0.1
 RESEARCH SOFTWARE DISCLAIMER -------------------------------------------
 ------------------------------------------------------------------------

    As unestablished, research software, this program is provided free of 
    charge on an "as is" basis without warranty of any kind, either 
    express or implied.  Acceptance and use of this program constitutes 
    the user's understanding that (s)he will have no recourse for any 
    actual or consequential damages, including, but not limited to, 
    lost profits or savings, arising out of the use of or inability to 
    use this program.  

 ------------------------------------------------------------------------
 USER AGREEMENT ---------------------------------------------------------
 ------------------------------------------------------------------------

     BY ACCEPTANCE AND USE OF THIS EXPERIMENTAL PROGRAM
     THE USER AGREES TO THE FOLLOWING:

     a.  This program is provided free of charge for the user's personal, 
	 non-commercial, experimental use.

     b.  All title, ownership and rights to this program and any copies 
         remain with the copyright holder, irrespective of the ownership 
	 of the media on which the program resides.

     c.  The user is permitted to create derivative works to this program.  
         However, all copies of the program and its derivative works must
         contain the CORAL copyright notice, the UNESTABLISHED SOFTWARE 
         DISCLAIMER and this USER AGREEMENT.

     d.  The user understands and agrees that this program and any 
         derivative works are to be used solely for experimental purposes 
	 and are not to be sold or commercially exploited in any manner 
	 WITHOUT EXPRESS WRITTEN PERMISSION.

     e.  We request that the user supply us with a copy of any changes, 
         enhancements, or derivative works which the user may create,
	 with the user's permission to redistribute it.
	 Copies of such material should be sent to:  CORAL@CS.WISC.EDU

-------------------------------------------------------------------------
*************************************************************************/

/** args.c :
	implements some functions that deal with function arguments 

	get_terms(pred, termlist)
		Copies all args of pred that are functors, into termlist 

**/
#include "rules.h"
#include "externs.h"
#include "funct.h"

/**************************************************************************
 Returns true if the argument 'a' is already in the termlist 'terms'
**************************************************************************/

TermList * find_arg( TermList *terms, Arg * a)
{
    for (terms = terms->next; terms ; terms = terms->next) {
	if (terms->func_arg->equals(a)) return terms ;
    }
    return NULL ;
}

/**************************************************************************
 Adds argument 'a' to the end of termlist 'terms'
**************************************************************************/
void add_arg(TermList *terms, Arg *a, ArgList* args, int pos, TermList *t)
{
    
    TermList *tmp =  new TermList(args, pos);
    tmp->set_funcarg((FuncArg *)a);
    tmp->set_similar(t) ;

// If t is NULL, add arg to the end of the list, so that it will be processed
// eventually. Else, it is similar to another such arg seen already, and can
// be placed at the head of the list

    if (t)
	tmp->next = terms->next ;
    else
	while (terms->next) terms = terms->next ;

    terms->next = tmp ;
}

/**************************************************************************/
/** Gets only terms that are arguments of pred and are functors.  Doesn't
	return subterms separately.
**/
/**************************************************************************/
void get_terms( Literal * pred, TermList *terms ) 
{
  ASSERT( pred != NULL ) ;

  int j = 0 ;
  FOR_EACH_ARG(a, pred->args) {
	if ( a->kindof() == COR_FUNCTOR ) { /* put this in termlist */
// Should these lines be commented out ?? -- PRAVEEN
	    TermList *tmp = find_arg( terms, a ) ;
	    add_arg(terms, a, &(pred->args), j, tmp) ;
	}
	j++ ;
  } END_EACH_ARG

}

/**************************************************************************/
