/************************************************************************
 ========================================================================
 CORAL 
 (c)  Copyright R. Ramakrishnan and The CORAL Group, 
 University of Wisconsin at Madison.
 (1992) All Rights Reserved.
 Version 0.1
 ========================================================================



 ------------------------------------------------------------------------
 CORAL Version 0.1
 RESEARCH SOFTWARE DISCLAIMER -------------------------------------------
 ------------------------------------------------------------------------

    As unestablished, research software, this program is provided free of 
    charge on an "as is" basis without warranty of any kind, either 
    express or implied.  Acceptance and use of this program constitutes 
    the user's understanding that (s)he will have no recourse for any 
    actual or consequential damages, including, but not limited to, 
    lost profits or savings, arising out of the use of or inability to 
    use this program.  

 ------------------------------------------------------------------------
 USER AGREEMENT ---------------------------------------------------------
 ------------------------------------------------------------------------

     BY ACCEPTANCE AND USE OF THIS EXPERIMENTAL PROGRAM
     THE USER AGREES TO THE FOLLOWING:

     a.  This program is provided free of charge for the user's personal, 
	 non-commercial, experimental use.

     b.  All title, ownership and rights to this program and any copies 
         remain with the copyright holder, irrespective of the ownership 
	 of the media on which the program resides.

     c.  The user is permitted to create derivative works to this program.  
         However, all copies of the program and its derivative works must
         contain the CORAL copyright notice, the UNESTABLISHED SOFTWARE 
         DISCLAIMER and this USER AGREEMENT.

     d.  The user understands and agrees that this program and any 
         derivative works are to be used solely for experimental purposes 
	 and are not to be sold or commercially exploited in any manner 
	 WITHOUT EXPRESS WRITTEN PERMISSION.

     e.  We request that the user supply us with a copy of any changes, 
         enhancements, or derivative works which the user may create,
	 with the user's permission to redistribute it.
	 Copies of such material should be sent to:  CORAL@CS.WISC.EDU

-------------------------------------------------------------------------
*************************************************************************/
/*******************************************************************/
/*	connect.C
	Identifying Connected Components
*/
/*******************************************************************/
#include "exist.h"
#include "rules.h"
#include "globals.h"
#include <stdlib.h>

#define COR_YES 1
#define COR_NO  0

extern struct Symbol *EnterSymbol(const char *) ;

struct predTable { 		/* store preds of the same class in a rule */
	Literal *preds[COR_MAX_PREDS];
	int num_preds;
};

struct unique {			/* remember new predicate names */
	int head, body;		/* find a more sophiscated algorithm later */
};

static struct rule *newRule(struct rule *);
static Literal *newHead(struct unique *), *newBody(struct unique *);
static int connectPred(struct rule *, struct predTable *) ;

/*******************************************************************/
/* identify the connective components in the rules.  Return the 
   pointer to the head of the rules
*/
/*******************************************************************/
struct rule *connect(struct rule *rules)
{
	struct rule *r, *tmpR, headR;
	struct unique uniqueName;
	int numClass, i, j, k;

	uniqueName.head = 1;
	uniqueName.body = 1;
	tmpR = &headR;

	for (r=rules; r; r=(struct rule *)(r->link.next)) {
		struct predTable pTable[COR_MAX_VARS];

		numClass = connectPred(r, pTable);/* identify connectivities */

		tmpR->link.next = (Link *)newRule(r);	/* create a new rule */
		tmpR = (struct rule *)tmpR->link.next;	       /* link it up */
		tmpR->head = r->head;			 /* process the head */

		/* link of the predicates of the same class */
		tmpR->num_preds = pTable[0].num_preds + numClass;
		tmpR->preds = new Literal *[tmpR->num_preds];
		for (j=0; j<pTable[0].num_preds; j++) 
			tmpR->preds[j] = pTable[0].preds[j];
		/* create one predicate for each class */
		for (k=0; k<numClass; k++)
			tmpR->preds[k+j] = newBody(&uniqueName);

// TO DO IN THE FUTURE !!
// SPECIFY THAT THESE RULES BE EVALUATED JUST ONCE
// USE THE CHOICE() FEATURE --- Praveen
		for (i=1; i<=numClass; i++) {	
			/* for the rest of the classes... */
			tmpR->link.next = (Link *)newRule(r); 
			tmpR = (struct rule*)tmpR->link.next;
			tmpR->head = newHead(&uniqueName); 
			tmpR->num_preds = pTable[i].num_preds;
			tmpR->preds = new Literal *[tmpR->num_preds];
			for (j=0; j<pTable[i].num_preds; j++) 
				tmpR->preds[j] = pTable[i].preds[j];
		}
	}

	/* return pointer to the first rule */
	return (struct rule *)(headR.link.next); 
}
/*******************************************************************/
// Just a substitute for a macro (since it uses a macro itself)
inline void setValue(int *var_class, Literal *p, int value, int check_adorn)
{
	int j = 0 ;
	FOR_EACH_ARG(a, p->args){
		if (((check_adorn == COR_NO)||(!p->adorn[j])) &&
		    (a->kindof() == COR_VARIABLE))
		 var_class[((VarArg *)a)->var] = value;
		j++ ;
	}END_EACH_ARG
}

inline void getValue(int *var_class, Literal *p, int &value, int check_val)
{
	int j = 0 ;
	FOR_EACH_ARG(a, p->args) {
		if ((check_val == COR_YES) && (value != -1)) break ;
		if ((!p->adorn[j++])&& (a->kindof() == COR_VARIABLE))
			value = var_class[((VarArg *)a)->var];
	} END_EACH_ARG
}

/*******************************************************************
* Generates connected components (classes) of variables for the rule.
* Each class is put into a predTable entry. The number of such
* entries (apart from the head class) is returned.
********************************************************************/
static int connectPred(struct rule *r, struct predTable *pTable)
{
	int newClass;		/* the head predicate belongs to class 0 */
	int inClass;
	Literal *p;
	int i, j;

	if (r==NULL) return(0);
	int *var_class = new int[r->num_var_names] ;

	for (i=0; i<r->num_var_names; i++) {
		pTable[i].num_preds = 0;	// pTable indexed by class num 
		var_class[i] = -1;		// not yet classified 
	}

	p = r->head;
	i = 0;
	if (p) setValue(var_class, p, 0, COR_YES);
	for (i=0; i<r->num_preds; i++) {
		p = r->preds[i];
		if (!p) continue;
		inClass = -1; 
		getValue(var_class, p, inClass, COR_YES) ;
		if (inClass!=-1) setValue(var_class, p, inClass, COR_NO);
	}

	newClass = 0;
	for (i=0; i<r->num_preds; i++) {
		inClass = -1;
		p = r->preds[i];

		// see if any of the arg variables belong to a certain class 
		if (p) getValue(var_class, p, inClass, COR_NO);

		if (inClass==-1) {
			newClass++;
			if (newClass>=COR_MAX_VARS) {
				fprintf(stderr, "Error in connect: too many equivalence classes\n");
				exit(0);
			}
			pTable[newClass].preds[pTable[newClass].num_preds] = p;
			setValue(var_class, p, newClass, COR_NO) ;
			pTable[newClass].num_preds++;
		} else {
			pTable[inClass].preds[pTable[inClass].num_preds] = p;
			setValue(var_class, p, inClass, COR_NO) ;
			pTable[inClass].num_preds++;
		}
		for (j=i+1; j<r->num_preds; j++) {
			p = r->preds[j];
			if (!p) continue;

			inClass = -1;
			getValue(var_class, p, inClass, COR_YES) ;
			if (inClass!=-1) setValue(var_class, p, inClass, COR_NO) ;
		}

	}

/* return the number of classes (0 means 1 class) */
	return(newClass);

}

/*******************************************************************/
/* create a new rule which has the same arg var and sips as r
   return pointer to the new rule 
*/
/*******************************************************************/
static struct rule *newRule(struct rule *r)
{
	int i;
	struct rule *newR = new struct rule;

	newR->var_names = new Name[r->num_var_names] ;

	for (i=0; i<r->num_var_names; i++)
		newR->var_names[i] = r->var_names[i];
	newR->num_var_names = r->num_var_names ;

	newR->num_preds = 0;
	newR->head = NULL;
	newR->sips = r->sips;
	newR->link.next = NULL;

	return(newR);
}

#define COR_BOOLEAN "boolean"

/*******************************************************************/
static Literal *newHead(struct unique *name)
{
	char *tmp_str = new char[strlen(COR_BOOLEAN)+10];
	sprintf(tmp_str, "%s%d", COR_BOOLEAN, name->head);
	Literal *p = AllocLiteral(parserStruct, EnterSymbol(tmp_str),0);

	p->adorn.clear() ;

	name->head++;
	delete tmp_str;
	return(p);
}

/*******************************************************************/
static Literal *newBody(struct unique *name)
{
	char *tmp_str = new char[strlen(COR_BOOLEAN)+10];
	sprintf(tmp_str, "%s%d", COR_BOOLEAN, name->body);
	Literal *p = AllocLiteral(parserStruct, EnterSymbol(tmp_str),0) ;

	p->adorn.clear() ;
	name->body++;
	delete tmp_str;
	return(p);
}

/*******************************************************************/

#undef COR_BOOLEAN
#undef COR_YES
#undef COR_NO
