/************************************************************************
 ========================================================================
 CORAL 
 (c)  Copyright R. Ramakrishnan and The CORAL Group, 
 University of Wisconsin at Madison.
 (1992) All Rights Reserved.
 Version 0.1
 ========================================================================



 ------------------------------------------------------------------------
 CORAL Version 0.1
 RESEARCH SOFTWARE DISCLAIMER -------------------------------------------
 ------------------------------------------------------------------------

    As unestablished, research software, this program is provided free of 
    charge on an "as is" basis without warranty of any kind, either 
    express or implied.  Acceptance and use of this program constitutes 
    the user's understanding that (s)he will have no recourse for any 
    actual or consequential damages, including, but not limited to, 
    lost profits or savings, arising out of the use of or inability to 
    use this program.  

 ------------------------------------------------------------------------
 USER AGREEMENT ---------------------------------------------------------
 ------------------------------------------------------------------------

     BY ACCEPTANCE AND USE OF THIS EXPERIMENTAL PROGRAM
     THE USER AGREES TO THE FOLLOWING:

     a.  This program is provided free of charge for the user's personal, 
	 non-commercial, experimental use.

     b.  All title, ownership and rights to this program and any copies 
         remain with the copyright holder, irrespective of the ownership 
	 of the media on which the program resides.

     c.  The user is permitted to create derivative works to this program.  
         However, all copies of the program and its derivative works must
         contain the CORAL copyright notice, the UNESTABLISHED SOFTWARE 
         DISCLAIMER and this USER AGREEMENT.

     d.  The user understands and agrees that this program and any 
         derivative works are to be used solely for experimental purposes 
	 and are not to be sold or commercially exploited in any manner 
	 WITHOUT EXPRESS WRITTEN PERMISSION.

     e.  We request that the user supply us with a copy of any changes, 
         enhancements, or derivative works which the user may create,
	 with the user's permission to redistribute it.
	 Copies of such material should be sent to:  CORAL@CS.WISC.EDU

-------------------------------------------------------------------------
*************************************************************************/
/****************************************************************************/
/* 	adorn.C
	Adorning Existential Programs
*/
/****************************************************************************/
#include "exist.h"
#include "rules.h"
#include "globals.h"
#include <strings.h>
#include <stdlib.h>

#define COR_MARKED 1
#define COR_UNMARKED -1

// defined in CORALROOT/src/util.C
extern Literal * AllocLiteral(int);

/****************************************************************************/
/* struct ndTable:
   There will be an array of struct ndTable indexed by the argument number
   in a rule.  If the structure contains a non-NULL pointer to a predicate
   and the value of pos >= 0, the argument is a 'd' argument.
*/
/****************************************************************************/
typedef struct ndTable ndTable ;
struct ndTable {	/* mark the arguments of the predicates of a rule */
	Literal *p;	/* pointer to the predicate which contains a 'd' arg */
	int pos;		/* position of the 'd' argument */
	ndTable() { p = NULL; pos = 0;}
};

struct marker {		/* mark the adorned predicates */
	Name pred_name ;
	BitVector adorned;/* a max of 32 versions of adornment */
};

// In the BitVector, a 0 means that the argument is needed, and a 1 implies
// dont care. --- Praveen

// In the ndTable struct, if pos is -1, that means it is needed.
// Otherwise, if >0, it is not needed.  --- Praveen

extern void print_bits(BitVector b, int flag) ;
static void printMarkers(struct marker *markers, int mPos);
static void markPred(Name p, BitVector adorn, struct marker *m, int *mPos);
static void initAdorn(struct rule *r, BitVector vector, struct ndTable *argTable);
static void adornRule(struct rule *theRule, struct ndTable *argTable,
		struct marker * markers, int *mPos) ;
static struct rule *findHP(struct rule *startR, Name p);
static struct rule *copyRule(struct rule *oldR);
static int marked(Name p, BitVector adorn, struct marker *m, int mPos);
/****************************************************************************/
/* BE CAREFUL NOT to dispose of any old rules, since the original set
   of rules are still being referenced. adorn() will return a pointer to
   the head of the rules. The pointer pointing to the query is left 
   unchanged.
*/
/****************************************************************************/
struct rule *adorn(struct rule *rules)
{

 struct ndTable argTable[COR_MAX_VARS];	/* indexed by var num */
 struct marker mkrs[COR_MAX_PREDS];		/* indexed by pred num */
 int i, mPos;			// mPos is number of marked pred */
 struct rule *tmpR, headR;

 mPos = 0;		// no adorned predicate is marked yet 
	
// Assume initially that all exis. adornments are d (for dont care).
// The arguments of the exported preds are definitely needed. So start
// from these, and propogate the needed arguments through the rules.
// Basically, a starting point is needed, and the exported predicates
// provide such a starting point. Also, the optimization is restricted
// to rules reachable from the exported preds.

 ExportInfo *e_info ;

 for (e_info = parserStruct.CurModule.ExportedPreds; e_info ; e_info = e_info->next){
   BitVector tmpVector(e_info->adorn_symbol->length());
   markPred(e_info->pred_name, tmpVector, mkrs, &mPos);
  }
 
 tmpR = &headR;
 for (i=0; i<mPos; i++) {
   struct rule *r;
   
   r = findHP(rules, mkrs[i].pred_name);
   
   for (;r!=NULL; r=findHP((struct rule *)(r->link.next), mkrs[i].pred_name)){
     tmpR->link.next = (Link *)copyRule(r);
     tmpR = (struct rule *)(tmpR->link.next);
     initAdorn(tmpR, mkrs[i].adorned, argTable);
     adornRule(tmpR, argTable, mkrs, &mPos);
     if (mPos>=COR_MAX_PREDS) {
       fprintf(stderr, "Error in adornRule: too many predicates.\n");
       exit(1);
      }
    }
  }
 
 
#if 0
 printMarkers(mkrs, mPos) ;
#endif
 /* check to see that at least one rule exists */
 if (tmpR == &headR) return NULL;
 
 /* return pointer to the first rule */
 return (struct rule *)(headR.link.next); 

}

/****************************************************************************/
/* adorn the head predicate and initialize the argTable
*/
/****************************************************************************/
static void initAdorn(struct rule *r, BitVector vector, struct ndTable *argTable)
{
	int j;
	Literal *tmpP;

	for (j=0; j<COR_MAX_VARS; j++) 
		argTable[j].pos = 0;			/* argument position */
	tmpP = r->head;
	tmpP->adorn = vector;		/* copy the adornment  */

	j = 0;

	FOR_EACH_ARG(tmpA, tmpP->args) {

	if (tmpA == NULL) fprintf(stderr,"SOMETHING WRONG !\n");
		if (!vector[j++])
			if (tmpA->kindof() == COR_VARIABLE) {
			 argTable[((VarArg *)(tmpA))->var].pos = -1;
			}
		if (j == COR_MAX_VARS) break ;
	}END_EACH_ARG

	if (j==COR_MAX_VARS) {
		fprintf(stderr, "Error in initAdorn: too many arguments in a rule.\n");
		exit(1);
	}
}

/****************************************************************************/
/* mark the adorned predicate p 
*/
/****************************************************************************/
static void markPred(Name p, BitVector adorn, struct marker *m, int *mPos)
{
	int i = *mPos;

	if (marked(p, adorn, m, i)==COR_UNMARKED) {
		m[i].adorned = adorn;	/*put the pred at the end */
		m[i].pred_name = p;
		*mPos = i+1;

	}
}


/****************************************************************************/
/* return COR_UNMARKED if the predicate p is not marked with the associated
   adornment 
*/
/****************************************************************************/
static int marked(Name p, BitVector adorn, struct marker *m, int mPos)
{
	int i;
	BitVector v ;

	v = adorn ;

	for (i=0; i<mPos; i++)
		if ((m[i].adorned == v) && p->equals(m[i].pred_name))
			return(COR_MARKED);
	return(COR_UNMARKED);
}

/****************************************************************************/
/* find the first rule starting from rule startR whose head predicate has a
   predicate number p, if found then return pointer to that rule, else 
   return NULL.
*/
/****************************************************************************/
static struct rule *findHP(struct rule *startR, Name p)
{
	struct rule *r;

	for (r=startR; r!=NULL; r=(struct rule *)(r->link.next)) {
		if (r->head == NULL)
			continue;
		if (p->equals(r->head->name())) 
			return(r);
	}
	return(NULL);
}

/****************************************************************************/
static void adornRule(struct rule *theRule, struct ndTable *argTable,
		struct marker * markers, int *mPos)
{
	int i, j;
	Literal *tmpP;

	if (theRule==NULL) 	/* something's wrong if it returns here*/
		return;
	for (i=0; i<theRule->num_preds; i++) {
		tmpP = theRule->preds[i];
		if (tmpP==NULL) {
			fprintf(stderr, "Error in adornRule: null body predicate\n");
			exit(1);
		}
		tmpP->adorn.clear() ;
		j = 1 ;
		FOR_EACH_ARG(tmpA, tmpP->args) {
			if (tmpA->kindof()==COR_VARIABLE) {
			    if (argTable[((VarArg *)(tmpA))->var].pos==0) {
				argTable[((VarArg *)(tmpA))->var].p = tmpP;
				argTable[((VarArg *)(tmpA))->var].pos = j;
			    } 
			    else if (argTable[((VarArg *)(tmpA))->var].pos>0) 
				argTable[((VarArg *)(tmpA))->var].pos = -1;
				/* needed */
			}
			j++ ;
		}END_EACH_ARG
	}

	for (i=0; i<theRule->num_var_names; i++) 
		if ((j=argTable[i].pos)>0)
			argTable[i].p->adorn.set(j-1);

	for (i=0; i<theRule->num_preds; i++)
	    if (!(theRule->preds[i]->base_pred))
		markPred(theRule->preds[i]->name(), 
			  theRule->preds[i]->adorn, markers, mPos);
}

/****************************************************************************/ 
/* copy the rule oldR and return the new rule pointer.
   COR_NOTE: not all the spaces required for the new rule are allocated. Subsequent
   modifications of the contents pointed by those pointers will change the
   old rule too.  In particular, pointers to sips and args are just copied,
   so it's still referencing the contents of the old rule.
   This function, however, does COR_NOT modify the contents of oldR.
*/
/****************************************************************************/ 
// Makes a copy of literal p and returns it
Literal * copyLiteral(Literal * p)
{
	Literal *tmp = AllocLiteral( p->args.count());

	tmp->predicate = p->predicate;

	tmp->adorn.clear();
	tmp->base_pred = p->base_pred ;

	for (int i=0; i< p->args.count();i++)
		tmp->args[i] = p->args[i] ;

	return tmp ;
}
/****************************************************************************/ 
static struct rule *copyRule(struct rule *oldR)
{
	int i;
	struct rule *newR;

	newR = new struct rule ;
	newR->var_names = new Name[oldR->num_var_names] ;
	newR->num_var_names = oldR->num_var_names ;
	for (i=0; i<newR->num_var_names; i++) {
 		newR->var_names[i] = oldR->var_names[i];
	}

	newR->head = copyLiteral(oldR->head) ;

	newR->num_preds = oldR->num_preds;
	newR->preds = new Literal *[newR->num_preds] ;
	for (i=0; i<newR->num_preds; i++)
		newR->preds[i] = copyLiteral(oldR->preds[i]);

	newR->sips = oldR->sips;
	newR->link.next = NULL ;
	return(newR);
}

/****************************************************************************/
static void printMarkers(struct marker *markers, int mPos)
{
	int i;

	fprintf(stderr, "\nMarked predicates\n");
	for (i=0; i<mPos; i++) {
		fprintf(stderr, "%s\t", SymbolString(markers[i].pred_name));
		print_bits(markers[i].adorned, 0);
		fprintf(stderr, "\n");
	}
}

/****************************************************************************/
