/************************************************************************
 ========================================================================
 CORAL 
 (c)  Copyright R. Ramakrishnan and The CORAL Group, 
 University of Wisconsin at Madison.
 (1992) All Rights Reserved.
 Version 0.1
 ========================================================================



 ------------------------------------------------------------------------
 CORAL Version 0.1
 RESEARCH SOFTWARE DISCLAIMER -------------------------------------------
 ------------------------------------------------------------------------

    As unestablished, research software, this program is provided free of 
    charge on an "as is" basis without warranty of any kind, either 
    express or implied.  Acceptance and use of this program constitutes 
    the user's understanding that (s)he will have no recourse for any 
    actual or consequential damages, including, but not limited to, 
    lost profits or savings, arising out of the use of or inability to 
    use this program.  

 ------------------------------------------------------------------------
 USER AGREEMENT ---------------------------------------------------------
 ------------------------------------------------------------------------

     BY ACCEPTANCE AND USE OF THIS EXPERIMENTAL PROGRAM
     THE USER AGREES TO THE FOLLOWING:

     a.  This program is provided free of charge for the user's personal, 
	 non-commercial, experimental use.

     b.  All title, ownership and rights to this program and any copies 
         remain with the copyright holder, irrespective of the ownership 
	 of the media on which the program resides.

     c.  The user is permitted to create derivative works to this program.  
         However, all copies of the program and its derivative works must
         contain the CORAL copyright notice, the UNESTABLISHED SOFTWARE 
         DISCLAIMER and this USER AGREEMENT.

     d.  The user understands and agrees that this program and any 
         derivative works are to be used solely for experimental purposes 
	 and are not to be sold or commercially exploited in any manner 
	 WITHOUT EXPRESS WRITTEN PERMISSION.

     e.  We request that the user supply us with a copy of any changes, 
         enhancements, or derivative works which the user may create,
	 with the user's permission to redistribute it.
	 Copies of such material should be sent to:  CORAL@CS.WISC.EDU

-------------------------------------------------------------------------
*************************************************************************/


#include <stdlib.h>
#include <stdio.h>
#include <strings.h>
#include "scanner.h"
#include "line_info.h"
#include "scan_input.h"
#include "export.h"
#include "mystrings.h"
#include "hashdefines.h"
#include "translate.h"

/* globals */
int nesting_level;
struct vars_list *tuple_var_list;
struct vars_list *relation_var_list;
int coral_var_number;
char *error_file_name;
FILE *error_file;
char *coral_file_name = NULL;
FILE *coral_file;
int coral_file_used = 0;
mystring *export_dummy_fn;     /* for all the export declarations, only
				* one dummy fn is generated. 
				* For every export decl, the code to 
				* enter the relation into the database 
				* is entered here.
				* At the end, this string is dumped 
				* into the output file
				*/

mystring *export_header_decl;	/* export declaration generates a 
				 * solver for the function in the 
				 * export decl. 
				 * This generates an extern declaration 
				 * for the function to resolve any 
				 * conflicts 
				 */

mystring *exec_array_decl;      /* declaration of structures used to
				 * to execute each 'blob' of CORAL code
				 */

mystring *exec_array_initializations;
                                /* initialization code for each 
				 * execution structure to be used
				 */

mystring *exec_array_init_calls;

mystring *coral_file_dump_fn;

char *exec_array_init_fn_name;
char *coral_file_dump_fn_name;
char *dummy_fn_name;		
char *dummy_temp_name;
int first_export_decl = 1;
int first_make_tuple = 1;


void init(scan_input *input_buffer, char *error_msgs_file, char *coral_f) 
{
  char buf[256];
  nesting_level = 0;
  tuple_var_list = NULL;
  relation_var_list = NULL;
  coral_var_number = 0;
  
  /* setting the error messages file */
  if (error_msgs_file == NULL) {	/* default is stderr */
    error_file = stderr;
    error_file_name = "stderr";
  }
  else {
    
    error_file = fopen(error_msgs_file, "w");
    if (error_file == NULL) {
      fprintf(stderr, "Cannot open file: %s\n", error_msgs_file);
      error_file = stderr;
      error_file_name = "stderr";
    }
    else {
      error_file_name = copy_string(error_msgs_file);
    }
  }
  
  /* setting the file where the coral code will be dumped    */
  
  coral_file_name = copy_string(coral_f);
  
  exec_array_decl = new mystring;
  exec_array_initializations = new mystring;

  coral_file_dump_fn = new mystring;
  coral_file_dump_fn_name = new_name();
  sprintf(buf, "static void %s()\n{\n", coral_file_dump_fn_name);
  coral_file_dump_fn->append(buf);
  sprintf(buf, "  FILE *fd = fopen(\"%s\", \"w\");\n", coral_file_name);
  coral_file_dump_fn->append(buf);

  exec_array_init_calls = new mystring;
  exec_array_init_fn_name = new_name();
  sprintf(buf, "static void %s()\n{\n", exec_array_init_fn_name);
  exec_array_init_calls->append(buf);
  sprintf(buf, "  %s();\n", coral_file_dump_fn_name);
  exec_array_init_calls->append(buf);  
  sprintf(buf, "  consultFile(\"%s\", \"%s\");\n",
	  coral_file_name, coral_file_name);
  exec_array_init_calls->append(buf);
  sprintf(buf, "  unlink(\"%s\");\n", coral_file_name);
  exec_array_init_calls->append(buf);

  char *temp_str = new_name();
  dummy_fn_name = new char[strlen(temp_str) + 25];
  strcpy(dummy_fn_name, DUMMY_FN_NAME);
  strcat(dummy_fn_name, temp_str);
  delete temp_str;

  export_dummy_fn = new mystring;
  dummy_temp_name = new_name();
  sprintf(buf, "static void %s()\n{\n   BuiltinUserTupleRelation *%s;\n",
	  dummy_fn_name, dummy_temp_name);
  export_dummy_fn->append(buf);
  
  FILE *temp = input_buffer->get_output_file();
  /*
   * this statment generates #include <stdio.h>
   * in the module, if it appears, it is ignored 
   */
  fprintf(temp, "#include <stdio.h>\n");
  fprintf(temp, "#include <strings.h>\n");
  fprintf(temp, "#include \"%s\"\n", INCLUDES_FILE);
  fprintf(temp, "\n\n");
  output_init_export(input_buffer, INCLUDES_FILE, dummy_fn_name);
  fprintf(temp, "static void %s();\n\n", exec_array_init_fn_name);
  fprintf(temp,"static %s %s = 0;\n",CORAL_FAIL_VAR_TYPE,
	  CORAL_FAIL_VAR);	// defined in hashdefine
}


void close(scan_input *input_buffer, mystring *export_dummy_fn) 
{
  fprintf(input_buffer->get_output_file(), "\n");
  exec_array_decl->print(input_buffer->get_output_file());
  delete exec_array_decl;
  exec_array_initializations->print(input_buffer->get_output_file());
  delete exec_array_initializations;
  exec_array_init_calls->append("}\n");
  coral_file_dump_fn->append("  fclose(fd);\n}\n");
  if (coral_file_used) {
    coral_file_dump_fn->print(input_buffer->get_output_file());
    exec_array_init_calls->print(input_buffer->get_output_file());
  }
  delete exec_array_init_calls;
  export_dummy_fn->append("}\n");
  export_dummy_fn->print(input_buffer->get_output_file());
  delete export_dummy_fn;
}





main(int argc, char *argv[]) 
{
  char *input_file = NULL;
  char *output_file = NULL;
  char *error_msgs_file = NULL;
  char *coral_f = NULL;
  
  int i = 1;
  
  /* currently it is executed as 
     executable -i inputfile -o outputfile -e errorfile -c coralfile
     
     the -c option gives the file where the CORAL code should be dumped 
     when the resulting program is compiled. 
     */
  
  while (i < argc) {
    if (argv[i][0] == '-')	{
      switch (argv[i][1]) {
	
      case 'i' :
	input_file = copy_string(argv[i+1]);	
	i += 2;
	break;
      case 'o' :
	if (strcmp(argv[i], "-options") == 0) {
	  fprintf(stderr, "Usage is \n");
	  fprintf(stderr, "executable -i inputfile -o outputfile");
	  fprintf(stderr, " -e errorfile -c coralfile\n");
	  fprintf(stderr, "Any option(s) can be skipped \n");
	  exit(1);
	}
	output_file = copy_string(argv[i+1]);	
	i += 2;
	break;
      case 'e' :
	error_msgs_file = copy_string(argv[i+1]);	
	i += 2;
	break;
      case 'c' :
	coral_f = copy_string(argv[i+1]);	
	i += 2;
	break;
      default:
	fprintf(stderr, "unknown option %s \n", argv[i]); 
	fprintf(stderr, "Usage is \n");
	fprintf(stderr, "executable -i inputfile -o outputfile");
	fprintf(stderr, " -e errorfile -c coralfile\n");
	fprintf(stderr, "Any option(s) can be skipped \n");
	exit(1);
      }
    }
    else {
      fprintf(stderr, "unknown argument %s \n", argv[i]); 
      i++;
    }
    
  }
    
  scan_input *input_buffer = new scan_input(input_file);
  input_buffer->open_output_file(output_file);
  

  if (!coral_f) {
    coral_f = new char[200];
    sprintf(coral_f, "/tmp/%s.out.P", argv[0]);
  }

  init(input_buffer, error_msgs_file, coral_f);
  
  
  char *str;
  token *current_token;
  int current_position;
  int end_position;
  int line_no;
  
  while (!(input_buffer->end_of_file())) {
    input_buffer->get_next_line(1);     /* set any current token to 
					 * Null
					 */
    str = input_buffer->return_copy_of_line();
    line_no = input_buffer->get_line_number();
    current_position = input_buffer->get_line_position();
    end_position = strlen(str); 
    // current_token = input_buffer->get_next_token();
    current_token = input_buffer->get_token();
    
    /* 
     * these tokens should appear before any other tokens
     * in a line, barring white space and comments. 
     * e.g. currently, i= 10; export .... ; will not 
     * work
     *
     * tokens which are embedded inside are taken care 
     * in the default case. 
     *
     * Later all the tokens will be searched for, instead
     * of just assuming their occurrence at the beginning 
     * of a line
     *
     */
    
    
    switch(current_token->token_type()) {
    case KW_EXPORT :
      {
	export_header_decl = new mystring;
	handle_export *export_info = new handle_export();
	handle_export_declaration(input_buffer, export_info, 
				  export_header_decl);
	input_buffer->ignore_lines();
	output_export_code(input_buffer,export_info, export_dummy_fn, 
			   dummy_temp_name, export_header_decl);
	delete(export_info);
	delete(export_header_decl);
	break;
      }
    case CORAL_BEGIN :
      {
	infoStruct info;
	
	FILE *temp = input_buffer->get_output_file();

	fprintf(temp, "\n");
	fprintf(temp, "  /* to handle CORAL code */\n");

	char buf[256];
	char *temp_str = new_name();
	fprintf(temp, "  extern ExecutionList %s;\n", temp_str);
	sprintf(buf, "static ExecutionList %s; \n", temp_str);
	exec_array_decl->append(buf);

	fprintf(temp, "  if (!(%s.initialized)) {\n", temp_str);
	fprintf(temp, "    %s();\n", exec_array_init_fn_name);
	fprintf(temp, "  }\n");

	handle_coral_code(input_buffer, info);

	char *new_temp_str = new_name();

	if (info.no_of_params) {
	  char *new_params_name = new_name();
	  fprintf(temp, "  ParameterStruct %s[%d];\n",
		  new_params_name, info.no_of_params);
	  for (int i = 0; i < info.no_of_params; i++) {
	    switch(info.type_array[i]) {
	      
	    case TYPE_STRING :
	      fprintf(temp, "  %s[%d].kind = COR_STR;\n", new_params_name, i);
	      break ;
	      
	    case TYPE_INT :
	      fprintf(temp, "  %s[%d].kind = COR_INT;\n", new_params_name, i);
	      break ;
	      
	    case TYPE_LONG :
	      fprintf(temp, "  %s[%d].kind = COR_LONG;\n", new_params_name, i);
	      break ;
	      
	    case TYPE_SHORT :
	      fprintf(temp, "  %s[%d].kind = COR_SHORT;\n", new_params_name, i);
	      break ;
	      
	    case TYPE_FLOAT :
	      fprintf(temp, "  %s[%d].kind = COR_FLOAT;\n", new_params_name, i);
	      break ;
	      
	    case TYPE_DOUBLE :
	      fprintf(temp, "  %s[%d].kind = COR_DOUB;\n", new_params_name, i);
	      break ;
	    }
	    
	    fprintf(temp, "  %s[%d].value_ptr = (void *)&%s;\n", new_params_name,
		    i, info.var_names[i]);
	 
	  }
        fprintf(temp, "  %s.parameters = %s;\n", temp_str, new_params_name);

	}

        sprintf(buf, "  %s(%s);\n", new_temp_str, temp_str);
	exec_array_init_calls->append(buf);

	// Still to put in initialization code
        generate_initialization_code(new_temp_str, info);
	fprintf(temp, "  %s.execute();\n", temp_str);
	fprintf(temp, "  processInputStack();\n");

	delete temp_str;

	fprintf(temp, "\n");
	input_buffer->ignore_lines();
	break;
      }
      
    case CORAL_END : 
      {
	input_buffer->ignore_lines();
	break;
      }
      
    case LX_EOLN :
      break;
      
    case KW_INIT_CORAL:
      /* whenever there is a main program, the user 
       * has to make a call to init_coral() which 
       * initialises the database with some relations
       * The call to dummy fn which enters the relations
       * declared through the export calls is placed 
       * immediately after init_coral().
       */
      fprintf(input_buffer->get_output_file(), "  in_query_loop = 1;\n");
      fprintf(input_buffer->get_output_file(),
	      "  exEnv.C_exec_mode = COR_DOING_IMPERATIVE;\n");
      input_buffer->dump();
      output_call_dummy(input_buffer, dummy_fn_name);
      
      break;
    case LX_HASH :
      /* the translator includes these files  : 
       * hence it is important to detect these files
       * and ignore  them
       */
      
      if (strstr(str, "<stdio.h>")) {
	input_buffer->ignore_lines();
      }
      else { 
	if (strstr(str, "<strings.h>")) {
	  input_buffer->ignore_lines();
	}
	else {
	  input_buffer->dump();
	}
      }
      break;
      default :  
	{
	  input_buffer->unget_token(current_token);
	  /**** handling make_tuple is yet to be properly implemented !!
	     I'm commenting this out for now --- PRAVEEN 

	  int i = handle_embedded_token(input_buffer, 
					current_position, end_position, str);
	  // if no embedded tokens are found, then the 
	  // the statements should be dumped to the output.
	  // Otherwise the embedded token handler should 
	  // dump appropriate code. 
	  //
	  if (i == 0)
	    input_buffer->dump();
	  else
	    input_buffer->ignore_lines();
	  break;
	  *******/
	  input_buffer->dump();
	}
    }
    delete str;
  }
  
  close(input_buffer,export_dummy_fn);

  return 0;
  
}


/* this function parses an export declaration and stores 
 * the necessary information in the structure handle_export.
 * This information is used later to output the 
 * approprite solver
 */

void handle_export_declaration(scan_input *input_buffer, 
			       handle_export *export_info,
			       mystring *export_header_decl) 
{  
  export_info->set_return_type(handle_type_declaration(input_buffer,export_header_decl));
  
  char *s = handle_name_declaration(input_buffer); 
  if (s) {
    export_info->set_name(s);
    export_header_decl->append(s);
  }
  handle_arglist_declaration(input_buffer, export_info, export_header_decl);
  
  
  token *current_token = input_buffer->get_next_token();
  while(1) {
    switch (current_token->token_type()) {
    case LX_EOF :
      fprintf(stderr, "syntax error - unexpected eof\n");
      return ;	
    case LX_SEMICOLON : 
      return;
    case KW_AS :
      s = handle_name_declaration(input_buffer); 
      if (s)
	export_info->set_exported_name(s);
      current_token = input_buffer->get_next_token();
      if (current_token->token_type() != LX_SEMICOLON) { 
	fprintf(stderr, "; expected \n");
	input_buffer->unget_token(current_token);
	return;
      }
      return;
    case LX_EOLN :
      break;
      default :
	fprintf(stderr, "; or as expected \n");
      input_buffer->unget_token(current_token);
      return;
    }
    current_token = input_buffer->get_next_token();
  }
}



kind handle_type_declaration(scan_input *input_buffer,
			     mystring * export_header_decl) 
{
  
  token *current_token;
  token *next_token;
  token *next_to_next_token;
  int syntax_error = 0;
  kind ret_kind;
  lexeme_type t1,t2;
  
  ret_kind.pointer = 0;
  ret_kind.name = NULL;
  ret_kind.type = NULL;
  ret_kind.argname = NULL;
  ret_kind.make = NULL;
  ret_kind._typedef = NULL;
  ret_kind.opt_neg_sign = 0;
  ret_kind.init_pointer = 1;
  
  
  current_token = input_buffer->get_next_token();
  if ((current_token->token_type()) == LX_MINUS) {
    ret_kind.opt_neg_sign = 1;
  }
  else
    input_buffer->unget_token(current_token);
  
  current_token = input_buffer->get_next_token();
  switch (current_token->token_type()) {
  case LX_EOF :
    fprintf(stderr, "syntax error in export declaration \n");
    /* check this up */
    return ret_kind;	
    
  case LX_EOLN :
    input_buffer->get_next_line();
    current_token = input_buffer->get_next_token();
    break;
  case KW_CHAR :
    ret_kind.value = CHAR;
    export_header_decl->append("char");
    break;
  case KW_FLOAT:
    ret_kind.value = FLOAT;
    export_header_decl->append("float");
    break;
  case KW_DOUBLE:
    ret_kind.value = DOUBLE;
    export_header_decl->append("double");
    break;
  case KW_VOID:
    ret_kind.value = VOID;
    export_header_decl->append("void");
    break;
  case KW_INT :
    next_token = input_buffer->get_next_token();
    t1 = next_token->token_type();
    if (t1 == KW_SHORT) {
      next_to_next_token = input_buffer->get_next_token();
      t2 = next_to_next_token->token_type();
      if (t2 == KW_UNSIGNED) {
	ret_kind.value = UNSIGNED_SHORT_INT;
	export_header_decl->append("unsigned short int");
      }
      else {
	ret_kind.value = SHORT_INT;
	export_header_decl->append("short int");
	input_buffer->unget_token(next_to_next_token);
      }
      
      break;
    }	
    if (t1 == KW_LONG) {
      next_to_next_token = input_buffer->get_next_token();
      t2 = next_to_next_token->token_type();
      if (t2 == KW_UNSIGNED) {
	ret_kind.value = UNSIGNED_LONG_INT;
	export_header_decl->append("unsigned long int");
      }
      else {
	ret_kind.value = LONG_INT;
	export_header_decl->append("long int");
	input_buffer->unget_token(next_to_next_token);
      }
      
      break;
    }	
    if (t1 == KW_UNSIGNED) {
      next_to_next_token = input_buffer->get_next_token();
      t2 = next_to_next_token->token_type();
      if (t2 == KW_LONG) {
	ret_kind.value = UNSIGNED_LONG_INT;
	export_header_decl->append("unsigned long int");
      }
      else 
	if (t2 == KW_SHORT) {
	  ret_kind.value = UNSIGNED_SHORT_INT;
	  export_header_decl->append("unsigned short int");
	}
	else {
	  ret_kind.value = UNSIGNED_INT;
	  export_header_decl->append("unsigned int");
	  input_buffer->unget_token(next_to_next_token);
	}
      
      break;
    }	
    
    ret_kind.value = INT;
    export_header_decl->append("int");
    input_buffer->unget_token(next_token);
    break;
  case KW_SHORT:
    next_token = input_buffer->get_next_token();
    t1 = next_token->token_type();
    if (t1 == KW_INT) {
      next_to_next_token = input_buffer->get_next_token();
      t2 = next_to_next_token->token_type();
      if (t2 == KW_UNSIGNED) {
	ret_kind.value = UNSIGNED_SHORT_INT;
	export_header_decl->append("unsigned short int");
      }
      else {
	ret_kind.value = SHORT_INT;
	export_header_decl->append("short int");
	input_buffer->unget_token(next_to_next_token);
      }
      
      break;
    }	
    if (t1 == KW_UNSIGNED) {
      ret_kind.value = UNSIGNED_SHORT_INT;
      export_header_decl->append("unsigned short int");
      next_to_next_token = input_buffer->get_next_token();
      t2 = next_to_next_token->token_type();
      if (t2 != KW_INT)
	input_buffer->unget_token(next_to_next_token);
      break;
    }	
    
    ret_kind.value = SHORT_INT;
    export_header_decl->append("short int");
    input_buffer->unget_token(next_token);
    break;
  case KW_LONG:
    next_token = input_buffer->get_next_token();
    t1 = next_token->token_type();
    if (t1 == KW_INT) {
      next_to_next_token = input_buffer->get_next_token();
      t2 = next_to_next_token->token_type();
      if (t2 == KW_UNSIGNED) {
	ret_kind.value = UNSIGNED_LONG_INT;
	export_header_decl->append("unsigned long int");
      }
      else {
	ret_kind.value = LONG_INT;
	export_header_decl->append("long int");
	input_buffer->unget_token(next_to_next_token);
      }
      
      break;
    }	
    if (t1 == KW_UNSIGNED) {
      ret_kind.value = UNSIGNED_LONG_INT;
      export_header_decl->append("unsigned long int");
      next_to_next_token = input_buffer->get_next_token();
      t2 = next_to_next_token->token_type();
      if (t2 != KW_INT)
	input_buffer->unget_token(next_to_next_token);
      break;
    }	
    
    ret_kind.value = LONG_INT;
    export_header_decl->append("long int");
    input_buffer->unget_token(next_token);
    break;
  case KW_UNSIGNED:
    next_token = input_buffer->get_next_token();
    t1 = next_token->token_type();
    if (t1 == KW_SHORT) {
      ret_kind.value = UNSIGNED_SHORT_INT;
      export_header_decl->append("unsigned short int");
      next_to_next_token = input_buffer->get_next_token();
      t2 = next_to_next_token->token_type();
      if (t2 != KW_INT)
	input_buffer->unget_token(next_to_next_token);
      break;
    }	
    if (t1 == KW_LONG) {
      ret_kind.value = UNSIGNED_LONG_INT;
      export_header_decl->append("unsigned long int");
      next_to_next_token = input_buffer->get_next_token();
      t2 = next_to_next_token->token_type();
      if (t2 != KW_INT)
	input_buffer->unget_token(next_to_next_token);
      break;
    }	
    if (t1 == KW_INT) {
      next_to_next_token = input_buffer->get_next_token();
      t2 = next_to_next_token->token_type();
      if (t2 == KW_LONG) {
	ret_kind.value = UNSIGNED_LONG_INT;
	export_header_decl->append("unsigned long int");
      }
      else 
	if (t2 == KW_SHORT) {
	  ret_kind.value = UNSIGNED_SHORT_INT;
	  export_header_decl->append("unsigned short int");
	}
	else {
	  ret_kind.value = UNSIGNED_INT;
	  export_header_decl->append("unsigned int");
	  input_buffer->unget_token(next_to_next_token);
	}
      
      break;
    }
    
    ret_kind.value = UNSIGNED_INT;
    export_header_decl->append("unsigned int");
    input_buffer->unget_token(next_token);
    break;
  case KW_ARG : 
    ret_kind.value = ARG;
    export_header_decl->append("Arg");
    break;
  case KW_STRING : 
    ret_kind.value = STRING;
    export_header_decl->append("char *");
    ret_kind.name = "string";
    break;
  case KW_CLASS : 
    fprintf(stderr, "class declaration in export \
		declaration not handled properly \n");
    ret_kind.value = CLASS;
    ret_kind.name = copy_string(current_token->token_str());
    /* get the name */
    /* should put some checks here */
    input_buffer->get_next_token();
    break;
  case KW_STRUCT : 
    fprintf(error_file, "struct declaration in export \
		declaration not handled properly \n");
    ret_kind.value = STRUCT;
    ret_kind.name = copy_string(current_token->token_str());
    /* get the name */
    input_buffer->get_next_token();
    break;
    default :
      fprintf(error_file, "unimplemented features eg \
		typedef, macros etc. %d, %s\n",
	      current_token->token_type(), current_token->token_str());
  }
  
  ret_kind.pointer = get_optional_pointer(input_buffer);
  
  export_header_decl->append(" ");
  for (int t = 0; t < ret_kind.pointer; t++) {
    export_header_decl->append("*");
  }
  export_header_decl->append(" ");
  return ret_kind;
}

int get_optional_pointer(scan_input * input_buffer) 
{
  
  token *current_token = input_buffer->get_next_token();
  int i = 0;
  while ((current_token->token_type()) == LX_STAR) {
    i++;
    current_token = input_buffer->get_next_token();
  }
  input_buffer->unget_token(current_token);
  return i;
}

char *handle_name_declaration(scan_input * input_buffer) 
{
  token *current_token = input_buffer->get_next_token();
  switch (current_token->token_type()) {
  case LX_EOF :
    fprintf(stderr, "syntax error in export declaration \n");
    return NULL;	
    
  case LX_IDENTIFIER :
    return current_token->token_str();
    default :
      fprintf(stderr, "syntax error - identifer expected \n");
    return NULL;
  }
  
}


void handle_arglist_declaration(scan_input * input_buffer, 
				handle_export * export_info,
				mystring *export_header_decl) 
{  
  lexeme_type t;
  token *current_token = input_buffer->get_next_token();
  if (current_token->token_type() != LX_LPAREN) {
    fprintf(stderr, " syntax error, ( expected \n");
    input_buffer->unget_token(current_token);
  }
  export_header_decl->append("(");
  
  current_token = input_buffer->get_next_token();
  t = current_token->token_type();
  
  while(1) {
    
    switch (t) {
      
    case LX_EOF :
      fprintf(stderr, " syntax error- unexpected eof\n");
      return;
    case LX_RPAREN :
      //fprintf(stderr, "done with arglist \n");
      export_header_decl->append(");\n");
      return;
    case LX_SEMICOLON :
      //fprintf(stderr, "syntax error - ) expected \n");
      input_buffer->unget_token(current_token);
      return;
    case LX_COMMA :
      current_token = input_buffer->get_next_token();
      export_header_decl->append(",");
      t = current_token->token_type();
      break;
    case KW_AS :
      fprintf(stderr, "syntax error - ) expected \n");
      input_buffer->unget_token(current_token);
      return;
      default :
	input_buffer->unget_token(current_token);
      export_info->put_next_arg(handle_type_declaration
				(input_buffer,export_header_decl));
      current_token = input_buffer->get_next_token();
      t = current_token->token_type();
    }
    
    
  }
  
}

struct vars_list *lookup_tuple_var(char *s, struct vars_list *tuple_list)
{
  if (s == NULL)
    return NULL;
  
  while (tuple_list) {
    if (strcmp(s, tuple_list->string) == 0)	
      return tuple_list;
    tuple_list = tuple_list->next;
  }
  
  return NULL;
}

struct vars_list *lookup_relation_var(char *s, struct vars_list *relation_list)
{
  if (s == NULL)
    return NULL;
  
  while (relation_list) {
    if (strcmp(s, relation_list->string) == 0)	
      return relation_list;
    relation_list = relation_list->next;
  }
  
  return NULL;
}





char *new_name() {
  static int i = 11;
  char buf[10];
  
  sprintf(buf, "%s%d", "temp__", i++);
  char *s = new char[strlen(buf) + 1];
  strcpy(s, buf);
  return s;
}



int handle_embedded_token(scan_input * input_buffer, int current_position,
			  int end_position, char *str) {
  
  /* routine to search for embedded tokens */
  
  int pos = current_position; 
  token *current_token;
  current_token = input_buffer->get_token();
  
/* ** I dont understand what this does --- PRAVEEN

  while(((current_token->token_type()) != LX_EOLN) && 
	((current_token->token_type()) != LX_EOF)) {
    switch(current_token->token_type()) {
    case KW_MAKE_TUPLE : 
      {
	handle_make_tuple(input_buffer,pos,end_position,str); 
	return 1;
      }
      default :
	pos = input_buffer->get_line_position();
      current_token = input_buffer->get_token();
      break;
    }
  }
*/
  while(((current_token->token_type()) != LX_EOLN) && 
	((current_token->token_type()) != LX_EOF)) {
    pos = input_buffer->get_line_position();
    current_token = input_buffer->get_token();
  }

  return 0;
}

/* for each line between \[ and \], call get_var which generates the 
 * appropriate code for that line 
 */
void handle_coral_code(scan_input *input_buffer, infoStruct& info)
{
  char *s = NULL;

  coral_file_used = 1;

  coral_file_dump_fn->append("\n  fprintf(fd, \"c_module.\\n\");\n");
  while ((s == NULL) || (strcmp(s,"end_of_file"))) {
    input_buffer->get_next_line();
    s = input_buffer->get_var(info);
  }
  coral_file_dump_fn->append("  fprintf(fd, \"end_c_module.\\n\\n\");\n");
}

#define ADD_CODE   exec_array_initializations->append(buf)
void generate_initialization_code( char *fn_name, infoStruct& info)
{
  char buf[256];

  sprintf(buf, "static void %s(ExecutionList& exlist)\n",fn_name);
	  
  ADD_CODE;
  sprintf(buf, "{\n  /* initialization code for exlist */\n");
  ADD_CODE;
  sprintf(buf, "  exlist.initialize(%d, %d, NULL);\n",
	  EXEC_LIST_SIZE, info.no_of_params);
  ADD_CODE;
  
  sprintf(buf, "  ParserStruct *pstruct; int i = 0;\n");
  ADD_CODE;
  sprintf(buf, "  /* call yyparse on %s */\n", coral_file_name);
  ADD_CODE;
  sprintf(buf, "  for(;;i++) {\n");
  ADD_CODE;
  sprintf(buf, "    parserStruct.rule_list = NULL;\n");
  ADD_CODE;
  sprintf(buf, "    if (yyparse()) {\n");
  ADD_CODE;
  sprintf(buf, "\tfprintf(stderr, \"yyparse error !\\n\");\n\texit(1);\n    }\n");
  ADD_CODE;
  sprintf(buf, "    if (c_module_separator) break;\n");
  ADD_CODE;
  sprintf(buf, "    pstruct = new ParserStruct;\n");
  ADD_CODE;

  sprintf(buf, "    copy_structs(pstruct, parserStruct);\n");
  ADD_CODE;

  sprintf(buf, "  /* save ParserStruct in exlist */\n");
  ADD_CODE;
  sprintf(buf, "    exlist.add(pstruct);\n  }\n");
  ADD_CODE;
  sprintf(buf, "  c_module_separator = 0;\n}\n");
  ADD_CODE;

}
