/************************************************************************
 ========================================================================
 CORAL 
 (c)  Copyright R. Ramakrishnan and The CORAL Group, 
 University of Wisconsin at Madison.
 (1992) All Rights Reserved.
 Version 0.1
 ========================================================================



 ------------------------------------------------------------------------
 CORAL Version 0.1
 RESEARCH SOFTWARE DISCLAIMER -------------------------------------------
 ------------------------------------------------------------------------

    As unestablished, research software, this program is provided free of 
    charge on an "as is" basis without warranty of any kind, either 
    express or implied.  Acceptance and use of this program constitutes 
    the user's understanding that (s)he will have no recourse for any 
    actual or consequential damages, including, but not limited to, 
    lost profits or savings, arising out of the use of or inability to 
    use this program.  

 ------------------------------------------------------------------------
 USER AGREEMENT ---------------------------------------------------------
 ------------------------------------------------------------------------

     BY ACCEPTANCE AND USE OF THIS EXPERIMENTAL PROGRAM
     THE USER AGREES TO THE FOLLOWING:

     a.  This program is provided free of charge for the user's personal, 
	 non-commercial, experimental use.

     b.  All title, ownership and rights to this program and any copies 
         remain with the copyright holder, irrespective of the ownership 
	 of the media on which the program resides.

     c.  The user is permitted to create derivative works to this program.  
         However, all copies of the program and its derivative works must
         contain the CORAL copyright notice, the UNESTABLISHED SOFTWARE 
         DISCLAIMER and this USER AGREEMENT.

     d.  The user understands and agrees that this program and any 
         derivative works are to be used solely for experimental purposes 
	 and are not to be sold or commercially exploited in any manner 
	 WITHOUT EXPRESS WRITTEN PERMISSION.

     e.  We request that the user supply us with a copy of any changes, 
         enhancements, or derivative works which the user may create,
	 with the user's permission to redistribute it.
	 Copies of such material should be sent to:  CORAL@CS.WISC.EDU

-------------------------------------------------------------------------
*************************************************************************/



/* 
 
 Has the following declarations :

 class scan_input

 */

#define MAX_NUM_OF_LINES 10
#define TOO_BIG 10000
#define TRUE 1
#define FALSE 0

typedef class line_descriptor LINE;

extern class token;
extern class infoStruct;

class scan_input {


    LINE **lines;	/* the set of input lines 
			 * which were read in and 
			 * are currently of interest
	 		 */

    int top;		/* current line out of all 
			 * the lines stored
			 */
			
	int current_line_number;
	int limit; 	/* the maximum number of 
			 * lines that can be stored
			 * at a time
			 */

	char *input_file_name;
	FILE *input_file;

	char *output_file_name;
	FILE *output_file;

	void resize();
	int get_line();
	int eof_reached;
	int eoln_reached;
	token *next_token;
public: 

     scan_input(char *);
     ~scan_input();

     int get_line_number() 
		{
		return current_line_number;
		}

     int get_line_position() 
		{
		return (lines[top]->get_pos());
		}

     void set_line_number(int);

     int get_line_limit()
		{
		return limit;
		}

     int get_next_line(int i=0);
     int get_new_line();

     token * get_token();

     /* get_arg used to get expressions, terminated by either a 
        comma or a ) 
      */ 
     token * get_arg();

     /* get_var is used for declarative code 
      * for each line, it generates the appropriate 
      * line that should be dumped
      */
//     char * get_var(char *, char *, infoStruct&);
     char * get_var(infoStruct&);
     int unget_token(token *);

     token * get_next_token();

     void open_output_file(char *);

     void dump();

     void ignore_lines();

     int end_of_file() { return (eof_reached  == TRUE); }
     int end_of_line() { return (eoln_reached  == TRUE); }

     char * return_copy_of_line() { return (lines[top]->return_line()); }
     FILE * get_output_file() { return output_file; } 
};
