/************************************************************************
 ========================================================================
 CORAL 
 (c)  Copyright R. Ramakrishnan and The CORAL Group, 
 University of Wisconsin at Madison.
 (1992) All Rights Reserved.
 Version 0.1
 ========================================================================



 ------------------------------------------------------------------------
 CORAL Version 0.1
 RESEARCH SOFTWARE DISCLAIMER -------------------------------------------
 ------------------------------------------------------------------------

    As unestablished, research software, this program is provided free of 
    charge on an "as is" basis without warranty of any kind, either 
    express or implied.  Acceptance and use of this program constitutes 
    the user's understanding that (s)he will have no recourse for any 
    actual or consequential damages, including, but not limited to, 
    lost profits or savings, arising out of the use of or inability to 
    use this program.  

 ------------------------------------------------------------------------
 USER AGREEMENT ---------------------------------------------------------
 ------------------------------------------------------------------------

     BY ACCEPTANCE AND USE OF THIS EXPERIMENTAL PROGRAM
     THE USER AGREES TO THE FOLLOWING:

     a.  This program is provided free of charge for the user's personal, 
	 non-commercial, experimental use.

     b.  All title, ownership and rights to this program and any copies 
         remain with the copyright holder, irrespective of the ownership 
	 of the media on which the program resides.

     c.  The user is permitted to create derivative works to this program.  
         However, all copies of the program and its derivative works must
         contain the CORAL copyright notice, the UNESTABLISHED SOFTWARE 
         DISCLAIMER and this USER AGREEMENT.

     d.  The user understands and agrees that this program and any 
         derivative works are to be used solely for experimental purposes 
	 and are not to be sold or commercially exploited in any manner 
	 WITHOUT EXPRESS WRITTEN PERMISSION.

     e.  We request that the user supply us with a copy of any changes, 
         enhancements, or derivative works which the user may create,
	 with the user's permission to redistribute it.
	 Copies of such material should be sent to:  CORAL@CS.WISC.EDU

-------------------------------------------------------------------------
*************************************************************************/


#include <stdlib.h>
#include <stdio.h>
#include <strings.h>
#include "scanner.h"
#include "line_info.h"
#include "scan_input.h"
#include "export.h"
#include "mystrings.h"
#include "hashdefines.h"
#include "translate.h"

extern int coral_var_number;
extern FILE *error_file;

void gen_comma()
{
  fprintf(stderr, ",");
}

void gen_rparen() 
{
  fprintf(stderr, ")");
}

void gen_scolon() 
{
  fprintf(stderr, ";\n");
}

char *gen_tuple_stmt(struct vars_list *rel) 
{
  char *tuple_name;
  if (rel) {
    tuple_name = new_name();
    fprintf(stderr, "Tuple *%s =  new Tuple(", tuple_name);
    if (rel->arg_count < 5) 
      fprintf(stderr, "make_arglist%d(", rel->arg_count);
    else
      fprintf(stderr, "make_arglist(%d,", rel->arg_count);
    coral_var_number = 0;
    struct arg_list *args;
    args = rel->args;
    for (int i = 0; i < rel->arg_count - 1; i++) {
      
      gen_arg(args);
      gen_comma();
      args = args->next;
    }
    gen_arg(args);
    gen_rparen();
    gen_rparen();
    gen_scolon();
    
  }
  else {
    fprintf(stderr, "rel is NULL \n");
  }
  
  return tuple_name;
}



void gen_arg(struct arg_list *arg)
{
  char *s;
  if (arg == NULL)
    return;
  switch ((arg->arg_type)->token_type()) {
  case LX_IDENTIFIER :
    s = (arg->arg_type)->token_str();
    fprintf(stderr, "make_arg(%s)", s);
    break;
    
  case LX_COR_IDENTIFIER :
    s = (arg->arg_type)->token_str();
    fprintf(stderr, "make_var(%s, %d)", s, coral_var_number++);
    break;
    
  case LX_INTEGER : 
    fprintf(stderr, "make_arg(%d)", (arg->arg_type)->token_int());
    break;
  case LX_DOUBLE :
    fprintf(stderr, "make_arg(%f)", (arg->arg_type)->token_double());
    break;
  case LX_STRING :
    fprintf(stderr, "make_arg(\"%s\")", (arg->arg_type)->token_str());
    break;
  case LX_EXPR :
    s = (arg->arg_type)->token_str();
    fprintf(stderr, "make_arg(%s)", s);
    break;
    default :
      fprintf(stderr, "unknown argument in relation \n");
    break;
  }
}


// procedure to handle decls like make_tuple(X,Y) etc. 

/* This function gets each argument in the make tuple 
 * call by calling get_arg() function. 
 * Then code to convert each argument to Arg * type is 
 * generated, through the means of make_arg and make_var 
 * defined in interface.C
 */
void handle_make_tuple(scan_input *input_buffer,
		       int current_position, int /*end_position*/, char *str) 
{      
  token *current_token = input_buffer->get_next_token();
  
  if (current_token->token_type() != LX_LPAREN) {
    fprintf(error_file, "syntax error \"(\" expected \n");
  }
  
  
  current_token = input_buffer->get_arg();
  
  struct arg_list *begin;
  struct arg_list *temp = new (struct arg_list);
  struct arg_list *next_temp;
  int arg_count = 0;
  
  begin = temp;
  
  while (current_token->token_type() != LX_RPAREN) {
    arg_count++;
    next_temp = new (struct arg_list);	
    next_temp->arg_type = current_token;
    temp->next = next_temp;
    temp = next_temp;
    current_token = input_buffer->get_arg();
    if (current_token->token_type() != LX_RPAREN) {
      if (current_token->token_type() != LX_COMMA) {
	int line_number = input_buffer->get_line_number();
	int col_number = input_buffer->get_line_position();
	fprintf(error_file, "line %d col %d syntax error \",\" expected \n",
		line_number, col_number);
      }
      current_token = input_buffer->get_arg();
    }
  }
  
  int pos = input_buffer->get_line_position();
  
  temp = begin;
  begin = begin->next;
  delete(temp);
  
  // begin points to beginning of arg_list
    
  char *name_of_tuple = output_make_tuple(input_buffer, arg_count,
					  begin, str, current_position, pos);
  // char *new_str = subs_str(str, name_of_tuple, current_position, pos);
  
  // fprintf(stderr, "%s\n", str);
  // fprintf(stderr, "%s\n", new_str);
}



char * output_make_tuple(scan_input *input_buffer, int arg_count, struct arg_list *begin, char *str, int pos1, int pos2) {
  
  char buf[256];
  int pos = 0;
  int i;
  int len;
  struct arg_list *temp;
  FILE *output_file;
  char *name;
  
  output_file = input_buffer->get_output_file();
  
  char * name_of_tuple = new_name();
  fprintf(output_file, "Tuple * %s; \n{\n", name_of_tuple);
  for (i = 0, temp = begin; i < arg_count; i++, temp = temp->next) {
    gen_tuple_arg_stmt(output_file, i, temp);
  }
  
  len = strlen(name_of_tuple);
  strcpy(buf+pos, name_of_tuple);
  pos += len;
  buf[pos++] = '='; 
  name = "new Tuple(make_arglist(";
  len = strlen(name);
  strcpy(buf+pos, name);
  pos += len;
  
  if (arg_count != 0) {
    char tmp[10];
    sprintf(tmp, "%d", arg_count);
    len = strlen(tmp);
    strncpy(buf + pos, tmp, len);
    pos += len;
    buf[pos++] = ',';
  }
  
  for (i = 0; i < arg_count - 1; i++) {
    name = concat1("arg", i);
    len = strlen(name);
    strcpy(buf+pos, name);
    pos += len;
    buf[pos++] = ',';
  }
  if (arg_count != 0) {
    name = concat1("arg", arg_count-1);
    len = strlen(name);
    strcpy(buf+pos, name);
    pos += len;
  }
  buf[pos++] = ')';
  buf[pos++] = ')';
  buf[pos++] = ';';
  buf[pos++] = '\0';
  
  fprintf(output_file, "%s\n", buf);
  fprintf(output_file, "}\n");
  char *new_str = subs_str(str, name_of_tuple, pos1, pos2);
  fprintf(output_file, "%s\n", new_str);
  return name_of_tuple;
}

void gen_tuple_arg_stmt(FILE *output_file, int i, struct arg_list *arg) {
  
  char *name; 
  char *s;
  if (arg == NULL)
    return;
  name = concat1("arg", i);
  fprintf(output_file, "Arg *%s = ", name);
  switch ((arg->arg_type)->token_type()) {
  case LX_IDENTIFIER :
    s = (arg->arg_type)->token_str();
    fprintf(output_file, "make_arg(%s)", s);
    break;
    
  case LX_COR_IDENTIFIER :
    s = (arg->arg_type)->token_str();
    fprintf(output_file, "make_var(\"%s\", %d)", s+1, coral_var_number++);
    // s + 1 to remove the dollar
      
      break;
    
  case LX_EXPR :
    s = (arg->arg_type)->token_str();
    fprintf(output_file, "make_arg(%s)", s);
    break;
    default :
      fprintf(output_file, "make_arg(1000)", s); // just for compiling
	fprintf(error_file, "unknown argument in relation \n");
    break;
  }
  fprintf(output_file, ";\n");
}


char *subs_str(char *str, char *name_of_tuple, int start_pos, int end_pos){
  
  /* fprintf(stderr, "name is %s, str is %s positions are %d %d \n",
     name_of_tuple, str, start_pos, end_pos);*/
  
  int len = strlen(str);
  int len_of_name = strlen(name_of_tuple);
  int i,j;
  
  if (str == NULL)
    return str;
  
  if (name_of_tuple == NULL)
    return str;
  
  if (start_pos >= len)
    return str;
  
  if (end_pos >= len)
    return str;
  
  if ((end_pos - start_pos) >= len_of_name) {
    for (i = start_pos, j = 0; j < len_of_name; i++, j++) 
      str[i] = name_of_tuple[j];
    for (i = start_pos + len_of_name; i < end_pos; i++) 
      str[i] = ' ';
    return str;
  }
  else {
    char *new_str = new (char [len + len_of_name]);
    for (i = 0; i < start_pos; i++) 
      new_str[i] = str[i];
    for (i = start_pos, j = 0; j < len_of_name; i++, j++) 
      new_str[i] = name_of_tuple[j];
    for (i = end_pos; i < len; i++) 
      new_str[i] = str[i];
    return new_str;
  }
  
}
