/************************************************************************
 ========================================================================
 CORAL 
 (c)  Copyright R. Ramakrishnan and The CORAL Group, 
 University of Wisconsin at Madison.
 (1992) All Rights Reserved.
 Version 0.1
 ========================================================================



 ------------------------------------------------------------------------
 CORAL Version 0.1
 RESEARCH SOFTWARE DISCLAIMER -------------------------------------------
 ------------------------------------------------------------------------

    As unestablished, research software, this program is provided free of 
    charge on an "as is" basis without warranty of any kind, either 
    express or implied.  Acceptance and use of this program constitutes 
    the user's understanding that (s)he will have no recourse for any 
    actual or consequential damages, including, but not limited to, 
    lost profits or savings, arising out of the use of or inability to 
    use this program.  

 ------------------------------------------------------------------------
 USER AGREEMENT ---------------------------------------------------------
 ------------------------------------------------------------------------

     BY ACCEPTANCE AND USE OF THIS EXPERIMENTAL PROGRAM
     THE USER AGREES TO THE FOLLOWING:

     a.  This program is provided free of charge for the user's personal, 
	 non-commercial, experimental use.

     b.  All title, ownership and rights to this program and any copies 
         remain with the copyright holder, irrespective of the ownership 
	 of the media on which the program resides.

     c.  The user is permitted to create derivative works to this program.  
         However, all copies of the program and its derivative works must
         contain the CORAL copyright notice, the UNESTABLISHED SOFTWARE 
         DISCLAIMER and this USER AGREEMENT.

     d.  The user understands and agrees that this program and any 
         derivative works are to be used solely for experimental purposes 
	 and are not to be sold or commercially exploited in any manner 
	 WITHOUT EXPRESS WRITTEN PERMISSION.

     e.  We request that the user supply us with a copy of any changes, 
         enhancements, or derivative works which the user may create,
	 with the user's permission to redistribute it.
	 Copies of such material should be sent to:  CORAL@CS.WISC.EDU

-------------------------------------------------------------------------
*************************************************************************/


#include <stdlib.h>
#include <stdarg.h>
#include <stdio.h>
#include <string.h>

#include "line_info.h"


/* Flag indicating that no returned peek-ahead character awaits
   GET_CHAR. */

const int NO_UNREAD_CHAR = -1;


/* Initial length of a line.  The line grows dynamically, so this
   value is not a limit on line length.  However, it should be longer
   than most lines to save time. */

const int MAX_LINE_LENGTH = 128;

/* Local functions: */

char * copy_string (char *);


/* Open and initialize a file_descriptor for the file with name
   FILENAME.  If the name is "", the descriptor reads from STDIN.  If the
   file cannot be opened, report an error and return an invalid
   descriptor. */

line_descriptor::line_descriptor (FILE *fp, char *filename)
{
  
  file = fp;
  name = copy_string (filename);
  
  returned_char = NO_UNREAD_CHAR; /* No unread character */
  line = new (char [MAX_LINE_LENGTH + 1]); /* Extra for NULL byte */
  if (line == NULL) {
    fprintf(stderr, "new failed in open_line_descriptor\n");
    exit(1);
  }
  *line = '\0';			/* Empty line */
  pos = 0;
  max_pos = MAX_LINE_LENGTH ;
}


/* Return true if a line descriptor is valid (i.e., can be used) and
   false otherwise. */

int line_descriptor::valid ()
{
  return (line != NULL);
}


/* Close a line descriptor and free its resources. */

void line_descriptor::close_line_descriptor ()
{
  delete (name);
  delete (line);
  line = NULL;
}


/* Given a line descriptor, return the next character (taking into
   account characters returned by UNGET_CHAR).  If the file is completely
   read, return EOF_CHAR.  */

int line_descriptor::get_char ()
{
  if (line == NULL)
    {
      fprintf (stderr, "get_char invoked on invalid line descriptor\n");
      return (EOF_CHAR);
    }
  
  if (returned_char != NO_UNREAD_CHAR) /* Returned peek-ahead character */
    {
      int c = returned_char;
      
      returned_char = NO_UNREAD_CHAR;
      pos++;
      return (c);
    }
  
  if (line[pos] == '\0')	/* End of line, so refill it */
    {
      return (EOLN_CHAR);
    }
  
  return (line [pos ++]);
}


/* Given a line descriptor, stuff character C back into it so the next
   GET_CHAR will return it.  NB, the character does not have to be the
   previously read one. */

void line_descriptor::unget_char (int c)
{
  if (line == NULL)
    fprintf (stderr, "unget_char invoked on invalid line descriptor\n");
  else if (returned_char != NO_UNREAD_CHAR)
    fprintf (stderr, "Two unget_char's in succession. Second ignored\n");
  else {
    if (pos == 0) {
      fprintf(stderr, "Warning : unget at position 0 \n");
    }
    else
      pos--;
    returned_char = c;
  }
}



/* Copy the string into a newly allocated area and return the copy. */

char *  copy_string (char *str)
{
  if (str == NULL)
    return NULL;
  
  char *nstr = new (char[strlen (str) + 1]);
  
  if (nstr == NULL) {
    fprintf(stderr, "new failed in copy_string\n");
    exit(1);
  }
  strcpy (nstr, str);
  return (nstr);
}

int line_descriptor::get_line()
{
  int pos;
  
  if (line == NULL)
    {
      fprintf (stderr, "get_line invoked on invalid line descriptor\n");
      return (EOF_CHAR);
    }
  
  
  int c;
  
  c = fgetc (file);
  if (c == EOF)
    return (EOF_CHAR);
  pos = 0;
  while (c != '\n' && c != EOF)
    {
      line[pos ++] = c;
      if (pos == max_pos)	/* Line too short, double its length */
	{
	  char *new_line = new (char [max_pos * 2]);
	  
	  if (new_line == NULL) {
	    fprintf(stderr, "new failed in get_char\n");
	    exit(1);
	  }
	  strncpy (new_line, line, max_pos);
	  delete (line);
	  line = new_line;
	  max_pos = 2 * max_pos;
	}
      c = fgetc (file);
    }
/*
  line[pos ++] = c;
*/
  line[pos ++] = '\n';
  line[pos ++] = '\0';
  pos = 0;
  
  if (c == EOF)
    return EOF_CHAR;
  return EOLN_CHAR;
}

void line_descriptor::dump_line(FILE *file) 
{
  /* check if line is empty or not */
  if (*line == '\0') {
    /* fprintf(stderr, "dump_line : line is empty \n"); */
    fprintf(file, "\n");
    return;
  }
  fprintf(file, "%s", line);
}

