/************************************************************************
 ========================================================================
 CORAL 
 (c)  Copyright R. Ramakrishnan and The CORAL Group, 
 University of Wisconsin at Madison.
 (1992) All Rights Reserved.
 Version 0.1
 ========================================================================



 ------------------------------------------------------------------------
 CORAL Version 0.1
 RESEARCH SOFTWARE DISCLAIMER -------------------------------------------
 ------------------------------------------------------------------------

    As unestablished, research software, this program is provided free of 
    charge on an "as is" basis without warranty of any kind, either 
    express or implied.  Acceptance and use of this program constitutes 
    the user's understanding that (s)he will have no recourse for any 
    actual or consequential damages, including, but not limited to, 
    lost profits or savings, arising out of the use of or inability to 
    use this program.  

 ------------------------------------------------------------------------
 USER AGREEMENT ---------------------------------------------------------
 ------------------------------------------------------------------------

     BY ACCEPTANCE AND USE OF THIS EXPERIMENTAL PROGRAM
     THE USER AGREES TO THE FOLLOWING:

     a.  This program is provided free of charge for the user's personal, 
	 non-commercial, experimental use.

     b.  All title, ownership and rights to this program and any copies 
         remain with the copyright holder, irrespective of the ownership 
	 of the media on which the program resides.

     c.  The user is permitted to create derivative works to this program.  
         However, all copies of the program and its derivative works must
         contain the CORAL copyright notice, the UNESTABLISHED SOFTWARE 
         DISCLAIMER and this USER AGREEMENT.

     d.  The user understands and agrees that this program and any 
         derivative works are to be used solely for experimental purposes 
	 and are not to be sold or commercially exploited in any manner 
	 WITHOUT EXPRESS WRITTEN PERMISSION.

     e.  We request that the user supply us with a copy of any changes, 
         enhancements, or derivative works which the user may create,
	 with the user's permission to redistribute it.
	 Copies of such material should be sent to:  CORAL@CS.WISC.EDU

-------------------------------------------------------------------------
*************************************************************************/

typedef enum {

CHAR, INT, FLOAT, DOUBLE, VOID, 
SHORT_INT, LONG_INT, UNSIGNED_INT, UNSIGNED_SHORT_INT, 
UNSIGNED_LONG_INT,
ARG, STRING, CLASS, STRUCT
} type_of_arg ;

typedef struct {

	type_of_arg value; 
	int pointer;	/* whether it is a pointer or not */
	char *name;	/* the type without the -ve sign and 
			 * without any * signs
			 */

	char *type;	  /* used for typecasting when 
			   * the appropriate argument is 
			   * being extracted from the 
			   * input tuple *
			   */

	char *argname;	  /* the name of the variable associted
			   * this type
			   */

	int init_pointer; /* for arguments (& return types), it 
			   * indicates whether the pointer
			   * should be allocated memory or not
			   */ 

	char *make;	  /*
			   * used for determining which fn  
			   * to call in order to extract the 
			   * value out of input tuple arglist
			   */

	char *_typedef;	  /* not used */
	int opt_neg_sign; /* whether the optional -ve sign 
			   * was present or not
			   */
} kind;

extern char * copy_string(char *);

class handle_export {

public :
	handle_export();

	kind * get_return_type() 
		{ return & return_type; }
	void set_return_type(kind k)
		{ return_type = k; } 

	int get_num_of_args()
		{ return num_of_args; }

	void set_num_of_args(int i) 
		{ num_of_args = i; } 


	void set_name(char *s)
		{ name = copy_string(s); }

	void set_exported_name(char *s)
		{ opt_exported_name = copy_string(s); }

	char * get_name()
		{ return copy_string(name); }

	char * get_exported_name()
		{ return copy_string(opt_exported_name); }

	void put_next_arg(kind);
	kind * get_arg(int number);
private :

kind return_type;
kind *args_type;
int num_of_args;

int limit;

char *name;
char *opt_exported_name;
};
