/************************************************************************
 ========================================================================
 CORAL 
 (c)  Copyright R. Ramakrishnan and The CORAL Group, 
 University of Wisconsin at Madison.
 (1992) All Rights Reserved.
 Version 0.1
 ========================================================================



 ------------------------------------------------------------------------
 CORAL Version 0.1
 RESEARCH SOFTWARE DISCLAIMER -------------------------------------------
 ------------------------------------------------------------------------

    As unestablished, research software, this program is provided free of 
    charge on an "as is" basis without warranty of any kind, either 
    express or implied.  Acceptance and use of this program constitutes 
    the user's understanding that (s)he will have no recourse for any 
    actual or consequential damages, including, but not limited to, 
    lost profits or savings, arising out of the use of or inability to 
    use this program.  

 ------------------------------------------------------------------------
 USER AGREEMENT ---------------------------------------------------------
 ------------------------------------------------------------------------

     BY ACCEPTANCE AND USE OF THIS EXPERIMENTAL PROGRAM
     THE USER AGREES TO THE FOLLOWING:

     a.  This program is provided free of charge for the user's personal, 
	 non-commercial, experimental use.

     b.  All title, ownership and rights to this program and any copies 
         remain with the copyright holder, irrespective of the ownership 
	 of the media on which the program resides.

     c.  The user is permitted to create derivative works to this program.  
         However, all copies of the program and its derivative works must
         contain the CORAL copyright notice, the UNESTABLISHED SOFTWARE 
         DISCLAIMER and this USER AGREEMENT.

     d.  The user understands and agrees that this program and any 
         derivative works are to be used solely for experimental purposes 
	 and are not to be sold or commercially exploited in any manner 
	 WITHOUT EXPRESS WRITTEN PERMISSION.

     e.  We request that the user supply us with a copy of any changes, 
         enhancements, or derivative works which the user may create,
	 with the user's permission to redistribute it.
	 Copies of such material should be sent to:  CORAL@CS.WISC.EDU

-------------------------------------------------------------------------
*************************************************************************/

/***********************************************************************
	CORAL Software :: U.W.Madison

	scanner.h : Header file for the scanner

	NOTE: The scanner used is Flex.
 ***********************************************************************/

#ifndef CORAL_SCANNER_H
#define CORAL_SCANNER_H

#include "config.h"
#include <stdio.h>
#include "globals.h"
#include "parser.h"


struct Symbol;
struct sip;
struct sips;
struct Literal;
struct Arg;
struct RuleAnnoList;
struct RuleAnno;
struct RuleAnnoCase;
struct RuleAnnoCaseName;
struct RuleAnnoCaseDetails;

typedef union {
    struct Literal *	pred;
    struct Arg *	arg;
    struct sip *	sip;
    struct sips *	sips;
    struct Symbol *     name;
    struct AliasList*	alias_list;
    struct RuleAnno *	rule_anno;
    struct RuleAnnoCase* anno_case;
    struct RuleAnnoCaseName *anno_case_name;
    struct RuleAnnoCaseDetails* anno_case_details;
    int                 integer;

} C_arbtype;
// For Flex compatibility 
#define YYSTYPE C_arbtype

EXTERN struct Symbol *EnterSymbol ARGS((const char *));

#endif /* !CORAL_SCANNER_H */
