/************************************************************************
 ========================================================================
 CORAL 
 (c)  Copyright R. Ramakrishnan and The CORAL Group, 
 University of Wisconsin at Madison.
 (1992) All Rights Reserved.
 Version 0.1
 ========================================================================



 ------------------------------------------------------------------------
 CORAL Version 0.1
 RESEARCH SOFTWARE DISCLAIMER -------------------------------------------
 ------------------------------------------------------------------------

    As unestablished, research software, this program is provided free of 
    charge on an "as is" basis without warranty of any kind, either 
    express or implied.  Acceptance and use of this program constitutes 
    the user's understanding that (s)he will have no recourse for any 
    actual or consequential damages, including, but not limited to, 
    lost profits or savings, arising out of the use of or inability to 
    use this program.  

 ------------------------------------------------------------------------
 USER AGREEMENT ---------------------------------------------------------
 ------------------------------------------------------------------------

     BY ACCEPTANCE AND USE OF THIS EXPERIMENTAL PROGRAM
     THE USER AGREES TO THE FOLLOWING:

     a.  This program is provided free of charge for the user's personal, 
	 non-commercial, experimental use.

     b.  All title, ownership and rights to this program and any copies 
         remain with the copyright holder, irrespective of the ownership 
	 of the media on which the program resides.

     c.  The user is permitted to create derivative works to this program.  
         However, all copies of the program and its derivative works must
         contain the CORAL copyright notice, the UNESTABLISHED SOFTWARE 
         DISCLAIMER and this USER AGREEMENT.

     d.  The user understands and agrees that this program and any 
         derivative works are to be used solely for experimental purposes 
	 and are not to be sold or commercially exploited in any manner 
	 WITHOUT EXPRESS WRITTEN PERMISSION.

     e.  We request that the user supply us with a copy of any changes, 
         enhancements, or derivative works which the user may create,
	 with the user's permission to redistribute it.
	 Copies of such material should be sent to:  CORAL@CS.WISC.EDU

-------------------------------------------------------------------------
*************************************************************************/

#ifndef PERSISTENT_INDEX_H
#define PERSISTENT_INDEX_H
#include "generic-sm.h"
#include "generic-index.h"

#define Scanning_Persistent 1

#define COR_PERS_INDEX 2

class PersistentRel;

class PersistentIndexSet : public GenericIndexSet{	
public:
    PersistentIndexSet( PersistentRel *reln ) : 
      GenericIndexSet((StorageRelation *)reln) {};

    /* This fn. finds the index that best "matches" the given 
       argument set in the iterator. */ 
    virtual GenericIndex *find_index( TupleIterator& iterator) {
      return find_index(iterator.arg_list,iterator.bindenv,iterator.indexnump);
    };
    virtual GenericIndex *find_index( Tuple* tuple, int *tryindexp= NULL ) {
      return find_index(*(tuple->_args), tuple->bindenv, tryindexp);
    };
    virtual GenericIndex *find_index( ArgList&, BindEnv*, int *tryindexp=NULL);

    virtual int insert_index( GenericIndex* index );
    /* This fn. adds an index to the set of known indices. */
    virtual void fill_index(GenericIndex* Index);
    /* This fn. fills in the index using default index in posn. 0 */
};


class PersistentIndex : public GenericIndex {
 friend PersistentIndexSet;
 protected:
  inline PersistentRel *p_rel() { return (PersistentRel *)relation; }
 public:
  int chosen_index;

  PersistentIndex(PersistentRel* , BitVector *);

  virtual void initialize_iterator( TupleIterator& ) {};
  virtual Tuple *get_next_tuple(TupleIterator& ) ;
  virtual BindEnv *get_next( TupleIterator& ) ;
  virtual int index_type() {return COR_PERS_INDEX;};
  virtual int is_subsumed(Tuple *tuple) {return 0;};
  
  virtual void insert_tuple( Tuple *tuple ) {} ;
  virtual void free_all_entries() {} ;
  virtual void move_all_entries(GenericIndex *ind) {};
  virtual void reset_index() {} ;
};

#endif 
