/************************************************************************
 ========================================================================
 CORAL 
 (c)  Copyright R. Ramakrishnan and The CORAL Group, 
 University of Wisconsin at Madison.
 (1992) All Rights Reserved.
 Version 0.1
 ========================================================================



 ------------------------------------------------------------------------
 CORAL Version 0.1
 RESEARCH SOFTWARE DISCLAIMER -------------------------------------------
 ------------------------------------------------------------------------

    As unestablished, research software, this program is provided free of 
    charge on an "as is" basis without warranty of any kind, either 
    express or implied.  Acceptance and use of this program constitutes 
    the user's understanding that (s)he will have no recourse for any 
    actual or consequential damages, including, but not limited to, 
    lost profits or savings, arising out of the use of or inability to 
    use this program.  

 ------------------------------------------------------------------------
 USER AGREEMENT ---------------------------------------------------------
 ------------------------------------------------------------------------

     BY ACCEPTANCE AND USE OF THIS EXPERIMENTAL PROGRAM
     THE USER AGREES TO THE FOLLOWING:

     a.  This program is provided free of charge for the user's personal, 
	 non-commercial, experimental use.

     b.  All title, ownership and rights to this program and any copies 
         remain with the copyright holder, irrespective of the ownership 
	 of the media on which the program resides.

     c.  The user is permitted to create derivative works to this program.  
         However, all copies of the program and its derivative works must
         contain the CORAL copyright notice, the UNESTABLISHED SOFTWARE 
         DISCLAIMER and this USER AGREEMENT.

     d.  The user understands and agrees that this program and any 
         derivative works are to be used solely for experimental purposes 
	 and are not to be sold or commercially exploited in any manner 
	 WITHOUT EXPRESS WRITTEN PERMISSION.

     e.  We request that the user supply us with a copy of any changes, 
         enhancements, or derivative works which the user may create,
	 with the user's permission to redistribute it.
	 Copies of such material should be sent to:  CORAL@CS.WISC.EDU

-------------------------------------------------------------------------
*************************************************************************/

/***********************************************************************
	CORAL Software :: U.W.Madison

	parse-utils.h : Header file

	Declarations for the various structures used during parsing
	to process the input, and generate an internal representation.

	Contains the following class/type  declarations	 :
	  struct arg_link
	  struct arg_chain
          struct set_stack      -- for parsing nested sets.
	  
 ***********************************************************************/

#ifndef PARSE_UTILS_H
#define PARSE_UTILS_H

#include <stdio.h>
#include "externs.h"

// Type definitions for parser

extern class ParserStruct;

struct arg_link {
  struct arg_link *prev ;
  Arg *arg ;
} ;
struct arg_chain {
  struct arg_link *last ;
  int count ;
  struct arg_chain *pushed ;
} ;

struct parameter_link {
  struct parameter_link *prev ;
  Arg **parameter_slot ;
} ;
struct parameter_chain {
  struct parameter_link *last;
  int count;

  parameter_chain() { last = NULL; count = 0; }
} ;

struct set_stack {
  struct set_stack *prev;
  ArgPtr info;
};

typedef struct set_stack set_stack;


// Extern variables

extern const Symbol ** builtin_ops[] ;
extern int Builtin_Arith_Start;
extern int Builtin_Convertible_Start;
extern int C_linenum ;
extern int back_slash_quotes ;
extern int interactive_answer_mode;


// List of functions defined in parse-utils.C for the parser to use

extern int check_builtin_op(Name name) ;

extern void push_arg_chain(ParserStruct& parserStruct);
extern void append_arg(ParserStruct& parserStruct, Arg *a);
extern void append_parameter(ParserStruct& parserStruct, Arg **a);
extern void pop_arg_chain(ParserStruct& parserStruct, ArgList& args);

extern void push_cur_set(ParserStruct& parserStruct, ArgPtr set);
extern void pop_cur_set(ParserStruct& parserStruct);
extern void insert_cur_set(ParserStruct& parserStruct, ArgPtr element);

extern ArgPtr create_list(ParserStruct& parserStruct, ArgPtr cdr);
extern ArgPtr create_functor(ParserStruct& parserStruct, Name op);
extern ArgPtr create_grouping(ParserStruct& parserStruct);
extern ArgPtr create_multi_grouping(ParserStruct& parserStruct);
extern ArgPtr create_nested_multiset();

extern void reorder_arith_preds(ParserStruct& parserStruct) ;
extern ArgPtr pull_out_arith_expr(ParserStruct&);
extern void simple_reorder_arith_preds(ParserStruct& parserStruct) ;

extern int rule_var_enter(ParserStruct& parserStruct, Name s);
extern rule_var_lookup(ParserStruct& parserStruct, Name s);
extern int sip_var_lookup(ParserStruct& parserStruct, Name s);

extern void AddExportInfo(ParserStruct& parserStruct, FuncArg *arg);
extern void complete_rule(Clause *cur_rule, ParserStruct& parserStruct);

extern void COR_set_save_module(ModuleInfo&, int val);
extern void COR_set_supplementary_magic(ModuleInfo&, int val);
extern void COR_set_ordinary_magic(ModuleInfo&, int val);
extern void COR_set_no_magic(ModuleInfo&);
extern void COR_set_sup_magic_indexing(ModuleInfo&, int val);
extern void COR_set_predicate_seminaive(ModuleInfo&, int val) ;
extern void COR_set_check_subsum(ModuleInfo&, int val);
extern void COR_set_multisets(ModuleInfo&, int val);
extern void COR_set_single_scc(ModuleInfo&, int val);
extern void COR_set_convert_functions(ModuleInfo&, int val);
extern void COR_set_exist_opt(ModuleInfo&, int val);
extern void COR_set_use_factoring(ModuleInfo&, int val);
extern void COR_set_use_factormagic(ModuleInfo&, int val);
extern void COR_set_use_ordsearch(ModuleInfo&, int val);
extern void COR_set_return_unify(ModuleInfo&, int val);
extern void COR_set_pipelining(ModuleInfo&, int val);
extern void COR_set_index_deltas(ModuleInfo&, int val);
extern void COR_set_eager_eval(ModuleInfo&, int val);
extern void COR_set_monotonic(ModuleInfo&, int val);
extern void COR_set_non_ground_facts(ModuleInfo&, int val);
extern void COR_set_rewriting(ModuleInfo&, int val);
extern void COR_set_preprocessing(ModuleInfo&, int val);
extern void COR_set_disk_resident(ModuleInfo&, int);

// Functions in parse-actions.C
extern void AppendFunction(ParserStruct&);
extern void DeleteFunction(ParserStruct&);
extern void AssignFunction(ParserStruct&);
extern void EndModuleFunction(ParserStruct&);
extern void QueryFunction(ParserStruct&);
extern void FactFunction(ParserStruct&);
extern void RuleFunction(ParserStruct&);


// Functions in annotations.C
extern void add_make_index_annotation(PredAnnotations *&, Symbol *pred, Symbol *adorn_string,
				      ArgList *al1, ArgList *al2);
extern void add_allowed_adornment(ParserStruct&, Name predname, ArgList *arg);
extern void add_multiset_annotation(ParserStruct&, Symbol *pred, ArgList *al1, int check_subsum);
extern void add_diskrel_annotation(ParserStruct&, Symbol *pred, Symbol *adorn_string,ArgList *al1);
extern void add_agg_sel_annotation(ParserStruct&, Symbol *pred, Symbol *adorn_string,
				   ArgList *al1, ArgList *al2, Arg *op_arg);
extern void add_index_delta_annotation(ParserStruct&, Symbol *pred, ArgList *al1);
extern void add_prioritize_annotation(ParserStruct&, Symbol *pred, Symbol *adorn_string, 
				      ArgList *al1, Arg *op_arg);



#endif /* !PARSE_UTILS_H */


