/************************************************************************
 ========================================================================
 CORAL 
 (c)  Copyright R. Ramakrishnan and The CORAL Group, 
 University of Wisconsin at Madison.
 (1992) All Rights Reserved.
 Version 0.1
 ========================================================================



 ------------------------------------------------------------------------
 CORAL Version 0.1
 RESEARCH SOFTWARE DISCLAIMER -------------------------------------------
 ------------------------------------------------------------------------

    As unestablished, research software, this program is provided free of 
    charge on an "as is" basis without warranty of any kind, either 
    express or implied.  Acceptance and use of this program constitutes 
    the user's understanding that (s)he will have no recourse for any 
    actual or consequential damages, including, but not limited to, 
    lost profits or savings, arising out of the use of or inability to 
    use this program.  

 ------------------------------------------------------------------------
 USER AGREEMENT ---------------------------------------------------------
 ------------------------------------------------------------------------

     BY ACCEPTANCE AND USE OF THIS EXPERIMENTAL PROGRAM
     THE USER AGREES TO THE FOLLOWING:

     a.  This program is provided free of charge for the user's personal, 
	 non-commercial, experimental use.

     b.  All title, ownership and rights to this program and any copies 
         remain with the copyright holder, irrespective of the ownership 
	 of the media on which the program resides.

     c.  The user is permitted to create derivative works to this program.  
         However, all copies of the program and its derivative works must
         contain the CORAL copyright notice, the UNESTABLISHED SOFTWARE 
         DISCLAIMER and this USER AGREEMENT.

     d.  The user understands and agrees that this program and any 
         derivative works are to be used solely for experimental purposes 
	 and are not to be sold or commercially exploited in any manner 
	 WITHOUT EXPRESS WRITTEN PERMISSION.

     e.  We request that the user supply us with a copy of any changes, 
         enhancements, or derivative works which the user may create,
	 with the user's permission to redistribute it.
	 Copies of such material should be sent to:  CORAL@CS.WISC.EDU

-------------------------------------------------------------------------
*************************************************************************/

/***********************************************************************
	CORAL Software :: U.W.Madison

	linked-rel.h : Header file

	Declarations that define a linked relation, which is
	a relation implemented as a linked list.

	Contains the following class/type  declarations	 :
	  TupleList
	  LinkedRelation

 ***********************************************************************/

#ifndef CORAL_LINKED_REL_H
#define CORAL_LINKED_REL_H

#include "generic-rel.h"
#include "hash-index.h"

class LinkedRelation : public StorageRelation {
  public:
    HashIndexSet index_set;
    LinkedRelation(int _arity, int _delta = -1);
    virtual RMark * getMark();

    virtual int insert_raw( Tuple *tuple );

    void initialize_iterator( TupleIterator& );
    virtual BindEnv *get_next(TupleIterator&);
    virtual Tuple *get_next_tuple(TupleIterator& it) ;
    virtual void release(TupleIterator& it) ;
    virtual int is_subsumed(Tuple *tuple, RMark *startmark= NULL,
					RMark *endmark= NULL);


    /******* Indexing related methods *********/
    virtual GenericIndexSet *get_index_set() { return &index_set ;}
    virtual GenericIndex *create_index_object(BitVector *bv)
      { return new HashIndex(this, bv, -1);}
    virtual GenericIndex *create_index_object(ArgList *pat, int n_var,
					      ArgList *v_nm)
      { return new HashIndex(this, pat, n_var, v_nm); }



    void free_linked_tuples();



    virtual void free_all() { TupleList::free_all(); }
    virtual void print_name(FILE *outf);
    virtual void empty_relation(int deleteTuples=0);
			// See generic-rel.h for semantics of this fn
    virtual ~LinkedRelation() { free_all(); count = 0; }
};



#endif /* !CORAL_LINKED_REL_H */
