/************************************************************************
 ========================================================================
 CORAL 
 (c)  Copyright R. Ramakrishnan and The CORAL Group, 
 University of Wisconsin at Madison.
 (1992) All Rights Reserved.
 Version 0.1
 ========================================================================



 ------------------------------------------------------------------------
 CORAL Version 0.1
 RESEARCH SOFTWARE DISCLAIMER -------------------------------------------
 ------------------------------------------------------------------------

    As unestablished, research software, this program is provided free of 
    charge on an "as is" basis without warranty of any kind, either 
    express or implied.  Acceptance and use of this program constitutes 
    the user's understanding that (s)he will have no recourse for any 
    actual or consequential damages, including, but not limited to, 
    lost profits or savings, arising out of the use of or inability to 
    use this program.  

 ------------------------------------------------------------------------
 USER AGREEMENT ---------------------------------------------------------
 ------------------------------------------------------------------------

     BY ACCEPTANCE AND USE OF THIS EXPERIMENTAL PROGRAM
     THE USER AGREES TO THE FOLLOWING:

     a.  This program is provided free of charge for the user's personal, 
	 non-commercial, experimental use.

     b.  All title, ownership and rights to this program and any copies 
         remain with the copyright holder, irrespective of the ownership 
	 of the media on which the program resides.

     c.  The user is permitted to create derivative works to this program.  
         However, all copies of the program and its derivative works must
         contain the CORAL copyright notice, the UNESTABLISHED SOFTWARE 
         DISCLAIMER and this USER AGREEMENT.

     d.  The user understands and agrees that this program and any 
         derivative works are to be used solely for experimental purposes 
	 and are not to be sold or commercially exploited in any manner 
	 WITHOUT EXPRESS WRITTEN PERMISSION.

     e.  We request that the user supply us with a copy of any changes, 
         enhancements, or derivative works which the user may create,
	 with the user's permission to redistribute it.
	 Copies of such material should be sent to:  CORAL@CS.WISC.EDU

-------------------------------------------------------------------------
*************************************************************************/

/***********************************************************************
	CORAL Software :: U.W.Madison

	hash-index.h : Header file

	Declarations for implementing a hash index.

	Contains the following class/type  declarations	 :
	  HashNode
	  HashIndex
	  HashIndexSet

 ***********************************************************************/

#ifndef CORAL_HASH_INDEX_H
#define CORAL_HASH_INDEX_H

#include "generic-index.h"

#define UnmatchedHashValue ((HashVal) -3)

extern class HashSimpleRelation;
class HashNode ;
class HashIndex;
typedef HashNode *HashNodePtr;
typedef HashIndex *HashIndexPtr;

/*
 * We separate the index from the relation that is being indexed.
 * class HashNode and class HashIndex form the index part;
 * class HashSimpleRelation in hash-rel.h reflects this separation.
 */

class HashNode {
    friend class HashIndex;
    friend class HashIndexSet;

protected:
    HashVal hash_val;
    HashNode *next;
    Tuple *value;
    HashNode(HashVal hash, Tuple*val) {
      hash_val = hash; 
      value = val; 
      next = NULL;      
     }
public:
    inline Tuple *tuple() { return value;}
};

//GArrayDeclare(HashNodePtr)

class HashIndex : public GenericIndex {
friend class HashIndexSet;

protected:
    int hash_size;   // number of buckets in the hash index
    int limit;	     // Grow hash table if there are more than this many tuples
    double incr_ratio, max_occupancy;

    // The following is to be used when linear hashing is introduced.
    // int rehash-point;  // Tuples in buckets with numbers less than this 
			  //  have been rehashed.
    int hash_count;  // number of Tuples in hash_table, but not in var_chain

    HashNodePtr *hash_table;
//  GArray(HashNodePtr) hash_table;
    HashNodePtr var_chain; // tuples whose hash value is VarHashValue
 
    // HashNodePtr unmatched;  tuple which do not match pattern

    /* The next two fields implement a scheme of linking the non-empty
       buckets of the relation into a list, so that empty buckets are
       never considered during a file scan. */

    int        *non_empty_buckets; // array of same size as hash table.
                                   // a non-negative entry is the index
                                   // of the next non-empty bucket
    int         non_empty_bucket_head; // index of first non-empty bucket


    int       **prev_bucket_ptrs;  // array of pointers to previous
                                   // entry in non-empty bucket link
                                   //
public: 

    HashIndex( StorageRelation* rel, BitVector* aset,
	      int buckets = -1,
	      double incr_ratio1 = -1.0, double max_occupancy1 = -1.0);
    HashIndex( StorageRelation* rel, ArgList* pat, int n_var, 
	      ArgList* v_nm, int buckets = -1,
	      double incr_ratio1 = -1.0, double max_occupancy1 = -1.0);

    void initialize_iterator( TupleIterator& );

    Tuple *get_next_tuple( TupleIterator& it) ;

    BindEnv *get_next( TupleIterator& );

    HashVal hash( ArgList *args, BindEnv *bindenv );
    void insert_tuple( Tuple *tuple );
    virtual int is_subsumed(Tuple *tuple);

    virtual int index_type() {return COR_HASH_INDEX;}
    void insert_entry(HashNodePtr entry);
    void rehash_bigger();
    void free_all_entries();
    void move_all_entries(GenericIndex *ind);
    void delete_all_tuples();
    void reset_index();	
    // See generic-index.h for semantics.

    virtual ~HashIndex();
    
};

extern class Context;

class HashIndexSet : public GenericIndexSet {
protected:
    int find_exact( HashIndex *index);

public: 
    HashIndexSet( StorageRelation* rel) : GenericIndexSet(rel) {}

    virtual GenericIndex *find_index( TupleIterator& iterator) {
      return find_index(iterator.arg_list, iterator.bindenv, iterator.indexnump);
     }
    virtual GenericIndex *find_index( Tuple* tuple, int *tryindexp = NULL) {
      return find_index(*(tuple->_args), tuple->bindenv, tryindexp);
     }
    virtual GenericIndex *find_index( ArgList&, BindEnv*, 
			int *tryindexp = NULL);
    int insert_index( GenericIndex * );
    void fill_index(GenericIndex*);
    virtual int add_all_tuples(StorageRelation *reln, int marks_into_account = 0,
			       int check_dupl = 0, int hide_em = 0);
    virtual int add_all_goals(StorageRelation *_reln, Context *_context,
						StorageRelation *owner_rel);
    int move_all_entries(StorageRelation *reln);
};

#endif /* !CORAL_HASH_INDEX_H */
