/************************************************************************
 ========================================================================
 CORAL 
 (c)  Copyright R. Ramakrishnan and The CORAL Group, 
 University of Wisconsin at Madison.
 (1992) All Rights Reserved.
 Version 0.1
 ========================================================================



 ------------------------------------------------------------------------
 CORAL Version 0.1
 RESEARCH SOFTWARE DISCLAIMER -------------------------------------------
 ------------------------------------------------------------------------

    As unestablished, research software, this program is provided free of 
    charge on an "as is" basis without warranty of any kind, either 
    express or implied.  Acceptance and use of this program constitutes 
    the user's understanding that (s)he will have no recourse for any 
    actual or consequential damages, including, but not limited to, 
    lost profits or savings, arising out of the use of or inability to 
    use this program.  

 ------------------------------------------------------------------------
 USER AGREEMENT ---------------------------------------------------------
 ------------------------------------------------------------------------

     BY ACCEPTANCE AND USE OF THIS EXPERIMENTAL PROGRAM
     THE USER AGREES TO THE FOLLOWING:

     a.  This program is provided free of charge for the user's personal, 
	 non-commercial, experimental use.

     b.  All title, ownership and rights to this program and any copies 
         remain with the copyright holder, irrespective of the ownership 
	 of the media on which the program resides.

     c.  The user is permitted to create derivative works to this program.  
         However, all copies of the program and its derivative works must
         contain the CORAL copyright notice, the UNESTABLISHED SOFTWARE 
         DISCLAIMER and this USER AGREEMENT.

     d.  The user understands and agrees that this program and any 
         derivative works are to be used solely for experimental purposes 
	 and are not to be sold or commercially exploited in any manner 
	 WITHOUT EXPRESS WRITTEN PERMISSION.

     e.  We request that the user supply us with a copy of any changes, 
         enhancements, or derivative works which the user may create,
	 with the user's permission to redistribute it.
	 Copies of such material should be sent to:  CORAL@CS.WISC.EDU

-------------------------------------------------------------------------
*************************************************************************/

/***********************************************************************
	CORAL Software :: U.W.Madison

	globals.h : Header file

	Declarations for manipulating global structures

	Contains the following class/type  declarations	 :
	  ModuleInfo
	  DatabaseStruct
	  ParserStruct

	Some method definitions are in util.C

 ***********************************************************************/
#ifndef CORAL_GLOBAL_H
#define CORAL_GLOBAL_H

#include "externs.h"
#include "annotations.h"
#include "rules.h"
#include "strings.h"
#include "parse-utils.h"
#include "profile.h"

class ModuleInfo ;
class DatabaseStruct ;
class ExecutionEnv ;
class ParserEnv;
class ParserStruct ;
class SemiNaive;
class Table;
class TableStack;
class RuleInfoArray;

extern struct SymbolTable *DatabaseTable ;
extern DatabaseStruct *CurDB ;
extern ParserStruct parserStruct ;
extern ExecutionEnv exEnv ;
extern ParserEnv parseEnv;
extern struct SymbolTable *BuiltinRelTable ;
extern TableStack T_Stack;


// The execution environment contains all the globals that represent
// the state of CORAL execution. This includes default values, as
// well as debugging and profiling flags. It should probably also
// contain the Trail, and the StorageManager. The constructor should
// create a StackMark, so that if for some reason (like a signal)
// CORAL needs to be restarted, it can be done by popping the
// StackMark ---- PRAVEEN

typedef enum { COR_DOING_MAGIC,
	       COR_DOING_INTERPRET,
	       COR_DOING_COMPILE,
	       COR_DOING_FACTOR,
	       COR_DOING_FACTOR_MAGIC,
	       COR_DOING_EXIST,
	       COR_DOING_IMPERATIVE,
	       } ExecutionMode ;

typedef enum {
	COR_LIST_RELATION,
	COR_HASH_RELATION,
	} RelationTypeDefault;

#define COR_BINDING_ANSWER_PRINT 0
#define COR_TUPLE_ANSWER_PRINT   1
#define COR_EMPTY_ANSWER_PRINT   2

class ExecutionEnv {
  public :
  ExecutionMode C_exec_mode;
  RelationOptions GlobalRelationOptions;
  char *coral_path;
  int SM_initialized;

  /* used to keep the bindenv stack consistent in event of failures */
  StackMark *stackmark;

  int C_insert_mode_default;
  int C_quiet_mode_default;
  int C_answer_style_default;
  int C_read_coralrc_default;
  int C_create_magic_default;
  int C_verbose_answer_default;
  int C_print_prompt_default;
  int C_do_history_default;

  int C_rewriting_default;
  int C_use_supplementary_magic_default ;
  int C_use_magic_default ;
  int C_use_factor_magic_default;
  int C_use_exist_opt_default;
  int C_use_factoring_default;
  int C_sup_magic_indexing_default;

  int C_use_pipelining_default;
  int C_save_module_default;
  int C_use_ordsearch_default;
  int C_use_eager_eval_default;
  int C_use_monotonic_default;
  int C_interactive_mode_default;
  int C_interactive_mode_current;
  int C_use_predicate_sn_default;
  int C_check_subsum_default;
  int C_multisets_default;
  int C_index_deltas_default;
  int C_use_return_unify_default;
  int C_non_ground_facts_default;
  int C_diskrel_default;
  int C_eager_indexing_default;
  int C_sip_reorder_default;

  int C_preprocessing_default;
  int C_single_scc_default;
  int C_convert_functions_default;
  int C_single_answer_default;

  /* variables used for debugging */
  int dbg_unify ;
  int dbg_subsumes;
  int dbg_indexing;
  int dbg_aggregates;
  int dbg_get_next;
  int dbg_sets;
  int dbg_ordsearch;
  int dbg_return_unify;
  int dbg_pipelining;
  int dbg_backtrack;
  int dbg_deletes;
  int dbg_modules;

  int C_hash_buckets_default;  
  int C_delta_buckets_default;
  double C_incr_ratio_default;
  double C_max_occupancy_default;
  int C_max_recursion_depth_default;
  RelationTypeDefault C_relation_type_default;
  int C_connect_exodus_default;

  /* variables used for profiling */
  int profile_sn;
  int profile_scc;
  int profile_module;
  FILE * trace_file;
  FILE * print_file;
  FILE * profile_file;
  FILE * error_file;
  char *trace_filename;
  char *print_filename;
  char *profile_filename;
  char *error_filename;

  int C_interrupt_raised;
  
  void init();
  void display(FILE *outf) ;
  ExecutionEnv() { init() ;} ;
  void setMode(ExecutionMode ex_mode) { C_exec_mode = ex_mode ; }
  void flush_all_outputs();
};

class ModuleInfo {
  public :

  Name name;			/* Name of the module. */
  ExportInfo *ExportedPreds;	/* List of exported queries (preds with
				   adornments) */
 /** Tarun  **/
  FILE *file_desc;              /*  File descriptor to dump file - 
				    for visualization */

  ProfileInfo GlobalProfileInfo; /* profile info for module */

  int ExportedCount;		/* Length of above list */

  int PreProcessing;            /* perform preprocessing on this module */
  int SingleScc;                /* lump all rules into a single scc */
  int ConvertFunctions;         /* convert arithemetic functions */
  int SingleAnswer;             /* the exported relation has a single answer
                                   per binding **/

  int Rewriting;                /* perform rewriting on this module */
  int SaveModule;		/* Save facts on exiting call to 
				   module if this is set */
  int UseSupplementaryMagic;
  // This is probably redundant .. UseMagic, because of UseFactoring
  int UseMagic;			/* Do magic transformation if set */
  int UseExistOpt ;             /* Do existential query optimization */
  int UseFactoring ;            /* Do factoring if set*/
  int UseFactorMagic ;          /* Do factoring with a magic predicate
				   guarding every rule */
  int SupMagicIndexing;		/* Use supplementary magic indexing */
  int UsePredicateSN;           /* Use predicate seminaive evaluation*/
  int CheckSubsum;		/* Subsumption checking status */
  int MultiSet ;                /* MultiSet semantics */
  int IndexDeltas;		/* Index the deltas of all relations */
  int UseReturnUnify;           /* Use special opts for return 
				   unification */
  int UsePipelining;		/* Use pipelined evaluation mode */
  int UseOrdSearch;             /* Use ordered search */
  int EagerEval;        	/* Don't use eager evaluation */
  int Monotonic;        	/* Don't use done_m_ literals if set */
  int NonGroundFacts;           /* Non-ground facts are present */
  int HasPrioritize;            /* There is a predicate with priority anno.*/
  int DiskRel;                  /* All derived relations are disk-resident */


  void init_flags() {
    PreProcessing = exEnv.C_preprocessing_default;
    Rewriting = exEnv.C_rewriting_default;
    UseSupplementaryMagic = exEnv.C_use_supplementary_magic_default ;
    UseMagic = exEnv.C_use_magic_default;
    SupMagicIndexing = exEnv.C_sup_magic_indexing_default;
    CheckSubsum  = exEnv.C_check_subsum_default;
    MultiSet = exEnv.C_multisets_default;
    IndexDeltas  = exEnv.C_index_deltas_default;
    UseFactorMagic = exEnv.C_use_factor_magic_default;
    UseReturnUnify = exEnv.C_use_return_unify_default;
    UsePipelining = exEnv.C_use_pipelining_default;
    UseOrdSearch = exEnv.C_use_ordsearch_default;
    HasPrioritize = 0;
    EagerEval = exEnv.C_use_eager_eval_default;
    Monotonic = exEnv.C_use_monotonic_default;
    UseExistOpt = exEnv.C_use_exist_opt_default;
    UseFactoring = exEnv.C_use_factoring_default;
    UsePredicateSN = exEnv.C_use_predicate_sn_default;
    SaveModule = exEnv.C_save_module_default;
    NonGroundFacts = exEnv.C_non_ground_facts_default;
    DiskRel = exEnv.C_diskrel_default;

    SingleScc = exEnv.C_single_scc_default;
    SingleAnswer = exEnv.C_single_answer_default;
    ConvertFunctions  = exEnv.C_convert_functions_default;
  }
  void init() {
    name = NULL ;
    ExportedPreds = NULL ;
    ExportedCount = 0 ;
    init_flags() ;
  };

  ModuleInfo() { init() ;} ;
};

typedef void (* ExecFunction) (ParserStruct&);

class ParserStruct {
  public :
  ExecFunction func;
  int func_setup;
  Clause *cur_rule;

  SemiNaive *snrule;
  Table *table;
  RuleInfoArray *rInfo_arr;

  ModuleInfo CurModule;
  int nested_index;

  // The type 'arg_link' is used to temporarily chain together the
  // arguments of a functor or predicate.
  // The variable 'cur_arg_chain' contains a list of the arguments of
  // the functor or predicate that we're currently scanning.
  // Surrounding functors or predicates are pushed using the 'pushed' link.

  struct parameter_chain *parameters;
  struct arg_chain *cur_arg_chain ;
  set_stack *cur_set;
  struct array rule_var_names ;
  struct array sip_var_names ;
  struct array rhspreds ;
  struct rule *rule_list;
  struct collection rules[1];
  struct Predicate *Predicates;
  struct SymbolTable *PredicateTable;
  Predicate *AllPredicates;
  PredAnnotations *make_index_annotations;
  PredAnnotations *agg_sel_annotations;
  PredAnnotations *prioritize_annotations;
  PredAnnotations *diskrel_annotations;
  PredAnnotations *AllowedAdornList;
  PredAnnotations *DisallowedAdornList;

  // WARNING: In case of conflicts between AllowedAdornList and 
  //	      DisallowedAdornList, the DisallowedAdornList is
  //	      given priority, and the AllowedAdornList is over-ridden.

  PredAnnotations *MultisetAnnotations;
  int lhs_flag;

  void init();

  void assign_func(ExecFunction exec_func) {
    func_setup = 1;
    func = exec_func;
  }

  void execute() { if (func_setup) (*func)(*this); }

  // to be called by the parser at the end of each input parserStruct to release unnecessary memory
  void reset(int flag = 0);

  ParserStruct() {
    init() ;
    parameters = new parameter_chain;
  };

};


class DatabaseStruct {
  public :

  Name name;
  struct SymbolTable * RelationTable;

  void init() {
    RelationTable = NULL ;
  }
  DatabaseStruct(Name name) {
    this->name = name ;
    init();
  }
  ~DatabaseStruct();
};

#endif /* !CORAL_GLOBAL_H */
