/************************************************************************
 ========================================================================
 CORAL 
 (c)  Copyright R. Ramakrishnan and The CORAL Group, 
 University of Wisconsin at Madison.
 (1992) All Rights Reserved.
 Version 0.1
 ========================================================================



 ------------------------------------------------------------------------
 CORAL Version 0.1
 RESEARCH SOFTWARE DISCLAIMER -------------------------------------------
 ------------------------------------------------------------------------

    As unestablished, research software, this program is provided free of 
    charge on an "as is" basis without warranty of any kind, either 
    express or implied.  Acceptance and use of this program constitutes 
    the user's understanding that (s)he will have no recourse for any 
    actual or consequential damages, including, but not limited to, 
    lost profits or savings, arising out of the use of or inability to 
    use this program.  

 ------------------------------------------------------------------------
 USER AGREEMENT ---------------------------------------------------------
 ------------------------------------------------------------------------

     BY ACCEPTANCE AND USE OF THIS EXPERIMENTAL PROGRAM
     THE USER AGREES TO THE FOLLOWING:

     a.  This program is provided free of charge for the user's personal, 
	 non-commercial, experimental use.

     b.  All title, ownership and rights to this program and any copies 
         remain with the copyright holder, irrespective of the ownership 
	 of the media on which the program resides.

     c.  The user is permitted to create derivative works to this program.  
         However, all copies of the program and its derivative works must
         contain the CORAL copyright notice, the UNESTABLISHED SOFTWARE 
         DISCLAIMER and this USER AGREEMENT.

     d.  The user understands and agrees that this program and any 
         derivative works are to be used solely for experimental purposes 
	 and are not to be sold or commercially exploited in any manner 
	 WITHOUT EXPRESS WRITTEN PERMISSION.

     e.  We request that the user supply us with a copy of any changes, 
         enhancements, or derivative works which the user may create,
	 with the user's permission to redistribute it.
	 Copies of such material should be sent to:  CORAL@CS.WISC.EDU

-------------------------------------------------------------------------
*************************************************************************/

/***********************************************************************
	CORAL Software :: U.W.Madison

	gennum.h : Header file

	A set of C++ classes for generic (mixed-type) arithmetic.
	Copyright Per Bothner, 1990.
	This is a preliminary version; please do not re-distribute
	without my permission.

 ***********************************************************************/


#ifndef CORAL_GENNUM_H
#define CORAL_GENNUM_H

#include "config.h"
/*
#include <alloca.h>
*/
#include <stdlib.h>
#ifndef UNIX_SPARC
#include <malloc.h>
#endif
#ifndef __GNUC__
#include <malloc.h>
#endif
#include "arg.h"

#define INLINE inline

extern "C" {
#include "../bignum/h/BigNum.h"
}

#ifdef DIGITon16BITS
typedef short                 BigSignedDigit;
#define BN_DIGIT_LOG 4
#else
typedef  int                  BigSignedDigit;
#define BN_DIGIT_LOG 5
#endif

typedef BigSignedDigit fix_int;
typedef BigNumDigit fix_unsigned;

class Double; class Integer; class SmallInt; class FixInt;
class Fraction; class Real; class Rational; class Complex; class CFile;

/********** Numeric Hierarchy *************

      
class Numeric : public Root 
    class NotANumber : public Numeric 
    class Complex : public Numeric // Virtual
	class ComplexPair : public Complex 
 	class Real : public Complex // Virtual
	    class Double : public Real , public _double 
	    class Rational : public Real 
		class Integer : public Rational 
		    class SmallInteger : public Integer 
		class FixInt : public Integer
		    class SmallInt : public FixInt 
					// The above are statically allocated
	    class Fraction : public Rational 
		class RationalInfinity :  public Fraction 
*******************************************/


class String;
class BindEnv;

#ifndef DECLARE_MEMBERS
#define DECLARE_MEMBERS(name) public:
#endif
#ifndef DECLARE_MEMBERS_STATIC
#define DECLARE_MEMBERS_STATIC(name1, name2) public:
#endif

class Numeric : public Root 
{
    DECLARE_MEMBERS(Numeric)
 public:
#ifdef Q_ENV
    virtual long magic() const;
#endif
    virtual void printon(FILE *, char *) const;
    virtual void printon(FILE *) const;

    virtual const Numeric * numeric() const;

    virtual const Numeric& neg() const = 0;
    virtual int sign() const = 0;
    virtual const Numeric * addFixInt(fix_int) const;
    virtual const Numeric * subFixInt(fix_int) const;
    virtual const Numeric * mulFixInt(fix_int) const;
    virtual const Numeric * divFixInt(fix_int) const;
    virtual const Numeric * addInteger(const Integer&) const;
    virtual const Numeric * subInteger(const Integer&) const;
    virtual const Numeric * mulInteger(const Integer&) const;
    virtual const Numeric * divInteger(const Integer&) const;
    virtual const Numeric * addDouble(double) const;
    virtual const Numeric * subDouble(double) const;
    virtual const Numeric * mulDouble(double) const;
    virtual const Numeric * divDouble(double) const;
    virtual const Numeric * add(const Numeric&y) const {return y.addr(*this);}
    virtual const Numeric * sub(const Numeric&y) const {return y.subr(*this);}
    virtual const Numeric * mul(const Numeric&) const;
    virtual const Numeric * div(const Numeric&) const;
    virtual const Numeric * addr(const Numeric&) const { return NULL; };
    virtual const Numeric * subr(const Numeric&) const { return NULL; };
    virtual const Numeric * mulr(const Numeric&) const { return NULL; };
    virtual const Numeric * divr(const Numeric&) const { return NULL; };
    virtual const Numeric * ipower(fix_int) const;
    virtual int compareRational(const Rational& x) const;
    virtual int compareDouble(double) const;
    virtual int compareFixInt(fix_int) const;
    virtual int getlong(long *i) const;
    virtual const Complex * complex() const { return NULL; }
    virtual const Real * real() const { return NULL; }
    virtual const Integer * integer() const { return NULL; }
    virtual const Rational * rational() const { return NULL; }
	virtual const FixInt * fixint() const { return NULL; }

    virtual double as_double() const {return 0;}
};

class NotANumber : public Numeric {
  protected:
    int kind;
  public:
    NotANumber(int k) { kind = k;}
    virtual void printon(FILE *) const;
    virtual void printon(FILE *, char *) const;

    virtual const Numeric& neg() const;
    virtual int sign() const;
};

class Complex : public Numeric {
  public:
    virtual const Numeric& neg() const = 0;
    virtual int sign() const = 0;
    virtual const Real& realPart() const = 0;
    virtual const Real& imagPart() const = 0;
    virtual void printon(FILE *) const;
    virtual void printon(FILE *, char *) const;

    virtual const Complex * complex() const { return this; }
    virtual const Numeric * add(const Numeric&) const;
    virtual const Numeric * sub(const Numeric&) const;
    virtual const Numeric * mul(const Numeric&) const;
    virtual const Numeric * div(const Numeric&) const;
    virtual const Numeric * addr(const Numeric&) const;
    virtual const Numeric * subr(const Numeric&) const;
    virtual const Numeric * mulr(const Numeric&) const;
    virtual const Numeric * divr(const Numeric&) const;
    virtual const Numeric * addFixInt(fix_int) const;
    virtual const Numeric * subFixInt(fix_int) const;
    virtual const Numeric * mulFixInt(fix_int) const;
    virtual const Numeric * divFixInt(fix_int) const;
};

class ComplexPair : public Complex {
  public:
    const Real& re;
    const Real& im;
    ComplexPair(const Complex& val) : re(val.realPart()), im(val.imagPart()) {}
    ComplexPair(const Real& r, const Real& i) : re(r), im(i) { }
    virtual const Real& realPart() const;
    virtual const Real& imagPart() const { return im; }
    virtual const Numeric& neg() const;
    virtual int sign() const;
};

enum RealToIntMode { FloorMode, CeilingMode, TruncateMode, RoundMode };

class Real : public Complex {
    DECLARE_MEMBERS(Real)
  public:
    virtual const Real& realPart() const;
    virtual const Real& imagPart() const;
    virtual int sign() const = 0;
    virtual const Numeric& neg() const { return rneg(); }
    virtual const Real& rneg() const = 0;
    virtual const Integer& to_integer(enum RealToIntMode) const = 0;
    inline const Integer& floor() const { return to_integer(FloorMode); }
    virtual const Integer& div_floor(const Real& divisor) const;
    virtual const Real * real() const { return this; }
};

struct _double {
    DECLARE_MEMBERS_STATIC(_double, PrimitiveType)
    double val;
};

class Double : public Real , public _double {
    DECLARE_MEMBERS(Double)
 public:
    inline Double(double d) { val = d; }
    virtual void printon(FILE *) const;
	virtual void printon(FILE *, char *) const;
	virtual void sprint(char *str, int *pos, BindEnv *context = NULL) const;



#ifdef Q_ENV
    virtual void dumpPtr(CFile *cf) const;
#endif
#ifdef CORAL
    virtual numarg_kind num_kindof() const;
#endif

    virtual int compare(const Root&) const;
    virtual int compareDouble(double) const;
    virtual int compareFixInt(fix_int) const;
    virtual const Integer& to_integer(enum RealToIntMode) const;
    virtual const Real& rneg() const { return *new Double(-val); }
    virtual int sign() const { return val > 0 ? 1 : val < 0 ? -1 : 0; }
    virtual const Numeric* addFixInt(fix_int x) const
	{return new Double((double)x+val);}
    virtual const Numeric* subFixInt(fix_int x) const
	{return new Double((double)x-val);}
    virtual const Numeric* mulFixInt(fix_int x) const
	{return new Double((double)x*val);}
    virtual const Numeric* divFixInt(fix_int x) const
	{return new Double((double)x/val);}
    virtual const Numeric* addDouble(double x)const {return new Double(x+val);}
    virtual const Numeric* subDouble(double x)const {return new Double(x-val);}
    virtual const Numeric* mulDouble(double x)const {return new Double(x*val);}
    virtual const Numeric* divDouble(double x)const {return new Double(x/val);}
    virtual const Numeric * add(const Numeric& x) const {return x.addDouble(val);}
    virtual const Numeric * sub(const Numeric& x) const {return x.subDouble(val);}
    virtual const Numeric * mul(const Numeric& x) const {return x.mulDouble(val);}
    virtual HashVal hash(BindEnv *context = NULL);
    virtual const Numeric * div(const Numeric& x) const {return x.divDouble(val);}
};

class Rational : public Real {
    DECLARE_MEMBERS(Rational)
    virtual int sign() const = 0;
    virtual const Integer& to_integer(enum RealToIntMode) const = 0;
    virtual const Real& rneg() const = 0;
    virtual const Integer& numerator() const = 0;
    virtual const Integer& denominator() const = 0;
    virtual const Rational * rational() const;
    virtual const Numeric * add(const Numeric&) const;
    virtual const Numeric * addr(const Numeric&) const;
    virtual const Numeric * sub(const Numeric&) const;
    virtual const Numeric * subr(const Numeric&) const;
    virtual const Numeric * mul(const Numeric&) const;
    virtual const Numeric * mulr(const Numeric&) const;
    virtual const Numeric * div(const Numeric&) const;
    virtual const Numeric * divr(const Numeric&) const;
    virtual const Numeric * ipower(fix_int) const;
    friend int compare(const Rational& x, const Rational& y) ;
    virtual int compare(const Root& other) const;
    virtual int compareRational(const Rational& x) const;
    virtual int compareFixInt(fix_int) const;
};

const Rational *MakeRational(const Integer& num, const Integer& den);
const Rational *MakeRational(fix_int num, fix_int den);
extern int integer_length(fix_int);
extern int BigDigitsNeeded(fix_unsigned*, int);


class Integer : public Rational {
    DECLARE_MEMBERS(Integer)
 public:
    unsigned long len;
//  short sgn;
//  unsigned short extra; /* sz = len + extra */
    union {
	fix_unsigned s[1];
	fix_unsigned U[1];
	fix_int S[1];
	fix_int val;
    } ;
    int big_len() const { return len; }
    int is_fix() const { return len==1; }
    const fix_int& fix_value() const { return val; } // Only valid iff is_fix()
    int integer_length() const; // Implements Common Lisp's integer-length
    Integer() {}

    virtual const Integer& numerator() const;
    virtual const Integer& denominator() const;
#ifdef Q_ENV
    virtual long magic() const;
#endif
#ifdef CORAL
    virtual HashVal hash(BindEnv *context = NULL);
    virtual numarg_kind num_kindof() const;
#else
    virtual int hash() ;
#endif
//    virtual const Integer * gcd(const Integer&) const;
    virtual void do_delete();
    inline const Integer& operator>>(int count) { return *this << (-count); }
    virtual const Integer *gcd(const Integer&) const;
    virtual const Integer *gcdFixInt(fix_int) const;
    const Integer& boolean(const Integer& arg, int op) const;
    virtual const Integer& to_integer(enum RealToIntMode) const {return *this;}
    virtual const Integer* integer() const { return this; }

    friend int compare(const Integer& x, const Integer& y);
//    virtual int compare(const Root& other) const;
    virtual int compareRational(const Rational& x) const;
    virtual int compareFixInt(fix_int) const;

    virtual void printon(FILE *) const;
    virtual void printon(FILE *, char *) const; 
    virtual void sprint(char *str, int *pos, BindEnv *context = NULL) const;


    virtual double as_double() const;
    inline int odd() const { return U[0] & 1; }
    virtual const Real& rneg() const;
    virtual const Numeric * addFixInt(fix_int i) const;
    virtual const Numeric * subFixInt(fix_int) const;
    virtual const Numeric * mulFixInt(fix_int) const;

    virtual const Numeric * addInteger(const Integer&) const;
    virtual const Numeric * subInteger(const Integer&) const;
    virtual const Numeric * mulInteger(const Integer&) const;
    virtual const Numeric * divInteger(const Integer&) const;
/*
    virtual const Numeric * addDouble(double) const;
    virtual const Numeric * subDouble(double) const;
    virtual const Numeric * mulDouble(double) const;
    virtual const Numeric * divDouble(double) const;
*/
    virtual const Numeric * add(const Numeric& x) const;
    virtual const Numeric * sub(const Numeric& x) const;
    virtual const Numeric * mul(const Numeric& x) const;
    virtual const Numeric * div(const Numeric& x) const;

    inline int is_negative() const { return S[len-1] < 0; }
    inline int bsign() const;
    const Integer& operator-() const;
    virtual const Numeric * ipower(fix_int) const;
    virtual const Integer& operator<<(int count) const;
    virtual int sign() const;
    const Integer * simplify_Int();
};

extern void div(const Integer& X, const Integer& Y,
		enum RealToIntMode mode,
		const Integer** quotient, const Integer** remainder);
extern void div(const Real& X, const Real& Y,
		enum RealToIntMode mode,
		const Real** quotient, const Real** remainder);
extern const Integer& operator+(const Integer &x, const Integer& y);
extern const Integer& operator+(const Integer &X, fix_int Y);
extern const Integer& operator-(const Integer &x, const Integer& y);
extern const Integer& operator*(const Integer &x, const Integer& y);
extern const Integer& itimes(const Integer &x, const Integer& y);
inline const Integer& operator*(int x, const Integer& y)
{
    return *(Integer*)y.mulFixInt(x);
}

extern Integer* NewInteger(int len);
extern Integer* NewInteger(int len, fix_unsigned* data);

class SmallInteger : public Integer {
    // Integer created from a fix_int
 public:
    SmallInteger(fix_int i) { len = 1; U[0] = i; }
};

extern "C" const FixInt *MakeFixInt(long i);

struct _long {
    DECLARE_MEMBERS_STATIC(_long, PrimIntType)
    long val;
//    void coerceTo(Class *type, void *dest);
};

class FixInt : public Integer
{
    DECLARE_MEMBERS(FixInt)
 public:
#ifdef DIGITon16BITS
    static fix_int smallest() { return -0x8000; }
    static fix_int biggest() { return 0x7FFF; }
#else
    static fix_int smallest() { return -0x80000000; }
    static fix_int biggest() { return 0x7FFFFFFF; }
#endif
    FixInt() { len = 1; }
    FixInt(fix_int i) { len = 1; val = i; }
#ifdef Q_ENV
    virtual void dumpPtr(CFile *cf) const;
#endif
    fix_int ival() const { return val; }
    virtual const Real& rneg() const;
    virtual int sign() const { return val > 0 ? 1 : val < 0 ? -1 : 0; }

    virtual const Numeric * add(const Numeric& x) const {return x.addFixInt(val);}
    virtual const Numeric * sub(const Numeric& x) const {return x.subFixInt(val);}
    virtual const Numeric * mul(const Numeric& x) const {return x.mulFixInt(val);}
    virtual const Numeric * div(const Numeric& x) const {return x.divFixInt(val);}

    virtual const Numeric* addDouble(double x)const {return new Double(x+val);}
    virtual const Numeric* subDouble(double x)const {return new Double(x-val);}
    virtual const Numeric* mulDouble(double x)const {return new Double(x*val);}
    virtual const Numeric* divDouble(double x)const {return new Double(x/val);}

    virtual const Numeric* addInteger(const Integer& x)const {return &(x + *this); }
    virtual const Numeric* subInteger(const Integer& x)const {return &(x - *this); }
    virtual const Numeric* mulInteger(const Integer& x)const {return &(x * *this); }

	virtual const FixInt * fixint() const { return this; }

    virtual double as_double() const;
    virtual const Numeric * addFixInt(fix_int) const;
    virtual const Numeric * subFixInt(fix_int) const;
    virtual const Numeric * mulFixInt(fix_int) const;
    virtual const Numeric * divFixInt(fix_int arg) const;

//  friend const Integer& operator+(int x, const FixInt& y) ...;
//  virtual const Numeric& addFixInt(fix_int i) { return i+*this; }
//  friend const Integer& operator+(const Integer& x, const FixInt& y) ...;
//  virtual const Numeric& addInteger(const Integer&x) { return x+*this; }

    virtual int compare(const Root&) const;
    virtual int compareDouble(double) const;
    virtual int compareFixInt(fix_int) const;
    virtual const Integer& operator<<(int count) const;
    virtual const Integer *gcd(const Integer& arg) const
	{ return arg.gcdFixInt(fix_value()); }
    virtual const Integer *gcdFixInt(fix_int) const;
    virtual int getlong(long *i) const;
#ifdef Q_ENV
    virtual String *asString(int format=0) const;
#endif
};

#define LeastSmallInt (-128)
#define BiggestSmallInt 1001
#define CountSmallInt (BiggestSmallInt-LeastSmallInt)

class SmallInt : public FixInt { // These are statically allocated
    DECLARE_MEMBERS(SmallInt)
  public:
    static fix_int smallest() { return LeastSmallInt; }
    static fix_int biggest() { return BiggestSmallInt; }

    SmallInt() : FixInt() { }
    SmallInt(int i) : FixInt(i) { }
#ifdef Q_ENV
    virtual void dumpPtr(CFile *cf) const;
#endif

    virtual const Numeric * addFixInt(fix_int x) const;
    virtual const Numeric * subFixInt(fix_int x) const;
    virtual const Numeric * mulFixInt(fix_int x) const;
    virtual const Numeric * add(const Numeric& x) const {return x.addFixInt(val);}
    virtual const Numeric * sub(const Numeric& x) const {return x.subFixInt(val);}
    virtual const Numeric * mul(const Numeric& x) const {return x.mulFixInt(val);}
    virtual void do_delete() { } // Never deleted
};

class Fraction : public Rational {
    DECLARE_MEMBERS(Fraction)
  public:
    const Integer& num;
    const Integer& den;
    Fraction(const Integer& n, const Integer& d) : num(n), den(d) { }
    virtual const Integer& to_integer(enum RealToIntMode) const;
    virtual const Integer& numerator() const { return num; }
    virtual const Integer& denominator() const { return den; }
    virtual void printon(FILE *) const;
    virtual void printon(FILE *, char *) const;

    virtual const Real& rneg() const;
    virtual const Numeric * addFixInt(fix_int) const;
    virtual const Numeric * subFixInt(fix_int) const;
    virtual const Numeric * mulFixInt(fix_int) const ;
    virtual const Numeric * divFixInt(fix_int) const;
    virtual const Numeric * addInteger(const Integer& x) const;
    virtual const Numeric * subInteger(const Integer& x) const;
    virtual const Numeric * mulInteger(const Integer& x) const;
    virtual const Numeric * divInteger(const Integer& x) const;
    virtual int sign() const { return num.sign(); }
};

class RationalInfinity :  public Fraction {
  public:
    int val;
    RationalInfinity(int s);
    virtual const Real& rneg() const;
    virtual int sign() const { return val; }
    virtual void printon(FILE *) const; 
    virtual void printon(FILE *, char *) const; 

//  virtual const Integer& to_integer(enum RealToIntMode) const {return *this;}
};
extern const RationalInfinity PosInfinity, NegInfinity;

class FixIntTab {
    SmallInt fixes[CountSmallInt];
  public:
    inline const SmallInt& operator[](int i) { return fixes[i]; }
    FixIntTab();
};

extern FixIntTab SmallIntTable;

//extern const Integer * SimplifyInteger(const Integer *bi);
#define MkSmallInt(i)  SmallIntTable[(i)-LeastSmallInt]
extern const SmallInt *Zero, *One, *MinusOne;

extern const Integer *ConvertInteger(const Root *);
extern const Real *ConvertReal(const Root *);
extern "C" const Integer *StrToInt(const char *str, int base, int str_len=-1);

INLINE const Real& operator+(fix_int x, const Real& y)
{
    return *(Real*)y.addFixInt(x);
}
INLINE const Real& operator-(fix_int x, const Real& y)
{
    return *(Real*)y.subFixInt(x);
}
INLINE const Real& operator*(fix_int x, const Real& y)
{
    return *(Real*)y.mulFixInt(x);
}
INLINE const Real& operator+(const Real &x, const Real& y)
{
    return *(const Real*)x.add(y);
}
INLINE const Real& operator-(const Real &x, const Real& y)
{
    return *(const Real*)x.sub(y);
}
INLINE const Real& operator*(const Real &x, const Real& y)
{
    return *(const Real*)x.mul(y);
}
INLINE const Real& operator/(const Real &x, const Real& y)
{
    return *(const Real*)x.div(y);
}
INLINE const Rational& operator+(const Rational &x, const Rational& y)
{
    const Integer& x_num = x.numerator();
    const Integer& x_den = x.denominator();
    const Integer& y_num = y.numerator();
    const Integer& y_den = y.denominator();
    if (&x_den == &y_den)
	return *MakeRational(x_num + y_num, x_den);
    return *MakeRational(y_den * x_num + y_num * x_den, x_den * y_den);
}
INLINE const Rational& operator-(const Rational &x, const Rational& y)
{
    const Integer& x_num = x.numerator();
    const Integer& x_den = x.denominator();
    const Integer& y_num = y.numerator();
    const Integer& y_den = y.denominator();
    if (&x_den == &y_den)
	return *MakeRational(x_num - y_num, x_den);
    return *MakeRational(y_den * x_num - y_num * x_den, x_den * y_den);
}
INLINE const Rational& operator*(const Rational &x, const Rational& y)
{
    return *MakeRational(x.numerator() * y.numerator(),
			 x.denominator() * y.denominator());
}
INLINE const Rational& operator/(const Rational &x, const Rational& y)
{
    return *MakeRational(x.numerator() * y.denominator(),
			 x.denominator() * y.numerator());
}
INLINE const Complex& operator+(const Complex &x, const Complex& y)
{
    const Real& r = x.realPart() + y.realPart();
    const Real& i = x.imagPart() + y.imagPart();
    if (&i == Zero) return r; else return *new ComplexPair(r, i);
}
INLINE const Complex& operator-(const Complex &x, const Complex& y)
{
    const Real& r = x.realPart() - y.realPart();
    const Real& i = x.imagPart() - y.imagPart();
    if (&i == Zero) return r; else return *new ComplexPair(r, i);
}
extern const Complex& operator*(const Complex &x, const Complex& y);
extern const Complex& operator/(const Complex &x, const Complex& y);
extern const Numeric* power(const Numeric* x, const Numeric* y);
extern const Integer& power(const Integer&, fix_unsigned);
extern const Integer& gcd(const Integer&, const Integer&);


INLINE int Integer::bsign() const
{  return this == (const Integer*)&Zero ? 0 : S[len-1] < 0 ? -1 : 1; }

// inline fix_unsigned abs(fix_int a) {return(a<0?-a:a);}
inline unsigned long max(unsigned long x, unsigned long y)
{ return x>y ? x : y; }
#define PosInfinityCode 1
#define NegInfinityCode (-PosInfinityCode)

#endif /* !CORAL_GENNUM_H */
