/************************************************************************
 ========================================================================
 CORAL 
 (c)  Copyright R. Ramakrishnan and The CORAL Group, 
 University of Wisconsin at Madison.
 (1992) All Rights Reserved.
 Version 0.1
 ========================================================================



 ------------------------------------------------------------------------
 CORAL Version 0.1
 RESEARCH SOFTWARE DISCLAIMER -------------------------------------------
 ------------------------------------------------------------------------

    As unestablished, research software, this program is provided free of 
    charge on an "as is" basis without warranty of any kind, either 
    express or implied.  Acceptance and use of this program constitutes 
    the user's understanding that (s)he will have no recourse for any 
    actual or consequential damages, including, but not limited to, 
    lost profits or savings, arising out of the use of or inability to 
    use this program.  

 ------------------------------------------------------------------------
 USER AGREEMENT ---------------------------------------------------------
 ------------------------------------------------------------------------

     BY ACCEPTANCE AND USE OF THIS EXPERIMENTAL PROGRAM
     THE USER AGREES TO THE FOLLOWING:

     a.  This program is provided free of charge for the user's personal, 
	 non-commercial, experimental use.

     b.  All title, ownership and rights to this program and any copies 
         remain with the copyright holder, irrespective of the ownership 
	 of the media on which the program resides.

     c.  The user is permitted to create derivative works to this program.  
         However, all copies of the program and its derivative works must
         contain the CORAL copyright notice, the UNESTABLISHED SOFTWARE 
         DISCLAIMER and this USER AGREEMENT.

     d.  The user understands and agrees that this program and any 
         derivative works are to be used solely for experimental purposes 
	 and are not to be sold or commercially exploited in any manner 
	 WITHOUT EXPRESS WRITTEN PERMISSION.

     e.  We request that the user supply us with a copy of any changes, 
         enhancements, or derivative works which the user may create,
	 with the user's permission to redistribute it.
	 Copies of such material should be sent to:  CORAL@CS.WISC.EDU

-------------------------------------------------------------------------
*************************************************************************/

/***********************************************************************
	CORAL Software :: U.W.Madison

	config.h : Header file

	Configuration parameters, global constants and compiler
	information.

 ***********************************************************************/

#ifndef CORAL_CONFIG_H
#define CORAL_CONFIG_H

/*----- CORAL constants ------*/

#define CORAL


/* default path settings : CORALROOT can also be set from the environment */
/*
 * do not delete/comment out the DEFAULT_CORAL_PATH
 * this is used if CORAL_ROOT is not defined, and if
 * CORALROOT is not set in the runtime environment.
 * Please change it to whatever you like
 */
#define DEFAULT_CORAL_PATH         "/usr/coral"

/*
 * if you do not want to specify CORALROOT in the runtime
 * environment, you can compile it into the code by
 * defining CORALROOT below.
 */
/** #define CORALROOT                 "/var/coral" **/

#define HELP_PATH                  "/help"
#define CORAL_PROMPT               ">"

/* MAX_RULE_LENGTH is the maximum textual length of a clause */
#define MAX_RULE_LENGTH            15000

/* MAX_RHS_PREDS is the maximum number of rhs predicates in a rule */
#define	MAX_RHSPREDS	           50

/* COR_MAX_INDEXES specifies the maximum number of indexes allowed
   for a relation */
#define COR_MAX_INDEXES         8

/* COR_MAX_ARGLIST_SIZE is the maximum number of arguments in a tuple 
 * This is used in the adornment phase of magic, and for persistent relations
 */
#define COR_MAX_ARGLIST_SIZE   30


/* MAX_HISTORY_DEPTH specifies the size of the history buffer */
#define MAX_HISTORY_DEPTH          25


#define COR_RELATION_TABLE_INCR    32
#define COR_DATABASE_TABLE_INCR    32
#define COR_PREDICATE_TABLE_INCR   1

#define COR_DEFAULT_INDEX_BUCKETS  127
#define COR_DEFAULT_DELTA_BUCKETS  31
#define COR_DEFAULT_SET_BUCKETS    7
#define COR_INDEX_INCR_RATIO       2.0
#define COR_INDEX_OCCUPANCY        2.0
#define COR_MAX_RECURSION_DEPTH    10000
/*** see the definition of HASH_RELATION in globals.h ****/
#define COR_RELATION_TYPE_DEFAULT  COR_HASH_RELATION

/* Defaults for CORAL system behaviour */

#define COR_INSERT_MODE_DEFAULT                 0
#define COR_ANSWER_STYLE_DEFAULT                0
#define COR_READ_CORALRC_DEFAULT                1
#define COR_CREATE_MAGIC_DEFAULT                1
#define COR_VERBOSE_ANSWER_DEFAULT              1
#define COR_PRINT_PROMPT_DEFAULT                1
#define COR_DO_HISTORY_DEFAULT	                1

#define COR_PREPROCESSING_DEFAULT      		1
#define COR_REWRITING_DEFAULT      		1
#define COR_USE_EXIST_OPT_DEFAULT  		0
#define COR_USE_MAGIC_DEFAULT      		0
#define COR_USE_FACTORING_DEFAULT  		0
#define COR_USE_FACTOR_MAGIC_DEFAULT         	0
#define COR_USE_SUPPLEMENTARY_MAGIC_DEFAULT  	1
#define COR_USE_SUP_MAGIC_INDEXING_DEFAULT   	0
#define COR_USE_PREDICATE_SEMINAIVE_DEFAULT  	0
#define COR_USE_PIPELINING_DEFAULT    		0 
#define COR_USE_ORDSEARCH_DEFAULT     		0
#define COR_USE_EAGER_EVAL_DEFAULT     		1  /* synonym for lazy_eval! */
#define COR_USE_MONOTONIC_DEFAULT     		0
#define COR_INTERACTIVE_MODE_DEFAULT            1
#define COR_SAVE_MODULE_DEFAULT    		0
#define COR_INDEX_DELTA_DEFAULT    		1
#define COR_CHECK_SUBSUM_DEFAULT   		1
#define COR_MULTISETS_DEFAULT      		0
#define COR_USE_RETURN_UNIFY_DEFAULT  		0 
#define COR_NON_GROUND_FACTS_DEFAULT		1
#define COR_PROFILE_SN_DEFAULT                  0
#define COR_PROFILE_SCC_DEFAULT                 0
#define COR_PROFILE_MODULE_DEFAULT              1
#define COR_DISKREL_DEFAULT                     0
#define COR_EAGER_INDEXING_DEFAULT              1
#define COR_SIP_REORDER_DEFAULT                 1

#define COR_CONVERT_FUNCTIONS_DEFAULT           1
#define COR_SINGLE_SCC_DEFAULT                  0
#define COR_SINGLE_ANSWER_DEFAULT               0
#define COR_CONNECT_EXODUS_DEFAULT              0

/* constants for persistence code */
/* ignore if not compiling with the -DWITH_PERSISTENCE flag */

/* Define the client buffer size to be larger than
 * the size of the buffer used by the storage manager.
 * At present, this is the only buffer used, but in
 * the future, separate buffers may be used for
 * scans, etc. Also, some buffers are reserved
 * by EXODUS and are not available for the
 * SM buffer. 
 */
#define COR_SM_BUF_SIZE        50
#define COR_CLIENT_BUF_SIZE    100

#define COR_MAX_REL_NAME_LEN  200

/* COR_MAX_KEY_LEN is the maximum key length in bytes */
#define COR_MAX_KEY_LEN       500


/*
 * constants used for existential query optimization .
 * these should become outdated pretty soon
 */

/* COR_MAX_PREDS specifies the maximum number of predicate names in a module */
#define COR_MAX_PREDS          50

/* COR_MAX_VARS specifies the maximum number of variables in a rule */
#define COR_MAX_VARS           50

/* COR_MAX_RULE specifies the maximum number of rules in a module */
#define COR_MAX_RULES         100

/* COR_MAX_COMB specifies the maximum unit rule combinations for EQO */
#define COR_MAX_COMB         1000

/* COR_MAX_PROJ specifies the maximum number of projections for EQO */
#define COR_MAX_PROJ          1000

/*-----------------------------------------------*/

#ifdef hpux
#define UNIX_HP
#else

#ifdef mips
#define UNIX_MIPS
#else
 /** assume a SUN4 **/
#define UNIX_SPARC
#endif 

#endif

#ifdef __cplusplus
#define CPLUS
#define EXTERN extern "C"
#ifdef UNIX_HP
extern "C" void abort(void);
#endif
#else
#define EXTERN extern
#endif

#ifdef DEBUG
#define ASSERT(x) if(!(x)) \
    { fprintf(stderr, "** Assertion ( x ) failed at line %d of file \"%s\". ",\
     __LINE__, __FILE__ ) ; \
     abort() ; }
#else
#define ASSERT(x) ;
#endif

/* used to prevent the C++ compiler from complaining about unused function
   arguments  */
#define IGNORE_ARG(X) (&X);

/*------ CORAL flags ---------*/

#define DO_TRAIL

/*
 * USE_HASHCONSING:  If this flag is set to 1, hash consing is used when
 *			computing hash values for args. 
 */
#define USE_HASHCONSING 1


/*----- Compiler specific declarations ---*/

#ifdef __STDC__
#define CONCAT_ID2(a, b) a##b
#else
#define CONCAT_ID2(a, b) a/**/b
#endif

#ifdef c_plusplus
#undef __GNUG__ /* In case we're using gcc-cpp with ATT's CC. */
#undef __GNUC__
#endif

#if defined(__STDC__) || defined(__cplusplus)
/*
 * The following macro helps define argument lists for fns: the arg lists are
 * eaten up when not allowed (as in C).
 * e.g. extern int foo ARGS((int, int));
 */
#define ARGS(args) args
#define CONST const
typedef void *Pointer;
typedef const void *ConstPointer;
#else
#define ARGS(args) ()
#define CONST
typedef char *Pointer;
typedef char *ConstPointer;
#define void int
#endif

#endif /* !CORAL_CONFIG_H */
