/************************************************************************
 ========================================================================
 CORAL 
 (c)  Copyright R. Ramakrishnan and The CORAL Group, 
 University of Wisconsin at Madison.
 (1992) All Rights Reserved.
 Version 0.1
 ========================================================================



 ------------------------------------------------------------------------
 CORAL Version 0.1
 RESEARCH SOFTWARE DISCLAIMER -------------------------------------------
 ------------------------------------------------------------------------

    As unestablished, research software, this program is provided free of 
    charge on an "as is" basis without warranty of any kind, either 
    express or implied.  Acceptance and use of this program constitutes 
    the user's understanding that (s)he will have no recourse for any 
    actual or consequential damages, including, but not limited to, 
    lost profits or savings, arising out of the use of or inability to 
    use this program.  

 ------------------------------------------------------------------------
 USER AGREEMENT ---------------------------------------------------------
 ------------------------------------------------------------------------

     BY ACCEPTANCE AND USE OF THIS EXPERIMENTAL PROGRAM
     THE USER AGREES TO THE FOLLOWING:

     a.  This program is provided free of charge for the user's personal, 
	 non-commercial, experimental use.

     b.  All title, ownership and rights to this program and any copies 
         remain with the copyright holder, irrespective of the ownership 
	 of the media on which the program resides.

     c.  The user is permitted to create derivative works to this program.  
         However, all copies of the program and its derivative works must
         contain the CORAL copyright notice, the UNESTABLISHED SOFTWARE 
         DISCLAIMER and this USER AGREEMENT.

     d.  The user understands and agrees that this program and any 
         derivative works are to be used solely for experimental purposes 
	 and are not to be sold or commercially exploited in any manner 
	 WITHOUT EXPRESS WRITTEN PERMISSION.

     e.  We request that the user supply us with a copy of any changes, 
         enhancements, or derivative works which the user may create,
	 with the user's permission to redistribute it.
	 Copies of such material should be sent to:  CORAL@CS.WISC.EDU

-------------------------------------------------------------------------
*************************************************************************/

/***********************************************************************
	CORAL Software :: U.W.Madison

	builtin-syms.h

	Declarations of Symbols used internally.
 ***********************************************************************/

#ifndef BUILTINSYMS_H
#define BUILTINSYMS_H

/** BEWARE
   When it occurs anywhere other than in symbol.C, DCL_KEYWORD2 is defined
    as follows (refer arg.h) :
	#define DCL_KEYWORD2(x,s) extern Symbol *x;
**/

DCL_KEYWORD2(ConsSymbol, "cons")
DCL_KEYWORD2(ListSymbol, "_LIST_")
DCL_KEYWORD2(NestedSymbol, "__NESTED__")
DCL_KEYWORD2(NilSymbol, "nil")
DCL_KEYWORD2(TrueSymbol, "true")
DCL_KEYWORD2(ModuleSymbol, "module")
DCL_KEYWORD2(ExportSymbol, "export")
DCL_KEYWORD2(QSymbol, "q")
DCL_KEYWORD2(QuerySymbol, "query")
DCL_KEYWORD2(DontCareSymbol, "_")
DCL_KEYWORD2(CutSymbol, "cut_")

// Arithmetic operations
DCL_KEYWORD2(AddOpSymbol, "add_")
DCL_KEYWORD2(SubOpSymbol, "sub_")
DCL_KEYWORD2(MulOpSymbol, "mul_")
DCL_KEYWORD2(DivOpSymbol, "div_")
DCL_KEYWORD2(IDivOpSymbol, "idiv_")
DCL_KEYWORD2(EquOpSymbol, "equ_")
DCL_KEYWORD2(NeqOpSymbol, "neq_")
DCL_KEYWORD2(LssOpSymbol, "lss_")
DCL_KEYWORD2(GrtOpSymbol, "grt_")
DCL_KEYWORD2(LeqOpSymbol, "leq_")
DCL_KEYWORD2(GeqOpSymbol, "geq_")
DCL_KEYWORD2(CopyTermSymbol, "copy_term")

// Head aggregate operators
DCL_KEYWORD2(SumOpSymbol, "sum")
DCL_KEYWORD2(ProdOpSymbol, "prod")
DCL_KEYWORD2(CountOpSymbol, "count")
DCL_KEYWORD2(MinOpSymbol, "min")
DCL_KEYWORD2(MaxOpSymbol, "max")
DCL_KEYWORD2(AvgOpSymbol, "avg")
DCL_KEYWORD2(ADstOpSymbol, "avg_distinct")
DCL_KEYWORD2(SDstOpSymbol, "sum_distinct")
DCL_KEYWORD2(PDstOpSymbol, "prod_distinct")
DCL_KEYWORD2(CDstOpSymbol, "count_distinct")
DCL_KEYWORD2(DstOpSymbol, "distinct")

DCL_KEYWORD2(AbsOpSymbol, "abs")
DCL_KEYWORD2(AnyOpSymbol, "any")

// bitwise operator builtins
DCL_KEYWORD2(LShiftOpSymbol, "lshift_")  //  <<
DCL_KEYWORD2(RShiftOpSymbol, "rshift_")  //  >>
DCL_KEYWORD2(BitorOpSymbol, "bitor_")    //  bitor
DCL_KEYWORD2(BitandOpSymbol, "bitand_")  //  bitand
DCL_KEYWORD2(BitnotOpSymbol, "bitnot_")  //  bitnot
DCL_KEYWORD2(BitxorOpSymbol, "bitxor_")    //  bitxor
DCL_KEYWORD2(CompOpSymbol, "comp_")      //  ~
DCL_KEYWORD2(ModOpSymbol, "mod_")        //  %

// set manipulation builtins
DCL_KEYWORD2(AddElemSymbol, "add_elem")
DCL_KEYWORD2(AddElemDSymbol, "add_elem_d")
DCL_KEYWORD2(CallSymbol, "call")
DCL_KEYWORD2(CreateSetSymbol, "create_set")
//DCL_KEYWORD2(MsetOpSymbol, "makeset")
DCL_KEYWORD2(MemberSymbol, "member")
DCL_KEYWORD2(MemTupleSymbol, "memtuple")
DCL_KEYWORD2(SubsetSymbol, "subset")
DCL_KEYWORD2(UnionSumSymbol, "unionsum")
DCL_KEYWORD2(UnionMaxSymbol, "unionmax")
DCL_KEYWORD2(UnionSumDSymbol, "unionsum_d")
DCL_KEYWORD2(UnionMaxDSymbol, "unionmax_d")
DCL_KEYWORD2(UnivSymbol, "univ")
DCL_KEYWORD2(InterSymbol, "inter")
DCL_KEYWORD2(DifferenceSymbol, "difference")
DCL_KEYWORD2(MakeSetSymbol, "make_set")
DCL_KEYWORD2(InterDSymbol, "inter_d")
DCL_KEYWORD2(DifferenceDSymbol, "difference_d")
DCL_KEYWORD2(MakeSetDSymbol, "make_set_d")


DCL_KEYWORD2(FunctorSymbol, "functor")
DCL_KEYWORD2(ArgSymbol, "arg")
DCL_KEYWORD2(PowSymbol, "pow")


// string manipulation builtins
DCL_KEYWORD2(LengthSymbol, "length")
DCL_KEYWORD2(ExtractSymbol, "extract")


// User annotations
DCL_KEYWORD2(SupplementaryMagicSymbol, "sup_magic") 
DCL_KEYWORD2(OrdinaryMagicSymbol, "magic") 
DCL_KEYWORD2(NoMagicSymbol, "no_form_of_magic") 
DCL_KEYWORD2(SupMagicIndexingSymbol, "sup_magic_indexing") 
DCL_KEYWORD2(ExistOptSymbol, "existential")
DCL_KEYWORD2(UseFactoringSymbol, "factoring")
DCL_KEYWORD2(UseFactorMagicSymbol, "factor_magic")
DCL_KEYWORD2(UsePipeliningSymbol, "pipelining")
DCL_KEYWORD2(UseOrdSearchSymbol, "ordered_search")
DCL_KEYWORD2(SaveModuleSymbol, "save_module") 
DCL_KEYWORD2(NoRewritingSymbol, "no_rewriting")
DCL_KEYWORD2(NoPreProcessingSymbol, "no_preprocessing")


DCL_KEYWORD2(SingleSccSymbol, "single_scc")
DCL_KEYWORD2(SingleAnswerSymbol, "single_answer")
DCL_KEYWORD2(ConvertFunctionsSymbol, "convert_functions")
DCL_KEYWORD2(PredicateSNSymbol, "psn") 

DCL_KEYWORD2(MultisetSymbol, "multiset") 
DCL_KEYWORD2(CheckSubsumSymbol, "check_subsumption") 
DCL_KEYWORD2(AggSelectionSymbol, "aggregate_selection")
DCL_KEYWORD2(PrioritizeSymbol, "prioritize")
DCL_KEYWORD2(ChoiceSymbol, "choice")
DCL_KEYWORD2(DiskResidentSymbol, "disk")

DCL_KEYWORD2(IndexDeltaSymbol,"index_deltas") 
DCL_KEYWORD2(ReturnUnifySymbol,"return_unify") 
DCL_KEYWORD2(EagerEvalSymbol, "lazy_eval")
DCL_KEYWORD2(MonotonicSymbol, "monotonic")
DCL_KEYWORD2(MakeIndexSymbol, "make_index")
DCL_KEYWORD2(AllowedAdornSymbol, "allowed_adornments")
DCL_KEYWORD2(AllowedIndexSymbol, "allowed_index_args")
DCL_KEYWORD2(NonGroundFactsSymbol, "non_ground_facts")
DCL_KEYWORD2(SipReorderSymbol, "sip_reorder")
DCL_KEYWORD2(EagerIndexingSymbol, "eager_indexing")

// Print builtins
DCL_KEYWORD2(PrintEmptySymbol, "print_empty")
DCL_KEYWORD2(PrintBindingSymbol, "print_bindings")
DCL_KEYWORD2(PrintTupleSymbol, "print_tuple")
DCL_KEYWORD2(DisplaySymbol,"print")
DCL_KEYWORD2(PrintfSymbol,"printf")
DCL_KEYWORD2(ScanfSymbol, "scanf")

// Builtin relations
DCL_KEYWORD2(AliasSymbol, "alias_rel")
DCL_KEYWORD2(AssignSymbol,"assign")
DCL_KEYWORD2(ClearSymbol, "clear" )
DCL_KEYWORD2(ConsultSymbol,"consult") 
DCL_KEYWORD2(CpuTimeSymbol, "cputime")
DCL_KEYWORD2(DeleteFactSymbol, "delete")
DCL_KEYWORD2(DisplayTimerSymbol, "display_timer")
DCL_KEYWORD2(ExplainOffSymbol, "explain_off")
DCL_KEYWORD2(ExplainOnSymbol, "explain_on")
DCL_KEYWORD2(FailSymbol,"fail") 
DCL_KEYWORD2(GetSymbol,   "get"   )
DCL_KEYWORD2(GoalIdOpSymbol,"goal_id") 
DCL_KEYWORD2(HelpSymbol,"help")
DCL_KEYWORD2(HistorySymbol, "history")
DCL_KEYWORD2(InsertFactSymbol, "insert")
DCL_KEYWORD2(PipeInSymbol,"pipein") 
DCL_KEYWORD2(PipeOutSymbol,"pipeout") 
DCL_KEYWORD2(ProfileOffSymbol, "profile_off")
DCL_KEYWORD2(ProfileOnSymbol, "profile_on")
DCL_KEYWORD2(QuitSymbol,"quit") 
DCL_KEYWORD2(SetSymbol,   "set"   )
DCL_KEYWORD2(ShellSymbol, "shell")
DCL_KEYWORD2(StartTimerSymbol, "reset_timer")
DCL_KEYWORD2(TraceSymbol, "trace_on")
DCL_KEYWORD2(UntraceSymbol, "trace_off")
DCL_KEYWORD2(WriteTableSymbol, "write_table")
extern char *ArrayConstructorString;
DCL_KEYWORD2(ArrayConstructSymbol, ArrayConstructorString)


// Builtin relations to deal with multiple workspaces( nee\ databases)

DCL_KEYWORD2(CreateDBSymbol, "ws_create")
DCL_KEYWORD2(DestroyDBSymbol, "ws_destroy")
DCL_KEYWORD2(CurrentDBSymbol, "ws_current")
DCL_KEYWORD2(SaveDBSymbol, "ws_save")
DCL_KEYWORD2(RenameDBSymbol, "ws_rename")
DCL_KEYWORD2(ClearDBSymbol, "ws_clear")
DCL_KEYWORD2(CopyRelToDBSymbol, "rel_copy")
DCL_KEYWORD2(AddRelToDBSymbol, "rel_add")
DCL_KEYWORD2(ClearRelSymbol, "rel_clear")
DCL_KEYWORD2(CloseRelSymbol, "rel_close")
DCL_KEYWORD2(ListRelsInDBSymbol, "list_rels")
DCL_KEYWORD2(ListDBSymbol, "list_ws")
DCL_KEYWORD2(OpenRelInDBSymbol, "rel_open")

// Builtin relations to handle the default execution environment
DCL_KEYWORD2(DisplayDefaultsSymbol, "display_defaults")
DCL_KEYWORD2(ResetDefaultsSymbol, "reset_defaults")

// Builtin relations to check the type of an arg
DCL_KEYWORD2(IsConstantSymbol, "is_constant")
DCL_KEYWORD2(IsVarSymbol, "is_var")
DCL_KEYWORD2(IsListSymbol, "is_list")
DCL_KEYWORD2(IsFunctorSymbol, "is_functor")
DCL_KEYWORD2(IsStringSymbol, "is_string")
DCL_KEYWORD2(IsNumSymbol, "is_num")
DCL_KEYWORD2(IsIntSymbol, "is_int")
DCL_KEYWORD2(IsLongSymbol, "is_long")
DCL_KEYWORD2(IsShortSymbol, "is_short")
DCL_KEYWORD2(IsFloatSymbol, "is_float")
DCL_KEYWORD2(IsDoubleSymbol, "is_double")


#endif /* !BUILTINSYMS_H */


