/************************************************************************
 ========================================================================
 CORAL 
 (c)  Copyright R. Ramakrishnan and The CORAL Group, 
 University of Wisconsin at Madison.
 (1992) All Rights Reserved.
 Version 0.1
 ========================================================================



 ------------------------------------------------------------------------
 CORAL Version 0.1
 RESEARCH SOFTWARE DISCLAIMER -------------------------------------------
 ------------------------------------------------------------------------

    As unestablished, research software, this program is provided free of 
    charge on an "as is" basis without warranty of any kind, either 
    express or implied.  Acceptance and use of this program constitutes 
    the user's understanding that (s)he will have no recourse for any 
    actual or consequential damages, including, but not limited to, 
    lost profits or savings, arising out of the use of or inability to 
    use this program.  

 ------------------------------------------------------------------------
 USER AGREEMENT ---------------------------------------------------------
 ------------------------------------------------------------------------

     BY ACCEPTANCE AND USE OF THIS EXPERIMENTAL PROGRAM
     THE USER AGREES TO THE FOLLOWING:

     a.  This program is provided free of charge for the user's personal, 
	 non-commercial, experimental use.

     b.  All title, ownership and rights to this program and any copies 
         remain with the copyright holder, irrespective of the ownership 
	 of the media on which the program resides.

     c.  The user is permitted to create derivative works to this program.  
         However, all copies of the program and its derivative works must
         contain the CORAL copyright notice, the UNESTABLISHED SOFTWARE 
         DISCLAIMER and this USER AGREEMENT.

     d.  The user understands and agrees that this program and any 
         derivative works are to be used solely for experimental purposes 
	 and are not to be sold or commercially exploited in any manner 
	 WITHOUT EXPRESS WRITTEN PERMISSION.

     e.  We request that the user supply us with a copy of any changes, 
         enhancements, or derivative works which the user may create,
	 with the user's permission to redistribute it.
	 Copies of such material should be sent to:  CORAL@CS.WISC.EDU

-------------------------------------------------------------------------
*************************************************************************/

/***********************************************************************
	CORAL Software :: U.W.Madison

	arg.h : Header file

	Declarations for arguments of different types. Declarations
	for numeric args are found in gennum.h

	Adding new subclasses of Arg:
 	  if you add a new subclass of Arg, and it is a constant (eg. integer,
	  string etc), make it a subclass of ConstArg!.

	Contains the following class/type  declarations	 :
	  HashVal
	  ArgList
	  Arg (and ConstArg, VarArg, FunctArg, NumArg, Symbol, DontCareArg,
	       Grouping)
	  VarLink
	  TermLink
	  arg_kind
	  numarg_kind
	  
 ***********************************************************************/

#ifndef CORAL_ARG_H
#define CORAL_ARG_H

#include "config.h"
#include <stdio.h>
#include <stdlib.h>

#define FOR_EACH_ARG(ARG, ARGLIST)	\
  { register Arg **__a__ = (ARGLIST).first();	\
    register int __i__ = (ARGLIST).count();	\
    register Arg *ARG;			  	\
    for ( ; --__i__ >= 0; __a__++) { ARG = *__a__;
#define END_EACH_ARG }}

#define S_NoMatch -1

struct VarArg; struct Numeric; class BindEnv;
struct VarLink;
struct NumArg ; struct DontCareArg;
class Tuple;
typedef struct ArgList ArgList;
typedef struct Arg Arg, *ArgPtr;
typedef struct Symbol Symbol;
typedef Symbol *Name;
typedef int Variable;           // This is distinct from VarArg !!
typedef int VarFunc(VarArg* var, void* data);

class Term;
class BindEnv;
class Relation;
struct BitVector;
/* Copy and simplify from old_args to new_args. */
// WARNING:  may need to change NULL below to UnusedEnv
extern int CopyArgs(ArgPtr* new_args, ArgPtr *old_args, BindEnv *env,
		    int arity, BindEnv *dont_rename_env,
		    BindEnv *rename_only_env = NULL);
extern int CopyArg(Arg **new_arg, Arg *old_arg, BindEnv *env);

EXTERN void PrintSymbol ARGS((Name sym, FILE *ff));
EXTERN Name EnterSymbol ARGS((const char *));
extern Name InsertSymbol ARGS((const char *, int len));
extern Name DontCareSymbol;
extern DontCareArg TheDontCareArg;


typedef char arg_kind;
#define COR_NUM_CONST     0
#define COR_VARIABLE      1
#define COR_DONTCARE      2
#define COR_FUNCTOR       3
#define COR_CONST_ARG     4
#define COR_SYMBOL_CONST  5
#define COR_RELATION	  6
#define COR_GROUPING      7
#define COR_TUPLE_ARG     8
#define COR_TUPLE_VAR     9


typedef char numarg_kind;
#define COR_INTEGER 0
#define COR_DOUBLE 1
#define COR_ARITH_EXPR 2
#define COR_NOT_A_NUMBER 3



// Hashing and HashConsing constants:
// 	Any hash value other than VarHashValue and UnknownHashValue 
//		is a hash value of a ground term
//	A term whose hash value is VarHashValue is non-ground.
//	A term whose hash value is UnknownHashValue may be ground or non-ground
//		-- its hash value has not been computed.
// 	When hashconsing is used (USE_HASHCONSING is set), FuncArg.hash()
//		is either VarHashValue, or is a pointer to a
//		constant term that is equal to (FuncArg, bindenv) 
//		(the pointer is cast to HashVal). 
//		CAVEAT:  We assume that the pointer cannot be one of 
//			VarHashValue or UnknownHashValue.
//

#define VarHashValue ( (HashVal) -1)

// This value is not generally supported!
#define UnknownHashValue ( (HashVal) -2)

typedef unsigned int HashVal;
inline int isGroundHashValue( HashVal i) {
    return (i != VarHashValue && i != UnknownHashValue);
    }
inline int IntToHash(int i) { return ((HashVal)(-1) >> 1) & i; }


/*
 * An ArgList is an "variable size" array of (Arg*).
 * The first element is not actually an (Arg*),
 * but (after coercion to int) contains the length of the array. 
 * WARNING:  ArgList must remain a struct - do not make it into a class
 * that can contain virtual functions, else a lot of code will crash! 
 * Use ArgList::New() to create a new ArgList
 */
struct ArgList {
    ArgPtr a[1];
    /* ... array of (Arg*) follows */
    inline int count() const { return (int)(*((Arg**)this)); }
    inline int arity() const { return count(); }
    inline void set_count(int i) { *((Arg**)this) = (Arg*)i; }
    inline Arg **first() const { return (Arg**)(this)+1;}

    inline ArgPtr& operator [] (int i) const
	{ return ((Arg**)(this)+1)[i]; }
    inline ArgPtr arg (int i) const
	{ return ((Arg**)(this)+1)[i]; }

    // Returns true if all the arguments are NumArgs or Symbols
    int isConstant();

    void print_dump(BindEnv *context, FILE *file) const;
    void print(BindEnv *context, FILE *file) const;
    void print(BindEnv *context, FILE *file, char *fmt_str) const;

    void printon(FILE *file) const { print((BindEnv*)0, file); }
    void sprint(char *str, int *pos, BindEnv *context = NULL) const;

    VarLink *var_list(VarLink* rest);
    Variable max_vars();

    HashVal hash( BitVector& bv, BindEnv* env = NULL );
    HashVal hash( BindEnv* env = NULL );

    static ArgList * New(int arg_count); // Allocate new ArgList.

    RAW_GCCLASS(ArgList);

};
#define arg_vector(arglist) ((Arg**)(&(arglist) + 1))


// Use for making linked lists of Vars.
struct VarLink { 
    VarLink *next;
    VarArg *arg;
    VarLink(VarArg *a, VarLink *n) { arg = a; next = n; }
    int contains(VarArg *a);
};


// TermLink is used by CopyArgs() to re-number VarArgs.
struct TermLink {
    struct TermLink *next;  /* Next TermLink in list. */
    Variable old_var;
    BindEnv  *old_bindenv;
    struct VarArg *new_arg; /* ... and yield this new VarArg instead. */
};

// Generic Arg structure
struct Arg {
    arg_kind  _kindof;
    virtual VarLink *var_list(VarLink* rest);
    virtual Variable max_vars();

    virtual void print(BindEnv *context, FILE *file) const;
    virtual void print(BindEnv *context, FILE *file, char *fmt_str) const;
    /** Tarun **/
    virtual void print_dump(BindEnv *context, FILE *file) const
      {print(context, file);};
 
    // sprint is used for printing on a string. The second
    // argument is advanced to the end of the written portion,
    // so that the next sprint can be called.
    virtual void sprint(char *str, int *pos, BindEnv *context = NULL) const =0;
    void printon(FILE *file) const { print((BindEnv*)0, file); }
    virtual void printon(FILE *file, char *fmt_str) const;
    virtual void output() const { print((BindEnv*)0, stderr); }

    inline arg_kind kindof() const { return _kindof;}
    virtual int subkind() { return 0;}

    // Returns true if it is a NumArg or Symbol
    virtual int isConstant() = 0;
    virtual int equals(Arg *arg2);

    virtual HashVal hash(BindEnv *context = 0) ;

    virtual Arg* simplify(BindEnv *context, TermLink *&renamed_vars,
			BindEnv *const_env, BindEnv *rename_only_env);

    // For each VarArg* 'v' in 'this', call 'func(v, data)'.
    virtual int scan_vars(void *data, VarFunc *func) ;
    //virtual const Numeric * numeric() const ;
    Arg() { _kindof = COR_CONST_ARG;}
    virtual ~Arg() {};
};

// ConstArg is a superclass of NumArg and Symbol
struct ConstArg : public Arg {
    virtual int isConstant();
    //virtual arg_kind kindof() const = 0;
    virtual int equals(Arg *arg2)=0;

    virtual void print(BindEnv* env, FILE *file) const = 0;
    virtual void print(BindEnv* env, FILE *file, char *fmt_str) const = 0;
    virtual void sprint(char *str, int *pos, BindEnv *context = NULL) const =0;
    ConstArg() { _kindof = COR_CONST_ARG;}
    virtual ~ConstArg() {};
};


#define DCL_KEYWORD2(x,s) extern Symbol *x;
#define SymbolLength(s) (((Symbol*)(s))->_length)
#define SymbolHash(s) (((Symbol*)(s))->_hash)
#define SymbolString(s) (((Symbol*)(s))->str)
#define SymbolUnsignedString(s) ((unsigned char*)SymbolString(s))

// All strings belong to this class
struct Symbol : public ConstArg {
    // Each symbol is identified by a hash value and a length
    HashVal _hash;
    int _length;
    char *str;
    // actually has char data[length];

    inline Symbol(const char *s, int length, HashVal h) {
      _hash = h;
      _length = length;
      str = new char[++length];
      memcpy(str, s, length);
      _kindof = COR_SYMBOL_CONST;
     }
      
    inline Symbol(HashVal h, int l) { _hash = h; _length = l; _kindof = COR_SYMBOL_CONST;
				      str = NULL;}
    virtual ~Symbol() { if (str) delete str; }

    inline int Length() const { return (int) _length; }
    inline int length() const { return (int) _length; }

    inline char *string() const { return str; }
    unsigned char *ustring() const { return (unsigned char*)str; }
    inline Symbol *sym_name() const { return (Symbol*)this; }

    virtual int equals(Arg *arg2);

    virtual void print(BindEnv*, FILE *file) const;
    virtual void print(BindEnv*, FILE *file, char *fmt_str) const;
    virtual void sprint(char *str, int *pos, BindEnv *context = NULL) const;

    virtual HashVal hash(BindEnv *context = 0) { return _hash; };
};

struct DontCareArg : public Arg {
    Name _functor;/* functor info if kind==COR_FUNCTOR */
    inline DontCareArg() { _functor = DontCareSymbol; _kindof = COR_DONTCARE;};
    virtual ~DontCareArg() {};

    //virtual arg_kind kindof() const ;
    virtual int isConstant();
    virtual int equals(Arg *arg2);

    virtual void print(BindEnv*, FILE *file) const;
	virtual void print(BindEnv*, FILE *file, char *fmt_str) const;
    virtual void sprint(char *str, int *pos, BindEnv *context = NULL) const;
};



struct VarArg : public Arg {
    Name     _functor;       /* name of variable */
    int	     var;            /* Index into current context */
    inline VarArg(Name name, int index) { _functor = name; var = index; _kindof = COR_VARIABLE;}
    virtual ~VarArg() {}

    inline Name var_name() const { return _functor; }

    virtual void print(BindEnv*, FILE *file) const;
	virtual void print(BindEnv*, FILE *file, char *fmt_str) const;
    virtual void sprint(char *str, int *pos, BindEnv *context = NULL) const;

    inline Term dereference_var(BindEnv* env); // Does a one level dereference
    inline Term dereference(BindEnv* env);  	// Does a full dereference

    //virtual arg_kind kindof() const ;
    virtual int isConstant();
    virtual int equals(Arg *arg2);

    virtual VarLink *var_list(VarLink* rest);
    virtual HashVal hash(BindEnv *context = 0);
    virtual int scan_vars(void *data, VarFunc *func);
    virtual Arg* simplify(BindEnv *context, TermLink *&renamed_vars,
			BindEnv *const_env, BindEnv *rename_only_env);
};


// Arguments that are functions. eg : f(X,Y) in pred(f(X,Y), Z).
// WARNING : FuncArg is variable size. Use FuncArg::New as constructor
class FuncArg : public Arg {
  protected:
    inline FuncArg(Name op, int argcount) : _functor(op)
	{ _hash = UnknownHashValue; args.set_count(argcount); _kindof = COR_FUNCTOR;}
    virtual ~FuncArg() {};
    HashVal _hash;    
	// The field _hash of a FuncArg must be set to UnknownHashValue if the
	// 	hash value has not been computed.  It must be set to 
	//	VarHashValue if FuncArg is found to have variables in it.
	//  	It must be set to other values if FuncArg is found to be 
	//	variable free.  Thus looking at the _hash value is a 
	// 	quick sufficient test for the FuncArg being constant.
	//
  public:
    Name _functor;                     /* functor info if kind==COR_FUNCTOR */
    ArgList		args;	       /* args of functor */

    static FuncArg * New(Name op, int arg_count);

    virtual int isConstant();
    virtual int equals(Arg *arg2);

    int count() const { return args.count(); }
    inline Name functor() const { return _functor; }
    inline int arity() { return args.count(); }

    virtual void print(BindEnv*, FILE *file) const;
	virtual void print(BindEnv*, FILE *file, char *fmt_str) const;
    virtual void sprint(char *str, int *pos, BindEnv *context = NULL) const;

    virtual VarLink *var_list(VarLink* rest);
    virtual HashVal hash(BindEnv *context = 0);
    virtual int scan_vars(void *data, VarFunc *func);
    virtual Arg* simplify(BindEnv *context, TermLink *&renamed_vars,
			BindEnv *const_env, BindEnv *rename_only_env);
};

/************ Doesnt seem necessary !! Praveen
struct FuncArg0 : public FuncArg {
    FuncArg0(Symbol *op) : FuncArg(op, 0) { }
};
struct FuncArg1 : public FuncArg { ArgPtr a[1];
    FuncArg1(Symbol *op, Arg *a0) : FuncArg(op, 1) { a[0]=a0; }
};
struct FuncArg2 : public FuncArg { ArgPtr a[2];
    FuncArg2(Symbol*op, Arg*a0, Arg*a1) : FuncArg(op, 2) { a[0]=a0; a[1]=a1; }
};
struct FuncArg3 : public FuncArg { ArgPtr a[3];
    FuncArg3(Symbol*op, Arg*a0, Arg*a1, Arg*a2) : FuncArg(op, 3)
      { a[0]=a0;a[1]=a1;a[2]=a2;}
};
struct FuncArg4 : public FuncArg { ArgPtr a[4];
    FuncArg4(Symbol*op, Arg*a0, Arg*a1, Arg*a2, Arg*a3) : FuncArg(op, 4)
      {a[0]=a0;a[1]=a1;a[2]=a2;a[3]=a3;}
};
**********/

typedef struct NumArg Root;
struct NumArg : public ConstArg {
  numarg_kind _num_kindof;
  union {
    int i_val;
    double d_val;
   };

  inline NumArg() { _kindof = COR_NUM_CONST; _num_kindof = COR_NOT_A_NUMBER;}
  inline NumArg(int i) { _kindof = COR_NUM_CONST; _num_kindof = COR_INTEGER; i_val = i;}
  inline NumArg(double d) { _kindof = COR_NUM_CONST; _num_kindof = COR_DOUBLE; d_val = d;}
  virtual ~NumArg() {};
  inline numarg_kind num_kindof() const { return _num_kindof; }
  inline double doubval() const { return ((_num_kindof == COR_DOUBLE) ? d_val : (double)i_val) ;}
  virtual int equals(Arg *arg2);
  virtual int compare(const Root&) const;

  virtual void printon(FILE *) const;
  virtual void printon(FILE *, char *) const;
  virtual void print(BindEnv*, FILE *file, char *fmt_str) const { printon(file, fmt_str);}
  virtual void print(BindEnv*, FILE *file) const { printon(file); }
  virtual void sprint(char *str, int *pos, BindEnv *context = NULL) const;
  virtual HashVal hash(BindEnv *context = NULL);

  virtual Arg* simplify(BindEnv *context, TermLink *&renamed_vars,
			BindEnv *const_env, BindEnv *rename_only_env);
};

extern const NumArg *Zero, *One, *MinusOne;
extern "C" NumArg *MakeFixInt(int i);
extern "C" NumArg *NewDouble(double d);

struct ExprArg : public NumArg {

    Name   op;
    int    op_arity;
    Arg    *left_arg;
    Arg    *right_arg;

    ExprArg(Name op, Arg *left, Arg *right) 
	{this->op = op; left_arg = left; right_arg = right; op_arity = 2; _num_kindof = COR_ARITH_EXPR;}
    ExprArg(Name op, Arg *only)
	{this->op = op; left_arg = only; right_arg = (Arg *)Zero; 
			op_arity = 1;_num_kindof = COR_ARITH_EXPR;}
    virtual ~ExprArg() {}

    virtual Arg* simplify(BindEnv *context, TermLink *&renamed_vars,
			BindEnv *const_env, BindEnv *rename_only_env);
    virtual HashVal hash(BindEnv *context = 0);
    virtual VarLink *var_list(VarLink* rest);

    virtual void print(BindEnv *, FILE *) const ;
    virtual void print_dump(BindEnv * env, FILE *file) const;
    virtual void printon(FILE *) const ;
    virtual void printon(FILE *, char *) const ; 
    virtual void sprint(char *str, int *pos, BindEnv *context = NULL) const;
};

// NOTE: Do not edit this without also editing builtin_ops in gram.y!
enum AggregateKind {
    SumAggregation,        // sum(<X>)
    ProductAggregation,    // prod(<X>)
    CountAggregation,      // count(<X>)
    MinAggregation,        // min(<X>)
    MaxAggregation,        // max(<X>)
    AvgAggregation,        // avg(<X>)
    SumDAggregation,       // sum_distinct(<X>)
    ProdDAggregation,      // prod_distinct(<X>)
    CountDAggregation,     // count_distinct(<X>)
    AvgDAggregation,       // avg_distinct(<X>)
    SetAggregation,        // distinct(<X>)
    AnyAggregation,        // any(<X>)
    NoAggregation, // create_functor in gram.y assumes this is last.
};

// WARNING : Use Grouping::New to get a new Grouping (it is of variable size)
class Grouping : public Arg {
  public:
    FuncArg * nestedArgs;
    int index;               // Sequence number within current clause.

    short check_subsum;

    enum AggregateKind kind;
    // If kind==NoAggregation, then 'this' is the parse of '<ARGS>',
    // where 'nestedArgs' represents 'ARGS'.
    // Otherwise, if kind is (say) SummAggregation,
    // then 'this' is the parse of 'sum<ARGS>'.

    Grouping(int argcount);
    Grouping(FuncArg *func, int index);
    Grouping(FuncArg *func, int _index, int k)
	{ nestedArgs = func; index = _index; kind = (enum AggregateKind)k; _kindof = COR_GROUPING;}
    static Grouping* New(int arity) { return new Grouping(arity); }
    virtual ~Grouping() {}

    virtual int equals(Arg *arg2);
    virtual int isConstant() { return 1; }
    virtual void set_subsumption(short subsum_flag)
                                { check_subsum = subsum_flag; }

    virtual void print_dump(BindEnv * env, FILE *file) const;
    virtual void print(BindEnv* env, FILE *file) const;
    virtual void print(BindEnv* env, FILE *file, char *fmt_str) const;
    virtual void sprint(char *str, int *pos, BindEnv *context = NULL) const;

    inline Arg **first() const { return nestedArgs->args.first(); }
    int arity() const { return nestedArgs->count(); }
    virtual Arg* simplify(BindEnv *context, TermLink *&renamed_vars,
			BindEnv *const_env, BindEnv *rename_only_env);
    // WARNING:: This assumes that nested sets are ground!! This ought to
    // 		be the case, but we should make sure using the 
    //   	hash value.
    int update_tuple(Tuple *, Tuple *, Arg *, int, BindEnv *);
};

#endif /*!CORAL_ARG_H*/
