/************************************************************************
 ========================================================================
 CORAL 
 (c)  Copyright R. Ramakrishnan and The CORAL Group, 
 University of Wisconsin at Madison.
 (1992) All Rights Reserved.
 Version 0.1
 ========================================================================



 ------------------------------------------------------------------------
 CORAL Version 0.1
 RESEARCH SOFTWARE DISCLAIMER -------------------------------------------
 ------------------------------------------------------------------------

    As unestablished, research software, this program is provided free of 
    charge on an "as is" basis without warranty of any kind, either 
    express or implied.  Acceptance and use of this program constitutes 
    the user's understanding that (s)he will have no recourse for any 
    actual or consequential damages, including, but not limited to, 
    lost profits or savings, arising out of the use of or inability to 
    use this program.  

 ------------------------------------------------------------------------
 USER AGREEMENT ---------------------------------------------------------
 ------------------------------------------------------------------------

     BY ACCEPTANCE AND USE OF THIS EXPERIMENTAL PROGRAM
     THE USER AGREES TO THE FOLLOWING:

     a.  This program is provided free of charge for the user's personal, 
	 non-commercial, experimental use.

     b.  All title, ownership and rights to this program and any copies 
         remain with the copyright holder, irrespective of the ownership 
	 of the media on which the program resides.

     c.  The user is permitted to create derivative works to this program.  
         However, all copies of the program and its derivative works must
         contain the CORAL copyright notice, the UNESTABLISHED SOFTWARE 
         DISCLAIMER and this USER AGREEMENT.

     d.  The user understands and agrees that this program and any 
         derivative works are to be used solely for experimental purposes 
	 and are not to be sold or commercially exploited in any manner 
	 WITHOUT EXPRESS WRITTEN PERMISSION.

     e.  We request that the user supply us with a copy of any changes, 
         enhancements, or derivative works which the user may create,
	 with the user's permission to redistribute it.
	 Copies of such material should be sent to:  CORAL@CS.WISC.EDU

-------------------------------------------------------------------------
*************************************************************************/

/******************************************************

   CORAL software



     aggreg-arg.h     header file defining special classes for aggregate
                      processing, subclasses of NumArg

***********************************************************/

#ifndef CORAL_AGGREG_H
#define CORAL_AGGREG_H

#include   "arg.h"
#include   "generic-rel.h"

class AvgArg : public NumArg {

// specialization class used only by Avg aggregate to store running 
// count.

 public:

   inline AvgArg(double s) : NumArg(s) { a_count = 1; }
   inline AvgArg(int c, double s) : NumArg(s) { a_count = c; }
   inline int count() { return a_count; }

 protected:

   int  a_count;

};

class DistArg : public NumArg {

// specialization class used for count_distinct, sum_distinct, prod_distinct

 public:

   inline DistArg(double x, StorageRelation *r) : NumArg(x) { distrel = r; }
   inline DistArg(int x, StorageRelation *r) : NumArg(x) { distrel = r; }

   inline StorageRelation  *rel() { return distrel; }

 protected:

   StorageRelation  *distrel;

};

class ADistArg : public NumArg {

// specialization class used for avg_distinct

 public:

   inline ADistArg(int c, double x, StorageRelation *r) : NumArg(x) {
       a_count = c;
       distrel = r; }

   inline ADistArg(double x, StorageRelation *r) : NumArg(x) {
       a_count = 1;
       distrel = r; }

   inline int count() { return a_count; }
   inline StorageRelation  *rel() { return distrel; }

 protected:

   int a_count;
   StorageRelation *distrel;
};

#endif  // CORAL_AGGREG_H
