#include <InterViews/canvas.h> 
#include <InterViews/painter.h> 
#include <InterViews/sensor.h> 
#include <InterViews/frame.h> 
#include <InterViews/box.h> 
#include <InterViews/message.h> 
#include <InterViews/glue.h> 
#include <InterViews/streditor.h> 
#include <InterViews/button.h> 
#include <InterViews/perspective.h> 
#include "Selecter.h"
#include <InterViews/2.6/_enter.h>


typedef void (Selecter_core::*Selecter_core_BFunc)();

class Selecter_core_Button : public ButtonState {
public:
    Selecter_core_Button(
	int, Selecter_core* = nil, Selecter_core_BFunc = nil
    );
    virtual void Notify();
private:
    Selecter_core_BFunc _func;
    Selecter_core* _coreclass;
};

Selecter_core_Button::Selecter_core_Button(
    int i, Selecter_core* coreclass, Selecter_core_BFunc f
) : ButtonState(i) {
    _func = f;
    _coreclass = coreclass;
}

void Selecter_core_Button::Notify() {
    ButtonState::Notify();
    if (_func != nil) {
        (_coreclass->*_func)();
    }
}

class Selecter_core_HGlue : public HGlue {
public:
    Selecter_core_HGlue(const char*, int, int, int);
protected:
    virtual void Resize();
};

class Selecter_core_VGlue : public VGlue {
public:
    Selecter_core_VGlue(const char*, int, int, int);
protected:
    virtual void Resize();
};

Selecter_core_HGlue::Selecter_core_HGlue (
    const char* name, int nat, int shr, int str) : HGlue(name, nat, shr, str) {}

void Selecter_core_HGlue::Resize () {
    HGlue::Resize();
    canvas->SetBackground(output->GetBgColor());
}

Selecter_core_VGlue::Selecter_core_VGlue (
    const char* name, int nat, int shr, int str) : VGlue(name, nat, shr, str) {}

void Selecter_core_VGlue::Resize () {
    VGlue::Resize();
    canvas->SetBackground(output->GetBgColor());
}

Selecter_core::Selecter_core(const char* name) {
    perspective = new Perspective;
    SetInstance(name);
    if (input != nil) {
        input->Unreference();
    }
    input = allEvents;
    input->Reference();
    Insert(Interior());
}

Interactor* Selecter_core::Interior() {
    enterBS1 = new Selecter_core_Button(0, this, &Selecter_core::entered1);
    enterBS3 = new Selecter_core_Button(0, this, &Selecter_core::entered3);
    enterBS2 = new Selecter_core_Button(0, this, &Selecter_core::entered2);
    Frame* _Frame_186 = new Frame("_instance_165", nil, 2);
    MarginFrame* _MarginFrame_185 = new MarginFrame("_instance_164", nil, 39, 1000000, 1000000, 62, 1000000, 1000000);
    VBox* _VBox_184 = new VBox();
    Message* _Message_166 = new Message("_instance_145", "Please Enter the Desired Pattern:", Center);
    VGlue* _VGlue_167 = new Selecter_core_VGlue("_instance_146", 13, 13, 0);
    Frame* _Frame_169 = new Frame("_instance_148", nil, 2);
    stringEditor = new StringEditor("_instance_147", enterBS1, "                                               ");
    stringEditor->Message("");
    _Frame_169->Insert(stringEditor);
    VGlue* _VGlue_170 = new Selecter_core_VGlue("_instance_149", 18, 18, 0);
    HBox* _HBox_183 = new HBox();
    enterButton3 = new PushButton("_instance_150", "Help", enterBS3, 1);
    HGlue* _HGlue_178 = new Selecter_core_HGlue("_instance_157", 27, 27, 1000000);
    enterButton2 = new PushButton("_instance_152", " All ", enterBS2, 1);
    HGlue* _HGlue_179 = new Selecter_core_HGlue("_instance_158", 23, 23, 1000000);
    enterButton1 = new PushButton("_instance_153", "Enter", enterBS1, 1);
    _HBox_183->Insert(enterButton3);
    _HBox_183->Insert(_HGlue_178);
    _HBox_183->Insert(enterButton2);
    _HBox_183->Insert(_HGlue_179);
    _HBox_183->Insert(enterButton1);
    _VBox_184->Insert(_Message_166);
    _VBox_184->Insert(_VGlue_167);
    _VBox_184->Insert(_Frame_169);
    _VBox_184->Insert(_VGlue_170);
    _VBox_184->Insert(_HBox_183);
    _MarginFrame_185->Insert(_VBox_184);
    _Frame_186->Insert(_MarginFrame_185);
    return _Frame_186;
};

void Selecter_core::entered1() {}
void Selecter_core::entered3() {}
void Selecter_core::entered2() {}

