// This may look like C code, but it is really -*- C++ -*-

/**********************************************************************
    File Name: The Node Class
    Author:    Bill Roth(387-820-7277)
    Date:      Tue Nov 17 22:39:13 1992 @ feline
    File:      /var/home/roth/code/iv/if/Node.c
    Comments:  code for the node class. The node is the collection of
    graphical bits that comprise a box on the screen

**********************************************************************/

#include <memory.h>
#include <Unidraw/Graphic/geomobjs.h>
#include <Unidraw/Graphic/graphic.h>
#include <Unidraw/Graphic/grblock.h> 
#include <Unidraw/Graphic/lines.h> 
#include <Unidraw/Graphic/picture.h> 
#include <Unidraw/Graphic/polygons.h>

#include <Unidraw/Components/text.h>

#include <InterViews/defs.h>
#include <InterViews/transformer.h>
#include <InterViews/event.h>

#include "Node.h"
#include "Derivation.h"
#include "coral-includes.h"

#include <stream.h>
#include <assert.h>

/**********************************************************************
   Inputs: the rect and text graphic to copy from
  Outputs: Node(its a constructor)
 Added By: Bill Roth/Tue Nov 17 22:39:44 1992
 Comments: Constructor. This depends on copyrect, and copytext, which should
 be templates. {left,right}offset represent the width offsets of the 
 template node
**********************************************************************/

Node::Node(SF_Rect *copyRect,TextGraphic *copyText,const char *s,Arg* a,
	   Derivation *deriv,
	   int rightOffset,int leftOffset)
{
#define MARGIN 6
  Coord l,b,r,t;
  Coord textLength,boxLength;
  BoxObj tbox,bbox;
  
  text = new TextGraphic(s,12,copyText);
  Transformer *tr = new Transformer(copyText->GetTransformer());
  text->SetTransformer(tr);
  text->GetBox(tbox);
  textLength = tbox._right - tbox._left; // get graphic length
  
  copyRect->GetOriginal(l,b,r,t);
  copyRect->GetBox(bbox);	
  boxLength = r - l;

  if(boxLength > textLength) { // if text is smaller than box
    diffOff = boxLength - textLength - MARGIN;
    rect = new SF_Rect(l,b,r-diffOff,t,copyRect);
  } else {
    diffOff = textLength - boxLength + MARGIN;
    rect = new SF_Rect(l,b,r+diffOff,t,copyRect);
  }
  
  Transformer *rectTr = new Transformer(copyRect->GetTransformer());
  rect->SetTransformer(rectTr);
  
  rect->Align(Center,text,Center);

  derivation = deriv;
  arg = a;
  line = 0;	
  string = s;
}
/**********************************************************************
 Added By: Bill Roth/Wed Nov 18 09:53:15 1992
 Comments: destructor for class
**********************************************************************/

Node::~Node()
{
  delete rect;
  delete text;
  delete line;
}
/**********************************************************************
   Inputs: void
  Outputs: Coord
 Added By: Bill Roth/Fri Dec  4 00:27:44 1992
 Comments: returns the length of the box.
**********************************************************************/

Coord Node::length()
{
  Coord l,b,r,t;
  rect->GetOriginal(l,b,r,t);
  
  return(r-l);
}
/**********************************************************************
   Inputs: the deltas for the x,y wrt the transformer of the rect
  Outputs: move the box.
 Added By: Bill Roth/Tue Nov 17 22:40:13 1992
 Comments: 
**********************************************************************/
void Node::Translate(int dx,int dy)
{
  tdx = dx;tdy = dy;        // save the translation values
  rect->Translate(dx,dy);
  text->Translate(dx,dy);

}
/**********************************************************************
   Inputs: The graphic block
  Outputs: void
 Added By: Bill Roth/Tue Nov 17 22:41:35 1992
 Comments: insert rect and text into graphicBlock
**********************************************************************/

void Node::InsertIntoGraphicBlock(GraphicBlock* g)
{
  assert(rect);
  assert(text);

  (g->GetGraphic())->Append(rect);
  (g->GetGraphic())->Append(text);
  if(line !=0)
    (g->GetGraphic())->Append(line);
  
}
/**********************************************************************
   Inputs: The graphic block to draw into
  Outputs: insert the things into the gb
 Added By: Bill Roth/Tue Nov 17 22:53:26 1992
 Comments: 
**********************************************************************/
void Node::RemoveFromGraphicBlock(GraphicBlock*g)
{
  (g->GetGraphic())->Remove(rect);
  (g->GetGraphic())->Remove(text);
  if(line != 0)
    (g->GetGraphic())->Remove(line);
  
}
/**********************************************************************
   Inputs: the event
  Outputs: 1 if is a hit 0 if otherwise.
 Added By: Bill Roth/Tue Nov 17 22:51:02 1992
 Comments: 
**********************************************************************/

boolean Node::isHit(Event &event)
{
  BoxObj box;
  PointObj pt(event.x,event.y);
  
  rect->GetBox(box);

  return box.Contains(pt);
    
}
void Node::GetBox(Coord &l,Coord &b,Coord &r,Coord &t)
{
  rect->GetBox(l,b,r,t);
}
/**********************************************************************
   Inputs: The index, the number of nodes being drawn, and the position of the root box
  Outputs: draw a line between the root box and the child.
 Added By: Bill Roth/Wed Nov 18 08:59:58 1992
 Comments: 
**********************************************************************/

void Node::DrawLine()
{
  Coord l,b,r,t;
  Node* parentNode;
  if(tdx==0 && tdy==0)
    return;
  
  rect->GetOriginal(l,b,r,t);
  if(derivation->isroot() )
    parentNode = derivation->getFirstNode();
  else
    parentNode = (derivation->getParent())->getNodeWithChildren();

  int lengthDiff = parentNode->length()/2 - length()/2;
	//
  // make the line from the middle of our top to the mid of the
  // bottom of where we came from
	//
  line = new Line((l+r)/2,t,(l+r)/2-tdx+lengthDiff,b-tdy,rect);
  Transformer *tr = new Transformer(rect->GetTransformer());
  line->SetTransformer(tr);
}
