//#include <stdio.h>
//#include <strings.h>
//#include "coral-includes.h"


static void _CORAL_dummytemp__13(); 
static void temp__12();

static char __CORAL_BUILTIN_FAIL = 0;
// This may look like C code, but it is really -*- C++ -*-

/**********************************************************************
    File Name: Module Window
    Author:    Bill Roth(387-820-7277)
    Date:      Wed Dec 16 22:19:02 1992 @ feline
    File:      /var/home/roth/code/iv/if/ModuleWindow.c
    Comments:  This is the code for the module window class. This is the
    window where the derivations are displayed.
**********************************************************************/

#include <memory.h>
#include <InterViews/button.h>
#include <InterViews/canvas.h> 
#include <InterViews/painter.h> 
#include <InterViews/sensor.h> 
#include <InterViews/perspective.h> 
#include <InterViews/defs.h>
#include <InterViews/event.h>
#include <InterViews/frame.h>
#include <InterViews/menu.h>
#include <InterViews/interactor.h>
#include <InterViews/message.h>
#include <InterViews/panner.h>
#include <InterViews/strbrowser.h>
#include <InterViews/transformer.h>
#include <InterViews/world.h>
#include <InterViews/streditor.h>
#include <InterViews/2.6/_enter.h>

#include <Unidraw/catalog.h>
#include <Unidraw/creator.h>
#include <Unidraw/Graphic/grblock.h> 
#include <Unidraw/Graphic/graphic.h> 
#include <Unidraw/Graphic/polygons.h> 
#include <Unidraw/Graphic/picture.h> 

#include <Unidraw/unidraw.h>
#include <Unidraw/globals.h>
#include <Unidraw/uarray.h>
#include <Unidraw/dialogs.h>	/* dialog stuff defined here */

#include <Unidraw/Components/text.h> 

#include "Coral.h"
#include "Derivation.h"
#include "MainWindow.h"
#include "ModuleWindow.h"
#include "Node.h"
#include "Selecter.h"
#include "Helper.h"
#include "coral-includes.h"

#ifndef __GNUG__
#include <InterViews/2.6/_enter.h>
#endif

#include <stream.h>
#include <assert.h>
#include <sys/param.h>

#define streq(x,y) (!strcmp(x,y))

#define DEF_ARITY 2
#define USE_ARITY 2
#define NYI() doMessage("This feature is not yet implemented.","")
#define EXPLAIN_FOO "explain__foo"

char selected[100];
int childpid, pipe1[2], pipe2[2];
World* w;
Selecter* a1;
Helper* a2;
FILE *sourcefile;

Helper::Helper(const char* name) : Helper_core(name) {};

void Helper::CB_entered() {
     w->Remove(a2);
     delete a2;
}

Selecter::Selecter(const char* name) : Selecter_core(name) {};

void Selecter::entered1() {
    int value;
    enterBS1->GetValue(value);
    if (value != 0) {
      strcpy(selected, stringEditor->Text());
      sourcefile = (fopen("/tmp/__Select_File.F", "w"));
      fprintf(sourcefile, "explain__foo(%s).", selected);
      fclose(sourcefile);
      int n = strlen((char *) selected);
      write(pipe2[1],selected, n);
    }
    close(pipe1[0]);
    close(pipe2[1]);
    enterBS1->SetValue(0);
    w->Remove(a1);
    delete a1;
    exit(0);
  }

void Selecter::entered2() {
    int value;
    char* tmp = "ALL";
    enterBS2->GetValue(value);
    if (value != 0) {
      strcpy(selected,tmp);
    int n = strlen((char *) selected);
    write(pipe2[1],selected, n);
    }
    close(pipe1[0]);
    close(pipe2[1]);
    enterBS2->SetValue(0);
    w->Remove(a1);
    delete a1;
    exit(0);
}

void Selecter::entered3() {
    int value;
    enterBS3->GetValue(value);
    if (value != 0) { 
        enterBS3->SetValue(0);
        w->InsertApplication(a2);
    }
}


/**********************************************************************
   Inputs: The name and whether or not this is a Uses window.
  Outputs: a ModuleWindow
 Added By: Bill Roth/Thu Dec  3 12:20:40 1992
 Comments: Constructor
**********************************************************************/

ModuleWindow::ModuleWindow(const char* name,boolean Uses) : ModuleWindow_core(name), isUses(Uses)

{
  SF_Rect *big;
  Coord x,y,z,a;

  (graphicBlock->GetGraphic())->Remove(_box); // remove these from the screen
  (graphicBlock->GetGraphic())->Remove(_text); // these are only templates.
  (graphicBlock->GetGraphic())->Remove(gbRect);

  messageFrame->Remove(titleMessage);
  delete titleMessage;
  titleMessage = new Message(name,Center,14); 
  messageFrame->Insert(titleMessage);
  topDerivation = 0;
  mainWindow = 0;
  menuitems=0;
  undo = 0;
  
  _box->GetOriginal(x,y,z,a);
  Coord offset = 3000;

  big = new SF_Rect(x-offset,y-offset*2,z+offset,a);
  PSColor *white = new PSColor(1, 1, 1, "White");
  PSBrush* brush = new PSBrush(65535, 0);
  PSPattern *pat = new PSPattern(0, (float)1);
  Transformer *trans = new Transformer(_box->GetTransformer());

  big->SetBrush(brush);
  big->SetColors(white,white);
  big->FillBg(true);
  big->SetTransformer(trans);
  big->SetPattern(pat);

  (graphicBlock->GetGraphic())->Append(big);

  if(!isUses) {			// HACK
    suffix = getModuleSuffix(name);
    char *suffix_index;
    suffix_index = rindex(suffix, '/');
    if (suffix_index)
      suffix = ++suffix_index;
  } 
  if(isUses) {
    predMessFrame->Remove(predMessage);
    delete predMessage;
    predMessage = new Message("  The Predicate  ",Center,14);
    predMessFrame->Insert(predMessage);    

    instMessageFrame->Remove(instMessage);
    delete instMessage;
    instMessage = new Message("  Rules Where Used ",Center,14);
    instMessageFrame->Insert(instMessage);
  }
  
  popUp = new PopupMenu();
  menuItemList = new UArray(4);

  NodeMenuItem *mi = new NodeMenuItem("node1","Go Up 1 Level",Left);
  mi->SetCoreFunc(&Derivation::DoUp);
  popUp->Include(mi);
  menuItemList->Insert((void*)mi,menuitems++);

  mi = new NodeMenuItem("node2","Go Down 1 Level",Left);
  mi->SetCoreFunc(&Derivation::DoDown);
  popUp->Include(mi);
  menuItemList->Insert((void*)mi,menuitems++);

  mi = new NodeMenuItem("node3","Next Derivation",Left);
  mi->SetCoreFunc(&Derivation::DoNext);
  popUp->Include(mi);
  menuItemList->Insert((void*)mi,menuitems++);

  mi = new NodeMenuItem("node4","Show Where Used",Left);
  mi->SetCoreFunc(&Derivation::ShowUsed);
  popUp->Include(mi);
  menuItemList->Insert((void*)mi,menuitems++);

  unique_def = 0;
  unique_use = 0;
  if(!isUses)
    showPredNames();
}
/**********************************************************************
   Inputs: void
  Outputs: 
 Added By: Bill Roth/Sat Nov 28 19:39:16 1992
 Comments: the destructor
**********************************************************************/

ModuleWindow::~ModuleWindow()
{
  delete popUp;

  for(int i=0;i<menuItemList->Count();i++){
    NodeMenuItem *n = (NodeMenuItem*)(*menuItemList)[i];
    delete n;
  } 
  delete menuItemList;
  delete suffix;
}
/**********************************************************************
   inputs: two strings. 
  outputs: void
 added by: bill roth/wed oct  7 10:31:26 1992
 comments: puts up a message
**********************************************************************/
void ModuleWindow::doMessage(const char* s, const char* t)
{
  AcknowledgeDialog *a = new AcknowledgeDialog(s,t);
  Coord x,y;
  
  Align(Center,0,0,x,y);
  GetRelative(x,y,GetWorld());
  GetWorld()->InsertTransient(a,this,x,y,Center);
  a->Acknowledge();
  GetWorld()->Remove(a);
  delete a;
}
/**********************************************************************
   Inputs: void
  Outputs: void
 Added By: Bill Roth/Sat Nov 28 20:41:06 1992
 Comments: Query coral to get a list of unique pred names and put them into
 the predicate browser
**********************************************************************/
void ModuleWindow::showPredNames()
{
  Relation *rel;
  char *relname = new char[1000];
  char str[100];
  int pos=0;


  sprintf(relname,"def_%s",suffix);

  rel = coral->getPredNames(relname);
  Tuple tup(make_arglist(2,make_arg(relname),make_var("X",0)));

  C_ScanDesc scan(rel,&tup);

  Tuple *tuple;

  for (tuple = scan.next_tuple(); !(scan.no_match()); tuple = scan.next_tuple()) {
    if (!is_string((*tuple)[1])) {
      fprintf(stderr, "non-string second field !\n");
      return;
    }
    pos = 0;
    ((*tuple)[1])->sprint(str,&pos);

#ifdef DEBUG
    cerr << str << '\n';
#endif DEBUG

    predicateBrowser->Append(str);
  }

  delete relname;
}
/**********************************************************************
   Inputs: an Arg to be the arg to show in the predBrowser
  Outputs: boolean
 Added By: Bill Roth/Wed Dec  2 22:29:12 1992
 Comments: set up arg for uses window and insert into pred browser, and the
 suffix to use. We set up a relation,unique, to conitain all of the rules that
 use the main predicate. its schema is (int, list). This is later used in 
 usesInstSelected(). This function returns true if there are tuples to 
 show the derivation of, else it returns false.
**********************************************************************/
boolean ModuleWindow::setUsesArg(Arg* arg, char* suff)
{
  assert(is_functor(arg));
  usesArg = arg;
  char str[300];
  int pos =0;
  
  arg->sprint(str,&pos);
  predicateBrowser->Append(str);
  char relname[300];
  suffix = suff;
  
  C_ScanDesc *scan = StartScan(arg,true); // start scan on uses relation

  if (unique_use)
    unique_use->empty_relation();	// clear unique relation
  else {
    char str[100];
    sprintf(str,"unique_use%s",suff);

#ifdef DEBUG
    cerr << "relation name is " << str << '\n';
#endif DEBUG

    unique_use = make_rel(str, 2);
  }

  instTuples = 0;
  instanceBrowser->Clear();	// clear the instance browser
  Tuple *tuple;

  // scan the uses relation for the arg
  //
  for (tuple = scan->next_tuple(); !(scan->no_match()); tuple = scan->next_tuple()) {
    Arg *attr  = (*tuple)[1];	// attr2 is the list from uses _relation
    if(!is_list(attr)) {
      cerr << "non-list 2nd field\n";
      delete tuple;
      delete scan;
      return false;
    }
    char *item = sprint_rule(attr); // put rule into the instancebrowser
    if(item) {
      instanceBrowser->Append(item); // insert the rule
      // make tuple of form (seq_no,rule_list).
      Tuple *add = make_tuple(make_arglist(2,make_arg(instTuples),attr));
      unique_use->tuple_insert(add);
#ifdef DEBUG
      add->printon(stderr);
#endif
#ifdef DEBUG
      cerr << " inserted into relation at "<< instTuples<<"\n";
#endif DEBUG

      instTuples++;
    }
  }
  delete scan;	
  if(instTuples == 0) 
    return false;
  else
    return true;
}
/**********************************************************************
   Inputs: an arglist
  Outputs: the arglist printed as a rule
 Added By: Bill Roth/Wed Dec  2 23:40:15 1992
**********************************************************************/

char* ModuleWindow::sprint_rule(Arg *list)
{
#define MAXSIZE 1024
#define IMPLIES " :- "
  char *str = new char[MAXSIZE]; // seems like a good size
  Arg *item;
  int pos = 0,count = 0;

  while(list && is_list(list) && (item = make_car(list)) && ((pos - 100) < MAXSIZE)) {
    list = make_cdr(list);
    if(count > 1) {
      str[pos++] = ',';
    }
    item->sprint(str,&pos);
    if(count ==0) {
      sprintf((char*)str+pos,IMPLIES);
      pos+=strlen(IMPLIES);
    }
    count ++;
  }
  str[pos++] = '.';
  str[pos] = 0;
  
#ifdef DEBUG
  cerr << str << '\n';
#endif DEBUG

  return str;
}
/**********************************************************************
   Inputs: the name of the module consulted
  Outputs: the suffix for the relations to be accessed
 Added By: Bill Roth/Sat Nov 28 19:31:52 1992
 Comments: allocs memory
**********************************************************************/

char* ModuleWindow::getModuleSuffix(const char* name)
{
  char *s = strnew(name);
  
  s[strlen(s)-2] = 0;
  return (char*)s;
}
/**********************************************************************
   Inputs: void
  Outputs: void
 Added By: Bill Roth/Sat Dec 19 12:31:36 1992
 Comments: Prints out the tree to a text file.
**********************************************************************/

void ModuleWindow::_TextPrint()
{
  if(topDerivation == 0) 
    return ;

  char *path = new char[MAXPATHLEN];
  
  getwd(path);

  FileChooser *fc = new FileChooser("Enter the file name that you wish to",
				    "save the output to:",
				   path,
				   20,40,
				   "Select",
				   Center);

  World* world = unidraw->GetWorld();
  
  Coord x, y ;
  Align(Center, 0, 0, x, y);
  GetRelative(x, y, world);
  world->InsertTransient(fc, this, x, y, Center);
  boolean accepted = fc->Accept();
  if(accepted) {
    char name[MAXPATHLEN];

#ifdef DEBUG
    cerr << fc->Choice() << '\n';
#endif DEBUG

    strcpy(name,fc->Choice());
    FILE *file = fopen(name,"w");
    if(!file) {
      doMessage("Cannot open file:",
		name);
    } else {
      fprintf(file,"The Derivation Tree for ");
      (topDerivation->getFirstNode())->arg->printon(file);
      fprintf(file,"\n\n");
      PrintRules((topDerivation->getFirstNode())->arg,file);
      fclose(file);
    }
  }
  world->Remove(fc);
  delete fc;
  
}
/**********************************************************************
   Inputs: the arg that is the head of the rule and the file to print it out to.
  Outputs: void
 Added By: Bill Roth/Sat Dec 19 12:57:50 1992
 Comments: 
**********************************************************************/
void ModuleWindow::PrintRules(Arg* arg,FILE* outfile)
{
  C_ScanDesc *scan = StartScan(arg); // gets a scan on the def relation
  Tuple *tuple;
  int first = 1;
  for (tuple = scan->next_tuple();!(scan->no_match());tuple = scan->next_tuple()) {
    Arg *a;
    Arg *list = make_cdr((*tuple)[1]); // don\'t need the head
    char *str = sprint_rule((*tuple)[1]);
    if(first) {
      first = 0;
      fprintf(outfile,"Derivations for ");
      arg->printon(outfile);
      fprintf(outfile,":\n");
    }
    fprintf(outfile,"%s\n",str); // print me out.
    delete str;

    while(a = make_car(list)) { // get the head of the 1st attr
      list = make_cdr(list);
      PrintRules(a,outfile);	// print out all rules for children
    }

  }
  delete scan;			// added
  return ;
}
/**********************************************************************
   Inputs: void
  Outputs: void
 Added By: Bill Roth/Sun Nov 29 09:08:53 1992
 Comments: This function is now an example. It will be disabled in the 
 final version 
**********************************************************************/

void ModuleWindow::_Print() {
  NYI();
}

/**********************************************************************
   Inputs: void
  Outputs: void
 Added By: Bill Roth/Sun Nov 22 12:53:51 1992
 Comments: close the window and delete self. Will also have to do other
 types of of cleanup here.
**********************************************************************/

void ModuleWindow::_Close() {
  World *w = GetWorld();

  w->Remove(this);
  mainWindow->windowIsClosing(this);
}
/**********************************************************************
   Inputs: void
  Outputs: void
 Added By: Bill Roth/Sun Nov 29 09:21:03 1992
 Comments: This is run from the menu. it will undo the previous change.
**********************************************************************/

void ModuleWindow::_Undo()
{
  if (!undo)
    return ;
  Derivation *d = getUndo();
  d->Redo();
  graphicBlock->Update();
}
void ModuleWindow::_Paste()
{
  NYI();
}
/**********************************************************************
   Inputs: void
  Outputs: void
 Added By: Bill Roth/Sun Nov 29 09:14:20 1992
 Comments: a line has been selected in the predBrowser. Get the string
 then query coral to get all the instances of that predicate, via the query
 ?def_(suffix)(X(Y,..),V). You need to somehow know the arity of the predicate
 in advance. Then take all of the instances and insert them into the 
 instance browser. Put only the HEADS of the rules into the instance browser.
**********************************************************************/

void ModuleWindow::predSelected() {

  char *relname,*predname;
  int state=0;

  predBrowserBS->GetValue(state);

  if(state) {			// we do this so we do not get called twice.

    if(predicateBrowser->Selections() < 1) {
      predBrowserBS->SetValue(0);
      return ;
    }
    
    if(isUses) {
      predBrowserBS->SetValue(0);
      return ;
    }

    relname = new char[1000];
    Relation *arel;
    sprintf(relname,"def_%s", suffix); 
  
    predname = predicateBrowser->String(predicateBrowser->Selection(0));

    if(strlen(predname) == 0)
      return;

#ifdef DEBUG
    cerr << predname << " is selected\n";
#endif DEBUG    

    arel = find_relation("arity",3);

#ifdef DEBUG
    cerr << "after find relation\n";
#endif DEBUG

    Tuple tup(make_arglist(3,make_arg(relname),
			   make_arg(predname),
			   make_var("XX",0)));
    
#ifdef DEBUG    
    cerr << "after find make_tuple\n";
#endif DEBUG

    C_ScanDesc ascan(arel,&tup);

#ifdef DEBUG
    cerr << "after find new scan\n";
#endif DEBUG

    Tuple *atuple = ascan.next_tuple();
#ifdef DEBUG   
    cerr << "after find next_tuple\n";
#endif
    if(ascan.no_match()) {
      cerr << "no match from from arity\n";
      predBrowserBS->SetValue(0);
      return ;
    }
    if(!is_int((*atuple)[2])) {
      cerr << "wierd answer from arity\n";
      predBrowserBS->SetValue(0);
      return ;
    }
    int arity = make_int((*atuple)[2]);

#ifdef DEBUG    
    cerr << "arity is " << arity << '\n';
#endif DEBUG


    instTuples = 0;
    instanceBrowser->Clear();
    
    Tuple *tuple, *temp_tuple;
    /********/
    if (unique_def)
       unique_def->empty_relation();
    else {
      char str[100];
      sprintf(str,"unique_def%s",suffix);

#ifdef DEBUG
      cerr << "def relation is " << suffix << '\n';
#endif DEBUG

      unique_def = make_rel(str, 2);
     }

     pipe(pipe1);
     pipe(pipe2);
     if (!(childpid = fork())) {

static PropertyData properties1[] = {
#include "Select-props"
    { nil }
};

static OptionDesc options1[] = {
    { nil }
};

     close(pipe1[1]);
     close(pipe2[0]);

     char* tmp = "Explain";
     Creator creator;
     Unidraw*  u1 = new Unidraw(
        new Catalog("/****/", &creator), 1, &tmp, options1, properties1
    ); 
     w = u1->GetWorld();
     a1 = new Selecter("_instance_1000");
     w->InsertApplication(a1);
     a2 = new Helper("_instance_1001");
     u1->Run();
     delete u1;
     u1->Run();
     delete u1;
}
 
else {
    
    // Now scan over unique instances.

    close(pipe1[0]);
    close(pipe2[1]);

    int n = read(pipe2[0],selected,100);
    selected[n] = '\0';

    close(pipe1[1]);
    close(pipe2[0]);

#ifdef DEBUG
    fprintf(stderr, "Selected string is %s\n", selected);
#endif DEBUG

    char* tmp_str = "ALL";
    if (!strcmp(selected,tmp_str)) {
      Relation* rel = find_relation("my_instances",3);
      Tuple stup(make_arglist(3,make_arg(relname),
                        make_arg(predname),
                        make_var("X1",0)));
      C_ScanDesc scan(rel,&stup);

    // Now scan over unique instances.
    for (tuple = scan.next_tuple(); !(scan.no_match()); tuple = scan.next_tuple()
) {
      Arg* arg = (*tuple)[2];
      if (!is_functor(arg)) {
        fprintf(stderr, "non-functor third field !\n");
        continue;
      }
      char str[100];
      int pos=0;
      arg->sprint(str,&pos);

#ifdef DEBUG
      tuple->printon(stderr);
#endif DEBUG
      //
      // Tarun\'s code: make an arity 2 relation. The first attr is the
      // index and the second is the functor
      temp_tuple = make_tuple(make_arglist(2, make_arg(instTuples),
                arg));
      instTuples++;
      unique_def->tuple_insert(temp_tuple);
#ifdef DEBUG
      cerr << " " << str << "at " << instTuples-1<< '\n';
#endif DEBUG
      instanceBrowser->Append(str);
    }

    predBrowserBS->SetValue(0);
}

    else {

  /* to handle CORAL code */
  extern ExecutionList temp__15;
  if (!(temp__15.initialized)) {
    temp__12();
  }
  temp__15.execute();
  processInputStack();


    unlink("/tmp/__Select_File.F");

    Relation *foo_rel = find_relation(EXPLAIN_FOO, 1);
    C_ScanDesc foo_scan(foo_rel);
    Tuple *foo_t = foo_scan.next_tuple();
    if (foo_scan.no_match()) {
      fprintf(stderr, "No value in explain_foo relation!\n");
      return;
     }

    int max_vars = (*foo_t)[0]->max_vars();
    Tuple stup(make_arglist(4,make_arg(relname),(*foo_t)[0], make_var("X1",max_vars), make_var("X2",max_vars+1)));

    foo_t->do_delete();

    Relation* rel = find_relation("instances",4);	// a loaded func
    
    C_ScanDesc scan(rel, &stup);

     
    for (tuple = scan.next_tuple(); !(scan.no_match()); tuple = scan.next_tuple()) {
      Arg* arg = (*tuple)[1];
      if (!is_functor(arg)) {
	fprintf(stderr, "non-functor third field !\n");
	continue;
      }
      char str[100];
      int pos=0;
      arg->sprint(str,&pos);

#ifdef DEBUG      
      tuple->printon(stderr);
#endif DEBUG
      //
      // Tarun\'s code: make an arity 2 relation. The first attr is the
      // index and the second is the functor
      temp_tuple = make_tuple(make_arglist(2, make_arg(instTuples),
		arg));
      instTuples++;
      unique_def->tuple_insert(temp_tuple);
#ifdef DEBUG
      cerr << " " << str << "at " << instTuples-1<< '\n';
#endif DEBUG
      instanceBrowser->Append(str);
    }
    //foo_rel->empty_relation();
    predBrowserBS->SetValue(0);
   }
  }				// if state
}
}
/**********************************************************************
   Inputs: void
  Outputs: void
 Added By: Bill Roth/Sun Nov 29 09:17:17 1992
 Comments: This is the biggie. Get the selected instance browser item, 
 make a functor by Coral::makeFunctor(). The create a tuple, and open 
 a scan descriptor. The create a Derivation, delete any pre-existing 
 derivation. initialize the derivation, Draw() and Update it.
**********************************************************************/

void ModuleWindow::instanceSelected() 
{
  int state;
  insBrowserBS->GetValue(state);
  if(state) {
    
    if(instanceBrowser->Selections() < 1) {
      insBrowserBS->SetValue(0);
      return ;
    }

    char *instname = instanceBrowser->String(instanceBrowser->Selection(0));

    if(strlen(instname)==0)
      return;


    int pos = instanceBrowser->Selection(0);

#ifdef DEBUG
    cerr << "pos is " << pos << '\n';
#endif DEBUG

    Tuple *stuple =  make_tuple(make_arglist(2, make_arg(pos),
					     make_var("DAVE", 0)));
    
    Relation *uni = (isUses ? unique_use : unique_def);
    
    C_ScanDesc *ascan  = new C_ScanDesc(uni, stuple);

    Tuple *_tuple = ascan->next_tuple(); // answers from instances

    if (ascan->no_match())
    {
      cerr << "Error: No matching tuple in unique instances\n";
      insBrowserBS->SetValue(0);
      return;
    }
    delete ascan;
#ifdef DEBUG    
    _tuple->printon(stderr);
#endif
#ifdef DEBUG
    cerr << " :" <<instname << " selected\n";
#endif DEBUG    

    if(isUses) {
      if(!is_list((*_tuple)[1])) {
	cerr << "attr2 for tuple is not a list!\n";
	if(is_functor((*_tuple)[1])) {
	  cerr << "attr 2 is a functor\n";
	}
	insBrowserBS->SetValue(0);
	return ;
      }
    }else {
      if(!is_functor((*_tuple)[1])) {
	cerr << "attr2 for tuple is not a functor!\n";
	insBrowserBS->SetValue(0);
	return ;
      }
    }

    Arg *arg = (isUses ? make_car((*_tuple)[1]) : (*_tuple)[1]);
#ifdef DEBUG
    arg->printon(stderr);
#endif
#ifdef DEBUG
    cerr << ": arg from tuple[1]\n";
#endif DEBUG

    C_ScanDesc *scan = StartScan(arg); // open scan on def to find derivations.

    Tuple* tuple = scan->next_tuple(); // get first tuple
    if(scan->no_match()) {
      insBrowserBS->SetValue(0);
      cerr << "No Match of scan on arg\n";
      delete scan;
      return ;
    }
    Arg* arglist = (*tuple)[1];	// 2nd should be a list

    if(topDerivation != 0) {	// kill anything if its already there.
      topDerivation->Erase();
      setUndo(topDerivation);
      topDerivation = 0;
    }
    
    Derivation* d = new Derivation(_box,_text,graphicBlock,this,true);
    setTopDerivation(d);
    
    d->setMenu(popUp);
    d->setMenuItemList(menuItemList);
    d->setScanDesc(scan);
    d->addTerms(arglist);

    d->Draw();
    graphicBlock->Update();
    
    insBrowserBS->SetValue(0);
  }				// state
}

/**********************************************************************
   Inputs: the arg for the scan(m.b. functor).
  Outputs: the appropriate scan descriptor
 Added By: Bill Roth/Tue Dec  1 11:23:25 1992
 Comments: Arg is either a functor or a list. If arg is a list, then get the car 
 if the list. If use is true, run query against the use_X relation. 
**********************************************************************/

C_ScanDesc* ModuleWindow::StartScan(Arg* arg,boolean use)
{
  char relname[1000];
  Arg* func;

  if(use)
    sprintf(relname,"use_%s",suffix);
  else
    sprintf(relname,"def_%s",suffix);
    
  Relation *rel = find_relation(relname,DEF_ARITY);

#ifdef DEBUG
  cerr << relname << " scan\n";
#endif DEBUG

  assert(rel);

  if(is_list(arg)) {
    func = make_car(arg);
  }
  else if(is_functor(arg)) {
    func = arg;
  } 
#ifdef DEBUG
  func->printon(stderr);
#endif
  Tuple *tup = make_tuple(make_arglist(DEF_ARITY,func,make_var("KATY",0)));
  assert(tup);
  C_ScanDesc* scan = new C_ScanDesc(rel,tup);
  assert(scan);
  return scan;
}

/**********************************************************************
   Inputs: An event
  Outputs: nothing
 Added By: Bill Roth/Sun Nov 22 16:41:28 1992
 Comments: This handles events sent to the window, This will be for 
 dealing with mousing
**********************************************************************/
void ModuleWindow::Handle(Event &e)
{
  if(e.eventType == DownEvent && topDerivation) {
    GetRelative(e.x,e.y,graphicBlock);
    topDerivation->HandleHit(e,popUp);
    return ;
  } else if(e.eventType == KeyEvent) {
    if(e.len > 0 && e.keystring[0] == 'c')
      _Close();
  }
}


static ExecutionList temp__15; 
static void temp__16(ExecutionList& exlist)
{
  /* initialization code for exlist */
  exlist.initialize(5, 0, NULL);
  ParserStruct *pstruct; int i = 0;
  /* call yyparse on ModuleWindow.P */
  for(;;i++) {
    parserStruct.rule_list = NULL;
    if (yyparse()) {
	fprintf(stderr, "yyparse error !\n");
	exit(1);
    }
    if (c_module_separator) break;
    pstruct = new ParserStruct;
    copy_structs(pstruct, parserStruct);
  /* save ParserStruct in exlist */
    exlist.add(pstruct);
  }
  c_module_separator = 0;
}
static void temp__11()
{
  FILE *fd = fopen("ModuleWindow.P", "w");

  fprintf(fd, "c_module.\n");
  fprintf(fd, "%s\n", "      consult(\"/tmp/__Select_File.F\"). "); 
  fprintf(fd, "end_c_module.\n\n");
  fclose(fd);
}
static void temp__12()
{
  temp__11();
  consultFile("ModuleWindow.P", "ModuleWindow.P");
  unlink("ModuleWindow.P");
  temp__16(temp__15);
}
static void _CORAL_dummytemp__13()
{
   BuiltinUserTupleRelation *temp__14;
}
