#ifndef ModuleWindow_core_h
#define ModuleWindow_core_h

#include <InterViews/scene.h>
#include <InterViews/window.h>
class MenuBar;
class PulldownMenu;
class MenuItem;
class Frame;
class Message;
class Panner;
class StringBrowser;
class ButtonState;
class GraphicBlock;
class SF_Rect;
class TextGraphic;

class ModuleWindow_core : public MonoScene {
public:
    ModuleWindow_core(const char*);
    virtual void _TextPrint();
    virtual void _Print();
    virtual void _Close();
    virtual void _Undo();
    virtual void _Cut();
    virtual void _Copy();
    virtual void _Paste();
    virtual void predSelected();
    virtual void instanceSelected();
protected:
    Interactor* Interior();
protected:
    ButtonState* predBrowserBS;
    ButtonState* insBrowserBS;
    MenuBar* menuBar;
    PulldownMenu* fileMenu;
    MenuItem* printDerivations;
    MenuItem* printItem;
    MenuItem* closeItem;
    Frame* messageFrame;
    Message* titleMessage;
    Frame* pannerFrame;
    Panner* thePanner;
    Frame* predMessFrame;
    Message* predMessage;
    StringBrowser* predicateBrowser;
    Frame* instMessageFrame;
    Message* instMessage;
    StringBrowser* instanceBrowser;
    Frame* gbFrame;
    GraphicBlock* graphicBlock;
    SF_Rect* gbRect;
    SF_Rect* _box;
    TextGraphic* _text;
};

#endif
