// This may look like C code, but it is really -*- C++ -*-
/**********************************************************************
    File Name: The MainWindow Class
    Author:    Bill Roth(387-820-7277)
    Date:      Wed Dec 16 20:15:31 1992 @ feline
    File:      /var/home/roth/code/iv/if/MainWindow.c
    Comments:  The class the manages the first window the user sees.

**********************************************************************/

#include <memory.h>
#include <InterViews/button.h>
#include <InterViews/defs.h>
#include <InterViews/event.h>
#include <InterViews/interactor.h>
#include <InterViews/menu.h>
#include <InterViews/strbrowser.h>
#include <InterViews/world.h>

#include <Unidraw/dialogs.h>	/* dialog stuff defined here */
#include <Unidraw/unidraw.h> 
#include <Unidraw/uarray.h>

#include "MainWindow.h"
#include "ModuleWindow.h"
#include "Coral.h"

#ifndef __GNUG__
#include <InterViews/2.6/_enter.h>
#endif

#include <sys/param.h>

#include <fstream.h>
#ifndef __GNUG__
#include <C++/stdlib.h>
#endif

#include <sys/types.h>
#include <sys/dir.h>
#include <sys/stat.h>
#include <strings.h>
#include <assert.h>

MainWindow::MainWindow(const char* name) : MainWindow_core(name) 
{
  numModules = 0;
  gclist = new UArray(8);
}

void MainWindow::_About___() {
 doMessage("Coral Derivation Visualizer",
	   "By Bill Roth and Tarun Arora");
}
/**********************************************************************
   Inputs: a string
  Outputs: void
 Added By: Bill Roth/Wed Dec  2 10:00:14 1992
 Comments: this method taks in a string. If the string is a filename, it
 puts the filename into the the moduleBrowser. If the file name is a 
 directory, it loads all of the files in the dir into the modulebrowser.
**********************************************************************/
void MainWindow::setFiles(char* filename)
{
  boolean isDir;
  char *tmp=0;
  assert(strlen(filename));

#ifdef DEBUG
  cerr << filename << '\n';
#endif DEBUG

  if(index(filename,'/')==0) {
    tmp = new char[MAXPATHLEN];
    getwd(tmp);
    strcat(tmp,"/");
    strcat(tmp,filename);
    filename = tmp;
  }
  if(fileCheck(filename,isDir)) {
    if(isDir) {
      loadDirectory(filename);
    } else {			// is file.
      moduleBrowser->Append(filename);
    }
  } 
  else {
#ifdef DEBUG   
    cerr << filename << " is not a valid filename. Ignoring\n";
#endif
  }
  if(tmp)
    delete tmp;
}
/**********************************************************************
   Inputs: the valid path for a directory
  Outputs: void
 Added By: Bill Roth/Wed Dec  2 10:12:22 1992
 Comments: This puts all the files of a directory into the module browser.
**********************************************************************/
void MainWindow::loadDirectory(char* dir)
{
  DIR* thedir = opendir(dir);
  boolean notDone = true,isDir;
  struct direct *dp;

  if(!thedir) {
    doMessage("Can not open the following directory:",dir);
    return ;
  }
  for (dp = readdir(thedir); dp != NULL; dp = readdir(thedir)) {
    char name[MAXPATHLEN];
    sprintf(name,"%s/%s",dir,dp->d_name);
    if(fileCheck(name,isDir)) {
      if(!isDir) 
	moduleBrowser->Append(name); 
      else {
#ifdef DEBUG   
	cerr << "Ignoring directory " << name << '\n';
#endif
      }
    } else {
#ifdef DEBUG   
      cerr << "file " << name << "not valid. Ignoring...\n";
#endif
    }
  }
  
  closedir(thedir);
}
/**********************************************************************
   inputs: two strings. 
  outputs: void
 added by: bill roth/wed oct  7 10:31:26 1992
 comments: puts up a message
**********************************************************************/
void MainWindow::doMessage(const char* s, const char* t)
{
  AcknowledgeDialog *a = new AcknowledgeDialog(s,t);
  Coord x,y;
  
  garbageCollect();
  Align(Center,0,0,x,y);
  GetRelative(x,y,GetWorld());
  GetWorld()->InsertTransient(a,this,x,y,Center);
  a->Acknowledge();
  GetWorld()->Remove(a);
  delete a;
}
/**********************************************************************
   Inputs: void
  Outputs: void
 Added By: Bill Roth/Sat Nov 21 17:54:06 1992
 Comments: loads list of files to consult later. Loades them inthe the 
 string browser
**********************************************************************/

void MainWindow::_LoadNewFile___() {
  char *path = new char[MAXPATHLEN];
  
  getwd(path);
  garbageCollect();

  FileChooser *fc = new FileChooser("Select a file in the directory whose",
				    "contents you wish to load",
				   path,
				   20,40,
				   "Select",
				   Center);

  World* world = unidraw->GetWorld();
  
  Coord x, y ;
  Align(Center, 0, 0, x, y);
  GetRelative(x, y, world);
  world->InsertTransient(fc, this, x, y, Center);
  boolean accepted = fc->Accept();
  if(accepted) {
    char name[MAXPATHLEN];
    char dir[MAXPATHLEN];

#ifdef DEBUG
    cerr << fc->Choice() << '\n';
#endif DEBUG

    strcpy(name,fc->Choice());
    char *last = rindex(name,'/');
    boolean isdir;
    *last = 0;
    if(fileCheck(name,isdir)) {
      loadDirectory(name);
    } else {
      doMessage("Cannot open the following directory:",
		name);
    }
  }
  world->Remove(fc);
  delete fc;
}
/**********************************************************************
   Inputs: menu click
  Outputs: void
 Added By: Bill Roth/Sat Nov 21 18:13:52 1992
 Comments: loads a single module file into the browser
**********************************************************************/

void MainWindow::_LoadModuleDump___()
{
  char *path = new char[MAXPATHLEN];
  
  garbageCollect();

  getwd(path);

  FileChooser *fc = new FileChooser("Select module file to load:","",
				    path,
				    20,40,
				   "Select",
				    Center);
  
  World* world = unidraw->GetWorld();
  
  Coord x, y ;
  Align(Center, 0, 0, x, y);
  GetRelative(x, y, world);
  world->InsertTransient(fc, this, x, y, Center);
  boolean accepted = fc->Accept();
  boolean isDir;
  if(accepted && fileCheck(fc->Choice(),isDir)) {
    if(isDir) {
      doMessage("The file you have selected is a directory.",
		"Please select a dump FILE.");
      
    } else {
      moduleBrowser->Append(fc->Choice());
      numModules++;
    }
  } else {
    doMessage("The file you have chosen does not appear to be",
	      "a Coral file. Please choose another.");
  }
  world->Remove(fc);
  delete path;
  delete fc;
  
}
/**********************************************************************
   Inputs: void
  Outputs: void
 Added By: Bill Roth/Sat Nov 21 18:13:00 1992
 Comments: Quits and should delete things of possible
**********************************************************************/

void MainWindow::_Quit() {
  exit(0);
}
/**********************************************************************
   Inputs: a menu selection
  Outputs: nothing
 Added By: Bill Roth/Sat Nov 21 18:11:57 1992
 Comments: gets the selected file consulted.
**********************************************************************/

void MainWindow::_Consult() {
  garbageCollect();
  LoadType t = consult;
  loadModuleFiles(t);
}
/**********************************************************************
   Inputs: a menu selection
  Outputs: nothing
 Added By: Bill Roth/Sat Nov 21 18:11:57 1992
 Comments: gets the selected file reconsulted.
**********************************************************************/

void MainWindow::_ReConsult() {
  garbageCollect();
  LoadType t = reconsult;
  loadModuleFiles(t);
}
void MainWindow::_ShowSelectedModules___()
{
  for(int i=0;i<moduleBrowser->Selections();i++){
    coral->Consult(moduleBrowser->String(moduleBrowser->Selection(i)));
    ShowDump(moduleBrowser->Selection(i));
  } 
  return ;
}
void MainWindow::_RemoveSelectedModules()
{
  for(int i=0;i<moduleBrowser->Selections();i++){
    moduleBrowser->Remove(moduleBrowser->Selection(i));
  } 
}
void MainWindow::_ClearAllModules()
{
  moduleBrowser->Clear();
}
void MainWindow::modulesSelected() {
  int state;
#ifdef DEBUG   
  cerr << "Modules selected\n";
#endif
  moduleBrowserBS->GetValue(state);
  if(state) {
#ifdef DEBUG   
    cerr << "Modules selected state = 1\n";
#endif
    _ShowSelectedModules___();
    moduleBrowserBS->SetValue(0);
  }
}

void MainWindow::loadModuleFiles(LoadType& type)
{
				// ignore type for now.
  for(int i=0;i<moduleBrowser->Selections();i++){
    cerr << moduleBrowser->String(moduleBrowser->Selection(i)) << '\n';
    int err = coral->Consult(moduleBrowser->String(moduleBrowser->Selection(i)));
#ifdef DEBUG
    cerr << err << " returned from coral consultFile\n";
#endif
  } 
  
}
/**********************************************************************
   Inputs: a path name
  Outputs: 1 if a good file, 0 if not.
 Added By: Bill Roth/Sat Nov 21 18:03:11 1992
 Comments: This merely checks for the files existance, not for read/write 
 access.
**********************************************************************/

int MainWindow::fileCheck(const char *path,boolean &isDir)
{
  struct stat buf;
  isDir = false;

  if(stat(path,&buf)==0) {
    if(buf.st_mode & S_IFDIR) {
      isDir = true;
    } else if(buf.st_mode & S_IFREG) {
      isDir = false;
      return isCoralFile(path);
    } else 
      return 0;			// wierd kind of file.
    return 1;
  } else
    return 0;
}
/**********************************************************************
   Inputs: the path name
  Outputs: 1 if coral file 0 if not.
 Added By: Bill Roth/Fri Dec 11 13:10:23 1992
 Comments: This looks for the word "coral" on the first line.
**********************************************************************/
boolean MainWindow::isCoralFile(const char *path)
{
  char str[80];

  ifstream inFile(path);

  if(inFile.bad()) {
    inFile.close();
    return false;
  }
  inFile.width(sizeof(str));
  inFile >> str;
  inFile.close();
  if(!strncmp(str,CORAL_FILE,strlen(CORAL_FILE)))
    return true;
  else 
    return false;

  
}
/**********************************************************************
   Inputs: integer position in the stribng browser
  Outputs: nothing
 Added By: Bill Roth/Sat Nov 21 18:19:14 1992
 Comments: this will bring up the window of the dump if it isnt up already

**********************************************************************/

void MainWindow::ShowDump(int i)
{

#ifdef DEBUG     
  cerr << "show dump\n";
#endif
  ModuleWindow *mod = new ModuleWindow(moduleBrowser->String(i));

  World *w = unidraw->GetWorld();
 
  mod->setMainWindow(this);
  w->InsertApplication(mod);
}
/**********************************************************************
   Inputs: the module window to be closed
  Outputs: void
 Added By: Bill Roth/Sun Nov 22 13:38:44 1992
 Comments: This should put the windw into something so that it can be GC\'d
 at some point. Currently, only GCs ModuleWindows.
**********************************************************************/

void MainWindow::windowIsClosing(ModuleWindow *m)
{
  gclist->Insert((void*)m,gclist->Count());
  return ;
}
/**********************************************************************
   Inputs: void
  Outputs: void
 Added By: Bill Roth/Sun Nov 22 14:17:46 1992
 Comments: deletes all the windows in the gclist;
**********************************************************************/

void MainWindow::garbageCollect()
{
  int i,count = gclist->Count();

  if(count > 0) {

#ifdef DEBUG
  cerr << "Garbage being collected\n";
#endif

    for(i=0;i<count;i++){
      ModuleWindow *m = (ModuleWindow*)((*gclist)[i]);
      delete m;
    } 
  gclist->Clear();
  }
}

/**********************************************************************
   Inputs: The event
  Outputs: void
 Added By: Bill Roth/Mon Nov 23 11:53:43 1992
 Comments: Handle events
**********************************************************************/
void MainWindow::Handle(Event& e)
{
  if(e.eventType == KeyEvent && e.len == 1 && e.keystring[0] == 'q') {
    exit(0);
  }
}




