#include <InterViews/canvas.h> 
#include <InterViews/painter.h> 
#include <InterViews/sensor.h> 
#include <InterViews/frame.h> 
#include <InterViews/box.h> 
#include <InterViews/message.h> 
#include <InterViews/glue.h> 
#include <InterViews/button.h> 
#include <InterViews/perspective.h> 
#include "Helper.h"
#include <InterViews/2.6/_enter.h>


typedef void (Helper_core::*Helper_core_BFunc)();

class Helper_core_Button : public ButtonState {
public:
    Helper_core_Button(
	int, Helper_core* = nil, Helper_core_BFunc = nil
    );
    virtual void Notify();
private:
    Helper_core_BFunc _func;
    Helper_core* _coreclass;
};

Helper_core_Button::Helper_core_Button(
    int i, Helper_core* coreclass, Helper_core_BFunc f
) : ButtonState(i) {
    _func = f;
    _coreclass = coreclass;
}

void Helper_core_Button::Notify() {
    ButtonState::Notify();
    if (_func != nil) {
        (_coreclass->*_func)();
    }
}

class Helper_core_HGlue : public HGlue {
public:
    Helper_core_HGlue(const char*, int, int, int);
protected:
    virtual void Resize();
};

class Helper_core_VGlue : public VGlue {
public:
    Helper_core_VGlue(const char*, int, int, int);
protected:
    virtual void Resize();
};

Helper_core_HGlue::Helper_core_HGlue (
    const char* name, int nat, int shr, int str) : HGlue(name, nat, shr, str) {}

void Helper_core_HGlue::Resize () {
    HGlue::Resize();
    canvas->SetBackground(output->GetBgColor());
}

Helper_core_VGlue::Helper_core_VGlue (
    const char* name, int nat, int shr, int str) : VGlue(name, nat, shr, str) {}

void Helper_core_VGlue::Resize () {
    VGlue::Resize();
    canvas->SetBackground(output->GetBgColor());
}

Helper_core::Helper_core(const char* name) {
    perspective = new Perspective;
    SetInstance(name);
    if (input != nil) {
        input->Unreference();
    }
    input = allEvents;
    input->Reference();
    Insert(Interior());
}

Interactor* Helper_core::Interior() {
    CB_state = new Helper_core_Button(0, this, &Helper_core::CB_entered);
    Frame* _Frame_230 = new Frame("_instance_213", nil, 2);
    MarginFrame* _MarginFrame_231 = new MarginFrame("_instance_214", nil, 37, 1000000, 1000000, 39, 1000000, 1000000);
    VBox* _VBox_232 = new VBox();
    VBox* _VBox_250 = new VBox();
    Message* _Message_233 = new Message("_instance_216", "The possible search patterns look like:", Center);
    VGlue* _VGlue_234 = new Helper_core_VGlue("_instance_217", 16, 16, 1000000);
    Message* _Message_235 = new Message("_instance_218", "                anc_bf(1,X)                    ", Center);
    VGlue* _VGlue_236 = new Helper_core_VGlue("_instance_219", 18, 18, 1000000);
    Message* _Message_237 = new Message("_instance_220", "                anc_bf(X,21)  or             ", Center);
    VGlue* _VGlue_238 = new Helper_core_VGlue("_instance_221", 16, 16, 1000000);
    Message* _Message_239 = new Message("_instance_222", "                anc_bf(X,Y)                  ", Center);
    VGlue* _VGlue_240 = new Helper_core_VGlue("_instance_223", 17, 17, 1000000);
    HBox* _HBox_248 = new HBox();
    HGlue* _HGlue_249 = new Helper_core_HGlue("_instance_233", 169, 169, 1000000);
    Cancel_button = new PushButton("_instance_234", "Cancel", CB_state, 1);
    _HBox_248->Insert(_HGlue_249);
    _HBox_248->Insert(Cancel_button);
    _VBox_250->Insert(_Message_233);
    _VBox_250->Insert(_VGlue_234);
    _VBox_250->Insert(_Message_235);
    _VBox_250->Insert(_VGlue_236);
    _VBox_250->Insert(_Message_237);
    _VBox_250->Insert(_VGlue_238);
    _VBox_250->Insert(_Message_239);
    _VBox_250->Insert(_VGlue_240);
    _VBox_250->Insert(_HBox_248);
    _VBox_232->Insert(_VBox_250);
    _MarginFrame_231->Insert(_VBox_232);
    _Frame_230->Insert(_MarginFrame_231);
    return _Frame_230;
};

void Helper_core::CB_entered() {}

