// This may look like C code, but it is really -*- C++ -*-
#include <memory.h>
#include <Unidraw/catalog.h> 
#include <Unidraw/unidraw.h> 
#include <Unidraw/creator.h> 
#include <InterViews/canvas.h> 
#include <InterViews/painter.h> 
#include <InterViews/sensor.h> 
#include <InterViews/world.h> 
#include <InterViews/box.h> 
#include <InterViews/perspective.h> 
#include "MainWindow.h"
#include "ModuleWindow.h"
#include "Coral.h"

#ifndef __GNUG__
#include <InterViews/2.6/_enter.h>
#endif

#include <stdio.h>

extern "C" {
  extern int optind,opterr;
  extern char* optarg;
};

static PropertyData properties[] = {
#include "Explain-props"
    { nil }
};

static OptionDesc options[] = {
    { nil }
};

Coral *coral;

int main (int argc, char** argv) {
    Creator creator;
    Unidraw* unidraw = new Unidraw(
        new Catalog("Explain", &creator), argc, argv, options, properties
    );
    World* w = unidraw->GetWorld();
    MainWindow* mainWindow = new MainWindow("_instance_78");
    int c;
    opterr = 0;
    while ((c = getopt (argc, argv, "f:")) != EOF)
      switch (c) {
      case 'f':
        char* file = optarg;;
	mainWindow->setFiles(file);
	break;
      default:
	break;			// do nothing.
      }

    w->InsertApplication(mainWindow);
    coral = new Coral();
    unidraw->Run();
    delete coral;		/* delete coral */
    delete unidraw;
    return 0;
}
