// This may look like C code, but it is really -*- C++ -*-

/**********************************************************************
    File Name: Derivation class code
    Author:    Bill Roth(387-820-7277)
    Date:      Tue Nov 17 22:17:27 1992 @ feline
    File:      /var/home/roth/code/iv/if/Derivation.c
    Comments:  Not this does only drawing. Updates must be done from application

**********************************************************************/
#include <memory.h>
#include <Unidraw/uarray.h>
#include <Unidraw/Graphic/polygons.h>
#include <Unidraw/Graphic/grblock.h> 
#include <Unidraw/Graphic/graphic.h> 
#include <Unidraw/Components/text.h>

#include <InterViews/menu.h>
#include <InterViews/world.h> 
#include <InterViews/interactor.h>

#include "Derivation.h"
#include "ModuleWindow.h"
#include "Node.h"
#include "coral-includes.h"

#include <stream.h>
#include <assert.h>

/**********************************************************************
 Added By: Bill Roth/Tue Nov 17 22:21:28 1992
 Comments: Constructor for Derivation
**********************************************************************/
Derivation::Derivation(SF_Rect *theBox,TextGraphic *theText,
		       GraphicBlock *gb,ModuleWindow *m,boolean root)
{
  box = theBox;
  text = theText;
  block = gb;
  nodeList = new UArray(); 
  list = new UArray();
  argsList = new UArray();
  termPos = 0;
  childPos =-1;
  child=0;
  parent=0;
  menu=0;
  menuItemList=0;
  selectedNode=0;
  isRoot = root;
  window = m;
  scan = 0;
}
/**********************************************************************
 Added By: Bill Roth/Tue Nov 17 22:21:44 1992
 Comments: Destructor for derivation. Recursively deletes all children
**********************************************************************/

Derivation::~Derivation()
{
  if(onScreen)
    Erase();			// remove from screen

  if(child)
    delete child;		// kill storage

  for(int i=0;i<nodeList->Count();i++){
    Node* node = (Node*)(*nodeList)[i];
    delete node;
  } 
  delete list;
  delete nodeList;
  delete argsList;

}
void Derivation::InsertTerm(const char *s,Arg *a)
{
  assert(list);
  assert(argsList);
  assert(a);
  
  list->Insert((void*)s,termPos);
  argsList->Insert((void*)a,termPos++);
}
/**********************************************************************
 Added By: Bill Roth/Tue Nov 17 22:22:02 1992
 Comments: Draws the derivations. If the Derivation is being redrawn,
 after an Undo, assume that you want the entire subtree redrawn.
**********************************************************************/

void Derivation::Draw()
{
  Node *node;
  int count;

#define DROP -120
#define SPACE 15

  if((count = list->Count()) == 0) // if node nodes, whats the point.
    return ;
  
  assert(list->Count() == argsList->Count());

  onScreen = true;

  if(nodeList->Count() > 0) {	// draw again
    int ncount = nodeList->Count();
    for(int i=0;i<ncount;i++){
      Node* node = (Node*)(*nodeList)[i];
      node->InsertIntoGraphicBlock(block);
    } 
    if(child)			// re-draw the child if necessary
      child->Draw();
  } else {
    int i,len=0,xoffset; 
    
    for(i=0;i<count;i++){
      const char* str = (const char*)(*list)[i];
      Arg* arg = (Arg*) (*argsList)[i];
      
      if(isRoot) 
	node = new Node(box,text,str,arg,this); // make the node
      else {
	assert(parentNode);
	node = new Node(box,text,str,arg,this,parentNode->lOff,parentNode->rOff); 
      }
      
      nodeList->Insert(node,i);		 // put in list
      if(isRoot && i == 0) 
	;
      else
	len += node->length();	// the the total length of the nodes
    }

    len += ((count - (isRoot ? 2: 1)) * SPACE); // total length

    Node *top = (Node*)( isroot() ? (*nodeList)[0] : parent->getNodeWithChildren());

    xoffset = -(len/2 - (top->length())/2);   // offset from midpoint of the top box

    for(i=0;i<count;i++){	  // dont xlate root.
      node = (Node*)(*nodeList)[i];
      if(!(isRoot && i==0)) {		// if not root, dont move and no line.
	node->Translate(xoffset,DROP);
	xoffset += (node->length() + SPACE);
	node->DrawLine();
      }
      node->InsertIntoGraphicBlock(block);
    } 
  }				// if count = 0
}				// home
/**********************************************************************
   Inputs: void
  Outputs: void
 Added By: Bill Roth/Wed Nov 18 09:40:52 1992
 Comments: erase the nodes
**********************************************************************/
void Derivation::Erase()
{
  if(child) {
    child->Erase();		// first erase all children
  }
  onScreen = false;

  for(int i=0;i<nodeList->Count();i++){
    Node* node = (Node*)(*nodeList)[i];
    node->RemoveFromGraphicBlock(block);
  }
}
/**********************************************************************
   Inputs: void
  Outputs: put this derivation where it belongs
 Added By: Bill Roth/Thu Nov 26 12:36:44 1992
 Comments: Called from ModuleWindow.
**********************************************************************/
void Derivation::Redo()
{
  Derivation *other;
  if(isroot()) {		// if I was a root.
    other = window->topDerivation; // get the current root
    assert(other);
    other->Erase();		   // erase it
    window->setTopDerivation(this); // set me up in my old digs
    window->setUndo(other,false); // false so I dont erase myself
  } else {			// I\'m a child
    if(other = parent->getChild()) { // get current child
      other->Erase();		// erase old child
      window->setUndo(other,false); // save as undo, not deleting.
    }else {
      window->setUndo(0,false); // if not child, set to 0.
    }
    parent->setChild(this,parentNode); // put me in place
  }
  Draw();			// redraw me.
}
/**********************************************************************
   Inputs: the dtervation to set as child
  Outputs: the node that the new derivation shouwl hand from.
 Added By: Bill Roth/Thu Nov 26 12:48:57 1992
 Comments: called when a node is being reattached as part of and Undo.
**********************************************************************/

void Derivation::setChild(Derivation* d,Node *n)
{
  child = d;
  childPos = nodeList->Index((void*)n);
  assert(childPos != -1);	// bomb if we cannot find the node
}
/**********************************************************************
   Inputs: The mouse down event
  Outputs: void
 Added By: Bill Roth/Mon Nov 23 16:26:32 1992
 Comments: pass mousedown coords to all the nodes and match
**********************************************************************/

void Derivation::HandleHit(Event &e,PopupMenu *menu)
{
  for(int i=0;i<nodeList->Count();i++){
    Node* node = (Node*)(*nodeList)[i];
    if(node->isHit(e)) {
      ShowMenu(e,node);
      return ;
    }
  }
  if(child !=0) {
    child->HandleHit(e,menu);
  }
}
/**********************************************************************
   Inputs: void
  Outputs: void
 Added By: Bill Roth/Tue Dec  1 19:29:12 1992
 Comments: Handle Up message from popup menu
**********************************************************************/

void Derivation::DoUp()
{
  if(window->topDerivation == this) {
    window->doMessage("Cannot go up on the top node.","");
    return ;
  }
  Erase();
  parent->child = 0;
  parent->childPos = -1;
  window->setUndo(this);
  block->Update();
}
/**********************************************************************
   Inputs: void
  Outputs: void
 Added By: Bill Roth/Tue Dec  1 19:29:12 1992
 Comments: Handle Down message from popup menu
**********************************************************************/

void Derivation::DoDown()
{
  if(this == window->topDerivation)
    if((Node*)(*nodeList)[0] == selectedNode) {
      window->doMessage("You can not go down from the top node.",
			"Choose one of the leaves instead.");
      return;
    }

  if(!is_functor(selectedNode->arg)) {
    window->doMessage("Can only show derivations for functors","");
  }
  if((*nodeList)[childPos] == (void*)selectedNode) {
    window->doMessage("This node has already been expanded into its derivations.","");
    return ;
  }
  if(!child) {
    makeSubTree(selectedNode);	// we dony care if fails here
  } else {
    Derivation *save = child;
    int savepos = childPos;
    child->Erase();
    child=0;
    childPos=-1;
    if(makeSubTree(selectedNode)) {
      window->setUndo(save);
    } else {			// make subtree failed.
      childPos = savepos;
      child = save;
      child->Draw();
    }
  }
}
/**********************************************************************
   Inputs: void
  Outputs: void
 Added By: Bill Roth/Tue Dec  1 19:29:12 1992
 Comments: Handle Down message from popup menu. You must click on the parent
 node in order to see the next, not the child.
**********************************************************************/

void Derivation::DoNext()
{
  // if I\'m the top derivation erase myself and create a new top derivation.
  //
  if(this == window->topDerivation &&
     nodeList->Index((void*)selectedNode) == 0) { // if root node
    if(scan == 0) {
      window->doMessage("You can not see the next derivation for this node.",
			"It has been invalidated by an Undo.");
      return ;
    }
    Tuple *tuple = scan->next_tuple();
    if(scan->no_match()) {
      window->doMessage("No more derivations!","");
      return ;
    }
    Erase();					    // erase me and kids
    Derivation *newd = new Derivation(box,text,block,window,true);
    window->setTopDerivation(newd);
    newd->setMenu(menu);
    newd->setMenuItemList(menuItemList);
    newd->setScanDesc(scan);
    //now set the args
    window->setUndo(this);
    scan=0;
    newd->addTerms((*tuple)[1]);
      newd->Draw();
    block->Update();
    return ;
  }
  // if the node I\'ve clicked on does not have a derivation hanging
  // from it, it is the wrong node.
  //
  if(selectedNode != (Node*)(*nodeList)[childPos] || !child) {
    window->doMessage("This node has no derivations.",
      "Please choose another node that has a derivation hanging from it.");
    return ;
  }   
  if(child->scan==0 && this != window->topDerivation) {
    window->doMessage("There is no Next on this Derivation",
			"This scan descriptor has been invalidated by an Undo.");
    return ;
  }
  // if there are no more tuples, say so.
  if(child->scan->no_match()) {
    window->doMessage("No more derivations","");
    return;
  }
  //
  // if I get here then it must tbe the normal case.
  //
  Derivation *save = child;
  child->Erase();
  child = 0;
  if(makeSubTree(selectedNode,save->scan))
    window->setUndo(save);
  else {
    child = save;
    child->Draw();// should update here
    //block->Update();
  }
}

/**********************************************************************
   Inputs: a node
  Outputs: void
 Added By: Bill Roth/Wed Nov 25 16:32:11 1992
 Comments: makes a subtree of a random number of nodes. The caller is 
 is responsible for checking that child is nul.
**********************************************************************/
boolean Derivation::makeSubTree(Node *node,C_ScanDesc *theScan)
{
  Tuple *tuple;

  assert(node);
   assert(!child);


   if(theScan==0) {		// must be new. Open up a new scan
     theScan = window->StartScan(node->arg);
   }

   tuple = theScan->next_tuple();
   if(theScan->no_match()) {
     window->doMessage("No derivations exist!","");
     return false;
   } 

   child = new Derivation(node->rect,node->text,block,window,false);
   childPos = nodeList->Index(node);
   child->setMenu(menu);
   child->setMenuItemList(menuItemList);
   child->setParent(this,selectedNode);
   child->setScanDesc(theScan);

   Arg *alist = (*tuple)[1];
#ifdef DEBUG
   alist->printon(stderr);
#endif
   if (!is_list(alist)) {
       cerr << "Derivation: Argument should be of type list\n" ;
       return false;
     }

   Arg *alist1 = make_cdr(alist);
   child->addTerms(alist1);

   child->Draw();
   block->Update();    
   return true;
 }
/**********************************************************************
    Inputs: void
   Outputs: void
  Added By: Bill Roth/Wed Dec  2 22:04:29 1992
  Comments: called from menu: Show where the selected predicate is used.
 **********************************************************************/
 void Derivation::ShowUsed()
{
  Arg* arg = selectedNode->arg;
  if(!is_functor(arg)) {
    window->doMessage("Can only show where functors are used.","");
    return ;
  }
  
  World *world = window->GetWorld();
  char str[100],title[300];
  int pos=0;
  
  arg->sprint(str,&pos);
  sprintf(title,"Uses for: %s",str);
  ModuleWindow *newwin = new ModuleWindow(title,true);
  if(newwin->setUsesArg(arg,window->getSuffix())) { // pass nodes arg
    newwin->setMainWindow(window->mainWindow);	    // set the mainwindow
    world->InsertApplication(newwin);		    // show it
  } else {
    window->doMessage("This rule only exists as a head.","");
    delete newwin;
  }
}
/**********************************************************************
   Inputs: the event and the node that it occurred in
  Outputs: void
 Added By: Bill Roth/Mon Nov 23 16:28:08 1992
 Comments: Pop up a menu and do the actions.
**********************************************************************/

void Derivation::ShowMenu(Event& e,Node* node)
{

  assert(menuItemList);
  assert(menu);

  for(int i=0;i<menuItemList->Count();i++){
    NodeMenuItem *n = (NodeMenuItem*)(*menuItemList)[i];
    n->SetCoreClass(this);
  } 
  selectedNode = node;
  menu->Popup(e);
  
}
/**********************************************************************
   Inputs: The list of terms
  Outputs: void
 Added By: Bill Roth/Sat Nov 28 20:32:46 1992
 Comments: add the list of args to the derivation. For each \'car\' in the
 list, insert a term
**********************************************************************/

void Derivation::addTerms(Arg *arglist)
{
  Arg* item;
  while(arglist && is_list(arglist) && (item = make_car(arglist))){
    assert(item);
    arglist = make_cdr(arglist);
    char* name = new char[100];
    int pos = 0;
    item->sprint(name,&pos);
    InsertTerm(name,item);	// leak here
  } 
}
/**********************************************************************
   Inputs: text for the menuitem
  Outputs: a new DerivMenuItem
 Added By: Bill Roth/Mon Nov 23 19:46:15 1992
 Comments: constructor
**********************************************************************/

NodeMenuItem::NodeMenuItem(const char* instance, 
			   const char* str, 
			   Alignment al) : MenuItem(str, al) {
    _func = nil;
    _coreclass = nil;
    SetInstance(instance);
}

/**********************************************************************
   Inputs: Executes the function that the is set up.
  Outputs: nothing
 Added By: Bill Roth/Mon Nov 23 20:59:54 1992
 Comments: 
**********************************************************************/

void NodeMenuItem::Do() {
    if (_func != nil) {
        (_coreclass->*_func)();
    }
}
