// This may look like C code, but it is really -*- C++ -*-

#include "Coral.h"
#include <stdio.h>
#include <Unidraw/unidraw.h>
#include <Unidraw/uarray.h>
#include <InterViews/world.h>
#include <new.h>
#include <assert.h>
#include <strings.h>
#include <ctype.h>
#include <math.h>
#include <sys/param.h>
#include <sys/types.h>
#include <sys/stat.h>

void bomb(void);
#ifndef MODULENAME
#define MODULENAME "coralFuncs.P"
#endif
#ifndef DIRECTORY
#define DIRECTORY "explain"
#endif
extern int errno;
/**********************************************************************
   Inputs: void
  Outputs: constructor
 Added By: Bill Roth/Fri Jan 22 11:11:26 1993
 Comments: forst attempt to load the coralFuncs file from argv0 dir, then
 attempts to do it from CORAL_DIR.
**********************************************************************/

Coral::Coral()
{
  World *w = unidraw->GetWorld();
  char *argv0 = (w->argv())[0];
  char *path,*dir,*ri;
  struct stat statbuf;
  int err;

  dir = (char*)malloc(MAXPATHLEN);
  path = (char*)malloc(MAXPATHLEN);

  strcpy(dir,argv0);

  ri = rindex(dir,'/');
  if(!ri) 
    strcpy(dir,".");
  else 
    ri[0] = 0;
  
#ifdef DEBUG   
  fprintf(stderr,"dir\n");
#endif
  sprintf(path,"%s/%s",dir,MODULENAME);
#ifdef DEBUG   
  fprintf(stderr,"path1 = %s\n",path);
#endif

  err = stat(path,&statbuf);

  if(err == -1) {
    sprintf(path,"%s/%s/%s",exEnv.coral_path,DIRECTORY,MODULENAME);
#ifdef DEBUG   
    fprintf(stderr,"path2 = %s\n",path);
#endif
    err = stat(path,&statbuf);
    if(err == -1) {
      fprintf(stderr,"Cannot load the file %s. Exiting...\n",MODULENAME);
      exit(-1);
    }
  } 

  init_coral(argv0);		// per Praveen\'s instructions

  Consult(path);
  set_new_handler(bomb);
  free(path);
  free(dir);
}
/**********************************************************************
   Inputs: The full path for the file to consult
  Outputs: an integer that should indicate success or failure.
 Added By: Bill Roth/Sat Nov 21 17:29:54 1992
 Comments: returns 1 for success, 0 for fail. consultFile is found in 
 user-builtin1.C
**********************************************************************/

int Coral::Consult(char* path)
{
  char *p=0;
  fprintf(stderr,"consult path = %s\n",path );
  if(path) {
    \[
      consult(($string)$path).
      \]
#ifdef DEBUG   
      fprintf(stderr,"Consult done\n");
#endif
    return 1;
  }
  else
    return 0;

}
/**********************************************************************
   Inputs: a relation name representin an arity 3 def relation
  Outputs: a relation that consists of all of the predicates
 Added By: Bill Roth/Sun Nov 29 15:05:03 1992
 Comments: cheaply materialzes the relation;
**********************************************************************/
Relation* Coral::getPredNames(char*s)
{
  
  Relation* rel = find_relation("prednames",2);

  Tuple *tup = make_tuple(make_arglist(2,make_arg(s),make_var("Pam",0)));
  C_ScanDesc *scan = new C_ScanDesc(rel,tup);

  Tuple *newtup = scan->next_tuple(); // materialize the relation

  delete tup;
  delete scan;
  return rel;
}

Coral::~Coral()
{
  exit_coral();
}

void bomb()
{
  assert(0);
}
