module same_generation.
export sg(bf,ff).


/*  This is the infamous same-generation program.  Different
annotations or combinations of annotations can improve performance
for certain data sets --- try this program with the chain and tree
parent data sets and some of these annotations:

@index_deltas-.
@multiset.
@check_subsumption sg[bf].
@check_subsumption sg[ff].
@check_subsumption m_sg[bf].
@check_subsumption m_sg[ff].


You may also want to try @pipelining, @sup_magic_indexing
or @magic instead of supplementary magic (the default).  */

%@check_subsumption-.

sg(X, Y) :-
	parent(X, XParent), sg(XParent, YParent), parent(Y, YParent).

sg(X, X) :-
	parent(X,Y).

sg(X, X) :-
	parent(Y,X).


end_module.
