
module seqanal2.
export run(bfff).

/*  This program analyses a sequence and generates a result sequence
that describes maximal decreasing/non-decreasing "runs" in the original sequence. 
The input data is in files seq1.F and seq2.F  */

@make_index run[bfff](bbbf).

run(Sname,Date,Dir,max(<L>)) :- trend(Sname,Date,Dir,L).

end_module.


module seqanal1.
export trend(bfff).

@allowed_adornments trend[bfff].
@multiset.
@make_index sequence(bbf).
@non_ground_facts -.

% for each date, trend computes the longest current inc/dec (possibly 
% non-maximal) "run"

% the following rules deal with the case when the "observed trend" (inc/dec)
% continues on the current date.

trend(Sname,Date,nondec,Length) :-
	trend(Sname,Date,nondec,L), D1=Date+L, D2=D1+1,
	member(sequence,Sname,D1,V1), member(sequence,Sname,D2,V2), V2>=V1, Length=L+1.

trend(Sname,Date,dec,Length) :-
	trend(Sname,Date,dec,L), D1=Date+L, D2=D1+1,
	member(sequence,Sname,D1,V1), member(sequence,Sname,D2,V2), V2<V1, Length=L+1.

% the following rules deal with a "change in direction"

trend(Sname,D1,nondec,1) :-
	trend(Sname,Date,dec,L), D1=Date+L, D2=D1+1,
	member(sequence,Sname,D1,V1), member(sequence,Sname,D2,V2), V2>=V1.

trend(Sname,D1,dec,1) :-
	trend(Sname,Date,nondec,L), D1=Date+L, D2=D1+1,
	member(sequence,Sname,D1,V1), member(sequence,Sname,D2,V2), V2<V1.

trend(Sname,Day1,nondec,1) :-
	from(Day1), Day2=Day1+1,
	member(sequence,Sname,Day1,V1), member(sequence,Sname,Day2,V2), V2>=V1.

trend(Sname,Day1,dec,1) :-
	from(Day1), Day2=Day1+1,
	member(sequence,Sname,Day1,V1), member(sequence,Sname,Day2,V2), V2<V1.

end_module.


