
module nqueens.
export queen(bf).
@pipelining.

#define is =

/* This is a program due to L. Pereira, refining a generate-and-test 
program of Bruynooghe's by fusing the two steps.  (Pg. 122 of Tick's
parallel Prolog book.)  */

queen(N,A) :- gen(N,L), queen2(L,[],A).

delete1(Item,[Item|List],List).
delete1(Item,[First|List],[First|List1]) :-
	delete1(Item,List,List1).

safe([],X,Y).
safe([H|T],U,D) :-
	not (H-U)=D,
	not (U-H)=D,
	D1 is D+1,
	safe(T,U,D1).

gen(0,[]).
gen(N,[N|T]) :- N>0, N1 is N-1, gen(N1,T).

queen2([],R,R).
queen2([H|T],R,P) :-
	delete1(A,[H|T],L),
	safe(R,A,1),
	queen2(L,[A|R],P).


end_module.
