module lcs.
export lcs(bbbbbbff), find_lcs(bbff).

/*  This is a program to find the longest common subsequence (LCS) of two 
sequences a and b.  The sequences a and b are input as tuples in a 
relation seq(seq_name,position,char).  We assume for convenience that
a relation seq_length(seq_name,length) is also available.  
The basic algorithm is due to Hirschberg.

The file make_seq.P contains some utility routines that will let you
create input files for this program easily.
There is a file called runlcs that contains a CORAL script.
From the CORAL prompt, if you type "consult(runlcs)", it will
create an input database and execute an lcs query.  Look at this
file (and also the comments in the make_seq.P file) for more
details on the utilities in make_seq.P.

The program uses an internal definition of a predicate lcs:
    lcs( seq_a, start_a, end_a, seq_b, start_b, end_b, len, list) 
whose meaning is that list (of length len) is the longest common subsequence
of the subsequence of seq_a between positions start_a and end_a and
of the subsequence of seq_b between positions start_b and end_b.

For example, the LCS of  "abbcd" and "qbnbcdb" is "bbc". */


@index_deltas-.

% Some simple comparison predicate definitions are in the file comparators.h.
% The include facility allows us to include the contents in many
% other modules, thereby achieving the efficiency of having the code
% be local to each of these modules, while localizing changes to the
% definitions.  This is a useful strategy when the evaluation strategy used
% in the host module is appropriate for the definitions being included.

#include "comparators.h"

find_lcs(A,B,X,L) :- seq_length(A,M1), seq_length(B,N1), lcs(A,1,M1,B,1,N1,X,L).

lcs(A,M1+1,M1,B,N,N1,0,[]).
lcs(A,M,M1,B,N1+1,N1,0,[]).
lcs(A,M,M1,B,N,N1,X,[C|T]) :- M <= M1, 
			N <= N1, 
			seq(A,M,C), 
			seq(B,N,C), 
			lcs(A,M+1,M1,B,N+1,N1,X1,T), 
			X = X1+1.
lcs(A,M,M1,B,N,N1,X,L) :- M <= M1, 
			N <= N1, 
			seq(A,M,C), 
			seq(B,N,D), 
			C ~= D, 
			lcs(A,M+1,M1,B,N,N1,X1,L1), 
			lcs(A,M,M1,B,N+1,N1,X2,L2),
			mmax_choose(X1,L1,X2,L2,X,L).

end_module.


