
module pseries.
export pn(bb).
@sup_magic.

/*  If p(i,j,t), then t is a term that denotes an efficient dataflow graph
for computing prob(i,j) = probability that A wins a first-to-n match
in which A needs to win i more games, B needs to win j more games, and
the two are of equal ability.

The program is taken from Clocksin's JLP April 92 paper.  

The following optional annotations improve performance by exploiting the
functional nature of the program.  (See tak.P, fib.P, etc. for similar
optimization.)   */

@index_deltas-.
@multiset.

pn(X,Y) :- p(X,Y,Z).	% This suppresses printing of a large term.

p(0,J,1) :- J > 0.
p(I,0,0) :- I > 0.
p(I,J,mean(P1,P2)) :- I >= 0, J >= 0,
	I1 = I-1, J1 = J-1, p(I1,J,P1), p(I,J1,P2).

end_module.
