module factorial.
export fac(bf).
@sup_magic +. 	% The default.

/* This is the familiar factorial program.  It can be optimized,
like the programs in tak.P and fib.P, by adding the following annotations.  */

@index_deltas +.
@multiset +.

fac(1, 1).
fac(N, N*X) :- N > 1, fac(N - 1, X).
		
end_module.



module factorial2.
export fac2(bf).

/*  However, the above program is still not as good as this one.  This
is a program in which no goal (or fact) is ever generated twice, and each
iteration generates just one tuple.  Thus, it is a promising candidate
for pipelining; also, indexing "deltas" is never useful with pipelining. 

*/


@index_deltas -.
@pipelining +.

fac2(1, 1).
fac2(N, N1) :- N > 1, fac2(N - 1, X), N1=N*X.
		
end_module.
