

/*  We provide a number of definitions of the even function.  */

module even0.
export even0(b).
@index_deltas -.

/* A definition with non-stratified negation.  It is implemented using
Ordered Search (and some additional rewriting).  Although
this program does not contain cycles of goals, Ordered Search is 
capable of dealing with such cycles, except when a cycle
involves a negated goal, in which case the modularly stratified
semantics is undefined.  

Pipelined evaluation yields a different semantics for negation,
namely negation as failure.  If a predicate defined in a module
is used negatively in the same module, either pipelining
or Ordered Search (the default for programs with
negation or grouping) must be used to evaluate it.  
(See even3 below for an interesting variation.)  */

even0(0).
even0(X) :- X > 1, Y = X-1, not even0(Y).

end_module.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


module even01.
export even01(b).
@index_deltas -.

/* The same as even0; however, it is much less efficient
in the current version of CORAL due to inefficiencies
in the translation of expressions in argument positions.  */

even01(0).
even01(X) :- X > 1, not even01(X-1).

end_module.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

module even1.
export even1(b).
@index_deltas -.
@pipelining +.

/*  The evaluation method is pipelining, and the semantics for negation
is negation as failure.  In this example, the modular stratified
semantics (which holds in non-pipelined modules) and negation as
failure coincide.  */

even1(0).
even1(X) :- X > 1, not even1(X-1).

end_module.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


module even2.
export even2(b).
@index_deltas -.

%  The @use_pipelining annotation would speed up this program.

/*  The same function defined without negation.  Of course,
not all definitions with negation can be replaced by a 
negation-free definition.  */

even2(0).
even2(Y) :- Y>0, X = Y-2, even2(X).

end_module.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


module even22.
export even22(b).
@index_deltas -.
@ordered_search +.

/*  Identical to even2, except for the use of Ordered Search.
The slow-down relative to even2 indicates the overhead of 
doing Ordered Search.  */

even22(0).
even22(Y) :- Y>0, X = Y-2, even22(X).

end_module.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

module even3.
export even3(b).

/*  This module, in conjunction with Module even33, indicates
how the modularly stratified semantics can be realized without
Ordered Search.  A chain of inter-module calls is set up, each of which
is fully evaluated before any answer is returned to the called.
Of course, a cycle of calls would result in infinite looping.  
In contrast, the Ordered Search mechanism deals with cycles, except 
cycles involving a negated call, in which case the modularly stratified
semantics is itself undefined.  This program is also less efficient
than even0 due to the overhead of inter-module calls.  */

even3(0).
even3(X) :- X>1, Y = X-1, not even33(Y).

end_module.

module even33.
export even33(b).

even33(X) :- even3(X).

end_module.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

