module append.
export append(bbf).

/*  This refines the program found in append.P.  By moving the
structure in the bound argument into the body, we avoid creating
some structures at run-time.  However, append is really a program
best suited for Prolog-style evaluation.  In CORAL, this is
approximated by using pipelining; see append.pipe.P.  */

%@index_deltas -.
@check_subsumption -.

append([], X, X).
append(U, Z, [X|W]) :- U=[X|Y], append(Y, Z, W).

end_module.
