
module anc.

/*  (The annotations inside this comment must be moved outside to have any effect.)

This program computes transitive closure.  The default, which is to 
do duplicate checks on all predicates, is likely to be a good choice on
most data sets.  However, if the data is acyclic, or a chain, it might
run faster if duplicate checks were omitted.  In general, since parent 
might contain cycles, it is a good idea to do duplicate checks on at
least m_anc(bf) if magic rewriting is used.  

Also, the set of tuples generated in each iteration is indexed, by default.
If few tuples are generated in each iteration, e.g., if parent is a
chain, this may not be worth while, and indexing can be turned off.

You can run the program as it stands; additional annotations are optional.
To see the effect of these options on different 
parent data sets, try this program with 
different combinations of the following annotations:

@multiset +.	% Turns off duplicates checks on all non-magic predicates.

				% Note convention in name of magic predicates;
				% supplementary magic is done by default.
				% See the file anc-M.P after consulting
				% this file (anc.P) to see rewritten program.

@index_deltas -.	% Turns off indexing on the set (called "delta") of new 
			% anc tuples generated in an iteration.

@factoring +.	% Does a further optimization of the magic program that improves
		% performance for bf queries.  

@psn+.		% Indicates predicate-wise seminaive evaluation within sccs

Several data sets are provided in files named parent.xxx.F.

End of Comment.	*/


export anc(bf,ff). 

@factoring.

anc(X,Y) :- parent(X,Y).
anc(X,Z) :- anc(X,Y), anc(Y,Z).

end_module.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

module ancestor.

/*  Here are different versions of the ancestor program.  (ancestor_r is
identical to anc, defined in the previous module.)  You will note that
they often differ in performance; the effect of annotations also varies.  
Thus, while optimization helps, you can usually improve a program by
a careful choice of  both the logic and the annotations.  Incidentally,
all of the following versions of ancestor can be improved by
using "@factoring.".  */


export ancestor_l(bf,ff), ancestor_r(bf,ff), ancestor_d(bf,ff).


ancestor_l(Descendant, Ancestor) :- parent(Descendant, Ancestor).
ancestor_l(Descendant, Ancestor) :- ancestor_l(Descendant, Parent),
        parent(Parent, Ancestor).


ancestor_r(Descendant, Ancestor) :- parent(Descendant, Ancestor).
ancestor_r(Descendant, Ancestor) :- parent(Descendant, Parent), 
		ancestor_r(Parent, Ancestor).

ancestor_d(Descendant, Ancestor) :- parent(Descendant, Ancestor).
ancestor_d(Descendant, Ancestor) :- ancestor_d(Descendant, Parent),
        ancestor_d(Parent, Ancestor).

end_module.
