module algebra.
export g(f).
@sup_magic.   %  This is the default; doesn't have to be specified.

/*  This is the most simple version of a benchmark program due to
Art Fleck.  There is an algebra with three elements (0,1 and 2)
and one operation (m, defined by the table in algebra.F).
The problem is to compute the larger algebra of 27-element vectors
of 0s, 1s and 2s with an element-wise extension of m.  O'Keefe's
book, The Craft of Prolog, contains an excellent discussion of this
problem and its implementation in Prolog (pp 159-167).  We present
a series of programs illustrating how to solve this problem in CORAL.  

Since this program takes a while to run in its full glory, I suggest
that you compare the different versions with the third rule 
defining g, below, commented out.  You can then run the best of 
the programs (algebra.opt.P) with the third rle for g included, 
if you like.  

The data set for this program is included in this file.  */


/*  This version has terrible performance, and is likely to run out
of memory on many machines.  See algebra2.P for a better solution.  */



g(X) :- g1(X).
g(X) :- g2(X).
%g(X) :- g3(X).		% Comment this rule out for a quick response ...

g(X) :- g(Y),g(Z), mt(Y,Z,X). 


mt([],[],[]).
mt([X|Xt], [Y|Yt], [Z|Zt]) :- m(X,Y,Z), mt(Xt,Yt,Zt).

end_module.

% Data set; note that by placing these facts outside the module,
% they are treated as tuples in a base relation rather than as rules.
% This allows efficient indexing etc.

g1([0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2]).
g2([0,0,0,1,1,1,2,2,2,0,0,0,1,1,1,2,2,2,0,0,0,1,1,1,2,2,2]).
g3([0,1,2,0,1,2,0,1,2,0,1,2,0,1,2,0,1,2,0,1,2,0,1,2,0,1,2]).

m(0,0,0).
m(0,1,0).
m(0,2,0).
m(1,0,0).
m(1,1,0).
m(1,2,1).
m(2,0,0).
m(2,1,2).
m(2,2,2).

