#include <stdio.h>
#include <strings.h>
#include "coral-includes.h"


static void _CORAL_dummytemp__13(); 
static void temp__12();

static char __CORAL_BUILTIN_FAIL;

/*
 * Example of a builtin relation definition that is to be incrementally loaded.
 * This builtin demonstrates the use of Arg * to allow arbitrary CORAL
 * structured arguments to be manipulated by user-defined code.
 */

/*
 * The builtin sum_list(X, Y) takes a list X as its first argument and 
 * returns the summation of the list in the second argument.
 */
int  sum_list(Arg * );
static Tuple * sum_listsolver(Tuple *query)
{
	if (query == NULL) {
	    fprintf(stderr,"Null argument passed to sum_listsolver \n"); 
	    return NULL; 
	} 
	int arity = query->arity(); 
	ArgList *alist = ArgList::New(arity);
	(*alist)[0] = (query->args())[0];
	Arg *  arg0 ; 
	arg0 = (Arg *)((query->args())[0]); 
	int  retvalue ; 
	retvalue = sum_list(arg0);
	if(__CORAL_BUILTIN_FAIL){
		__CORAL_BUILTIN_FAIL=0;
		delete alist;
		return NULL;
	}
	(*alist)[1] = make_arg(retvalue);
	Tuple *return_tuple = new Tuple(alist);
	return return_tuple;
}

int sum_list(Arg *input_list)
{
  int sum = 0;
  Arg *list_head;
  Arg *list_tail;

  /* check that the input argument is indeed a non-empty list */
  if (!input_list || !is_list(input_list)) 
    return 0;

  /* iterate through the list, summing the elements */
  while (1) {

    list_head = make_car(input_list);

    /* break out of the loop at the end of the list */
    if (!(list_tail = make_cdr(input_list))) break;;

    /* check that each list element is an integer */
    if (!list_head || !is_int(list_head)) {
      fprintf(stderr, "WARNING ! : non-integer list member \n");
      fprintf(stderr, "Sum so far is %d\n", sum);
      return -1;
    }

    sum += make_int(list_head);
    input_list = list_tail;
  }

  return sum;
}



static void _CORAL_dummytemp__13()
{
   BuiltinUserTupleRelation *temp__14;
  temp__14 = new BuiltinUserTupleRelation(2,EnterSymbol("sum_list"), sum_listsolver);
}
