
/*
 * Example of the use of the Relation, C_ScanDesc, Tuple and Arg classes
 * and some functions provided in the interface.
 */

#include <stdio.h>

main(int argc, char**argv)
{
  char *rel_name = "data";
  int rel_arity = 2;

  init_coral(argv[0]);

  /* First consult the data file which contains facts of the
   * form data(1,2), data(2,3), etc.
   *
   * The aim of the progam is to add the values of the first
   * argument of each fact, and print the sum.
   */
  \[
	consult(data.F).
  \]

  Relation *rel = find_relation(rel_name, rel_arity);

  C_ScanDesc *scan = new C_ScanDesc(rel);

  Tuple *tuple;
  int sum = 0;

  /*
   * Iterate over the tuples in the relation
   */
  for (tuple = scan->next_tuple(); !(scan->no_match());
					 tuple = scan->next_tuple()) {
    if (!is_int((*tuple)[0])) {
      fprintf(stderr, "non-integer first field !\n");
      exit(1);
    }
    sum += make_int((*tuple)[0]);
  }

  printf("Sum is %d\n", sum);
  exit_coral();
}

