


module declse_eg1.
export phones(ff), employees2(ff),
       works(fff), employees(ff), budget(ff), sals(ff), numsals(ff). 

works(joe,toy,20).
works(jim,toy,20).
works(jane,sales,30).



% the following rule illustrates enumeration

phones(Dept,{"2-5171","2-6172"}) :- employees1(Dept,{jim,joe}).

% The following (commented-out) rule is illegal! A variable cannot
% appear between curly braces.

% employees(Dept,{E}) :- works(E,Dept,Sal).

% To achieve the same effect, the following rule can be used.

employees(Dept,S) :- works(E,Dept,Sal), create_set(S1), add_elem(E, S1, S).


% employees2 illustrates grouping

employees2(Dept,<E>) :- works(E,Dept,Sal).

% budget illustrates multiset operator in head

budget(Dept,sum(<Sal>)) :- works(E,Dept,Sal).

% in budget, the salary 20 is counted twice since it is earned by two people.
% the following rule computes the set of distinct salaries in each department.

sals(Dept,distinct(<Sal>)) :- works(E,Dept,Sal).

% illustrates use of multiset operators in body (count); 
% a large suite of such operators is available in CORAL

numsals(Dept,N) :- sals(Dept,S), count(S,N).


end_module.

