

module declad_eg2.
export sentence(fbb).

/* This program can be made more efficient by using either 
@pipelining. 

or

@return_unify.

*/

/*  This is the translation of a DCG that handles the
syntax and meaning of a small subset of natural language,
taken from Bratko's Prolog book, pg 455.

THe last two arguments of ``sentence'' represent a sentence
in difference list form, and the first argument is instantiated
to a parse tree for this sentence.

Sample queries:  ?sentence(S,[a,man,paints],[]).
		 ?sentence(S,[every,man,that,paints,admires,monet],[]).

*/

sentence(S,List1,Rest) :-
	noun_phrase(X,Assn,S,List1,List2),
	verb_phrase(X,Assn,List2,Rest).

noun_phrase(X,Assn,S,List1,Rest) :-
	determiner(X,Prop12,Assn,S,List1,List2),
	noun(X,Prop1,List2,List3), 
	rel_clause(X,Prop1,Prop12,List3,Rest).
noun_phrase(X,Assn,Assn,List1,Rest) :-
	proper_noun(X,List1,Rest).

verb_phrase(X,Assn,List1,Rest) :-
	trans_verb(X,Y,Assn1,List1,List2), 
	noun_phrase(Y,Assn1,Assn,List2,Rest).
verb_phrase(X,Assn,List1,Rest) :-
	intrans_verb(X,Assn,List1,Rest).

rel_clause(X,Prop1,and(Prop1,Prop2),[that|List1],Rest) :-
	verb_phrase(X,Prop2,List1,Rest).
rel_clause(X,Prop1,Prop1,List1,List1).

determiner(X,Prop,Assn,all(X,implies(Prop,Assn)),[every|List1],List1).
determiner(X,Prop,Assn,exists(X,and(Prop,Assn)),[a|List1],List1).

noun(X,man(X),[man|List1],List1).
noun(X,woman(X),[woman|List1],List1).
	
proper_noun(john,[john|List1],List1).
proper_noun(annie,[annie|List1],List1).
proper_noun(monet,[monet|List1],List1).

trans_verb(X,Y,likes(X,Y),[likes|List1],List1).
trans_verb(X,Y,admires(X,Y),[admires|List1],List1).

intrans_verb(X,paints(X),[paints|List1],List1).

end_module.



