
module declac_eg2.

/*  This program computes transitive closure.  Although existential query 
optimization is not applicable for the query form anc(bf), it is 
applicable for the query form anc1(f).  Look at the module defining 
anc1(f) in file declac2.P.M after consulting this file (declac2.P) 
to see the result of existential query optimization.  

Factoring is applicable for both query forms.  Again, you can see what
effect this has by examining the .P.M file.  (The @factoring annotation
is commented out below; you must include it for factoring to be 
effected.) Using the data sets in declac1a.F and declac1b.F, time the 
query ?anc(1,X) and ?anc1(X) and see the effect of the optimizations.  */

export anc(bf), anc1(f). 

% @factoring+.

anc1(X) :- anc(X,Y).		%  Y can be replaced by _ ("don't care" variable)

anc(X,Y) :- parent(X,Y).
anc(X,Z) :- parent(X,Y), anc(Y,Z).

end_module.


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

module ancestor.

/*  Here are different versions of the ancestor program.  (ancestor_r is
identical to anc, defined in the previous module.)  You will note that
they often differ in performance; the effect of annotations also varies.  
Thus, while optimization helps, you can usually improve a program by
a careful choice of  both the logic and the annotations.  Incidentally,
all of the following versions of ancestor can be improved by
using "@factoring.".  */


export ancestor_l(bf,ff), ancestor_r(bf,ff), ancestor_d(bf,ff).


ancestor_l(Descendant, Ancestor) :- parent(Descendant, Ancestor).
ancestor_l(Descendant, Ancestor) :- ancestor_l(Descendant, Parent),
        parent(Parent, Ancestor).


ancestor_r(Descendant, Ancestor) :- parent(Descendant, Ancestor).
ancestor_r(Descendant, Ancestor) :- parent(Descendant, Parent), 
	ancestor_r(Parent, Ancestor).

ancestor_d(Descendant, Ancestor) :- parent(Descendant, Ancestor).
ancestor_d(Descendant, Ancestor) :- ancestor_d(Descendant, Parent),
        ancestor_d(Parent, Ancestor).

end_module.
