/************************************************************************
 ========================================================================
 CORAL 
 (c)  Copyright R. Ramakrishnan and The CORAL Group, 
 University of Wisconsin at Madison.
 (1992) All Rights Reserved.
 Version 0.1
 ========================================================================



 ------------------------------------------------------------------------
 CORAL Version 0.1
 RESEARCH SOFTWARE DISCLAIMER -------------------------------------------
 ------------------------------------------------------------------------

    As unestablished, research software, this program is provided free of 
    charge on an "as is" basis without warranty of any kind, either 
    express or implied.  Acceptance and use of this program constitutes 
    the user's understanding that (s)he will have no recourse for any 
    actual or consequential damages, including, but not limited to, 
    lost profits or savings, arising out of the use of or inability to 
    use this program.  

 ------------------------------------------------------------------------
 USER AGREEMENT ---------------------------------------------------------
 ------------------------------------------------------------------------

     BY ACCEPTANCE AND USE OF THIS EXPERIMENTAL PROGRAM
     THE USER AGREES TO THE FOLLOWING:

     a.  This program is provided free of charge for the user's personal, 
	 non-commercial, experimental use.

     b.  All title, ownership and rights to this program and any copies 
         remain with the copyright holder, irrespective of the ownership 
	 of the media on which the program resides.

     c.  The user is permitted to create derivative works to this program.  
         However, all copies of the program and its derivative works must
         contain the CORAL copyright notice, the UNESTABLISHED SOFTWARE 
         DISCLAIMER and this USER AGREEMENT.

     d.  The user understands and agrees that this program and any 
         derivative works are to be used solely for experimental purposes 
	 and are not to be sold or commercially exploited in any manner 
	 WITHOUT EXPRESS WRITTEN PERMISSION.

     e.  We request that the user supply us with a copy of any changes, 
         enhancements, or derivative works which the user may create,
	 with the user's permission to redistribute it.
	 Copies of such material should be sent to:  CORAL@CS.WISC.EDU

-------------------------------------------------------------------------
*************************************************************************/

/***********************************************************************
	CORAL Software :: U.W.Madison

	parser.h : Header file

	Included with the parser 'gram.y'. Has declarations for
	manipulating the file stack associated with the scanner.
	This is a mechanism for allowing dynamic redirection of
	scanner input.

	Contains the following class/type  declarations	 :
	 struct fcell
	 FStack
 ***********************************************************************/

#ifndef CORAL_PARSER_H
#define CORAL_PARSER_H
#include <string.h>
#include "scanner.h"
#include "globals.h"

/*
 * This structure is a stack of file descriptors to be used by the
 * scanner. The topmost file descriptor is the current file in use.
 * when it reaches EOF, it is popped, and if the stack is empty,
 * scanning terminates. To start reading from a new file fd, push
 * fd on the stack and set yyin to the top of the stack.
 */

typedef struct FStack FStack ;

extern FStack fileStack ;

struct fcell {
    FILE *fd ;
    char *filename;
    int cur_line_num;
    struct fcell *next ;
};

struct FStack {
    struct fcell * top ;
    FStack() { top = NULL ; } ;
    inline void push(FILE * fd1, int line_num,char*fname = NULL) { 
                   struct fcell *tmp = new struct fcell;
		   tmp->fd = fd1 ;tmp->next = top ;
		   if (fname) {
		     tmp->filename = new char[strlen(fname)+1];
		     strcpy(tmp->filename, fname);
		   }
		   else tmp->filename = NULL ;
		   tmp->cur_line_num = line_num;
		   top = tmp ;	 
		 }

    inline void pop() { struct fcell *tmp = top->next;
			if (top->filename) delete [] top->filename;
			delete top ; top = tmp ; 
		      }
    inline char *top_file_name() { return top->filename; }
    inline FILE *top_file() { return top->fd ; }
    inline int top_file_line() { return top->cur_line_num;}
    inline void set_top_file_line(int i) { if(top) top->cur_line_num=i;}
    inline int is_empty() { return (top == NULL) ;}
 };

#endif /* !CORAL_PARSER_H */
